/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.presentation.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RoomPlugin
extends AbstractUIPlugin {
    public static String PLUGIN_ID = "org.eclipse.actf.visualization.presentation";
    private static RoomPlugin _plugin;
    private static BundleContext _context;
    private static File tmpDir;

    public RoomPlugin() {
        _plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        String tmpS;
        super.start(context);
        _context = context;
        RoomPlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(tmpS = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "html"))) {
            String en = String.valueOf(tmpS) + File.separator + "en";
            String ja = String.valueOf(tmpS) + File.separator + "ja";
            String images = String.valueOf(tmpS) + File.separator + "images";
            Bundle bundle = this.getBundle();
            if (FileUtils.isAvailableDirectory((String)en) && FileUtils.isAvailableDirectory((String)ja) && FileUtils.isAvailableDirectory((String)images)) {
                en = String.valueOf(en) + File.separator;
                ja = String.valueOf(ja) + File.separator;
                images = String.valueOf(images) + File.separator;
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/large.html"), (String)(String.valueOf(en) + "large.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/middle.html"), (String)(String.valueOf(en) + "middle.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/en/small.html"), (String)(String.valueOf(en) + "small.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/large.html"), (String)(String.valueOf(ja) + "large.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/middle.html"), (String)(String.valueOf(ja) + "middle.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/ja/small.html"), (String)(String.valueOf(ja) + "small.html"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/auditorium.png"), (String)(String.valueOf(images) + "auditorium.png"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/largeMeetingRoom.png"), (String)(String.valueOf(images) + "largeMeetingRoom.png"), (boolean)true);
                FileUtils.copyFile((Bundle)bundle, (IPath)new Path("html/images/smallMeetingRoom.png"), (String)(String.valueOf(images) + "smallMeetingRoom.png"), (boolean)true);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.deleteFiles(tmpDir);
        _plugin = null;
        _context = null;
    }

    public static RoomPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getDirectory(String dir) {
        try {
            URL url = _context.getBundle().getEntry(dir);
            url = FileLocator.resolve((URL)url);
            return new Path(url.getPath()).makeAbsolute().toOSString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    public static String getTempDirectory() {
        if (tmpDir != null) {
            return String.valueOf(tmpDir.getAbsolutePath()) + File.separator;
        }
        return "";
    }

    private static void createTempDirectory() {
        String tmpS;
        if (tmpDir == null && FileUtils.isAvailableDirectory((String)(tmpS = String.valueOf(_plugin.getStateLocation().toOSString()) + File.separator + "tmp"))) {
            tmpDir = new File(tmpS);
        }
    }

    public static File createTempFile(String prefix, String suffix) throws Exception {
        RoomPlugin.createTempDirectory();
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    private void deleteFiles(File rootDir) {
        if (rootDir != null) {
            File[] fileList = rootDir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    this.deleteFiles(fileList[i]);
                }
                fileList[i].delete();
                ++i;
            }
        }
    }
}

