/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPReader;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public abstract class HTTPMessageReader
extends HTTPReader {
    private static final Logger LOGGER = Logger.getLogger(HTTPMessageReader.class);

    protected HTTPMessageReader(InputStream in) {
        super(in);
    }

    protected abstract void readFirstLine(HTTPMessage var1, long var2) throws IOException, TimeoutException;

    protected void processHeader(HTTPMessage msg, IHTTPHeader header) {
    }

    public void readMessage(HTTPMessage msg, boolean isBodyEmpty) throws IOException {
        try {
            this.readMessage(msg, 0L, isBodyEmpty);
        }
        catch (TimeoutException e) {
            LOGGER.fatal("Impossible exception", e);
            System.exit(1);
        }
    }

    public boolean readMessage(HTTPMessage msg, long timeout, boolean isBodyEmpty) throws IOException, TimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("read: isBodyEmpty=" + isBodyEmpty);
        }
        this.readFirstLine(msg, timeout);
        int contentLength = -1;
        while (this.fLastByte >= 0) {
            HeaderInBuffer header = this.readHeader(timeout, msg.getBuffer());
            if (header == null) break;
            msg.addHeader(header);
            if (LOGGER.isDebugEnabled()) {
                String name = new String(header.getName());
                String value = new String(header.getValue());
                LOGGER.debug(String.valueOf(name) + ": " + value);
            }
            if (header.isFieldNameEqualsTo(IHTTPHeader.CONTENT_LENGTH_A)) {
                String v = new String(header.getValue());
                if (v.length() > 0) {
                    try {
                        contentLength = Integer.parseInt(v);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warning("Illegal header fieald (CONTENT_LENGTH) ignored: " + v);
                    }
                }
            } else if (header.isFieldNameEqualsTo(IHTTPHeader.TRANSFER_ENCODING_A) && header.isFieldValueEqualsTo(IHTTPHeader.CHUNKED_A)) {
                msg.setChunkedEncoding(true);
            }
            this.processHeader(msg, header);
        }
        if (isBodyEmpty |= msg.isBodyEmpty()) {
            LOGGER.debug("The message body is empty.");
        } else {
            MessageBody msgBody = msg.isChunkedEncoding() ? new MessageBody(this.getInputStream()) : new MessageBody(this.getInputStream(), contentLength);
            msg.setOriginalMessageBody(msgBody);
        }
        return true;
    }
}

