/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl;

import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IElementViewerManager;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.IViewerPanel;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.IVisualizeStyleInfoListener;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.ViewerPanelJFace;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfo;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfoManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ElementViewerManager
implements IVisualizeStyleInfoListener,
IElementViewerManager {
    private IViewerPanel viewerPanel;
    private IHighlightElementListener highlightElementListener;
    private VisualizeStyleInfo styleInfo;
    private Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

    public ElementViewerManager() {
        VisualizeStyleInfoManager.getInstance().addLisnter(this);
    }

    public void setHighlightElementListener(IHighlightElementListener hel) {
        this.highlightElementListener = hel;
    }

    public void openElementViewer() {
        if (this.isExist()) {
            this.viewerPanel.forceActive();
        } else {
            this.viewerPanel = new ViewerPanelJFace(this.shell, this.styleInfo, this.highlightElementListener);
        }
    }

    public void activateElementViewer() {
        if (this.isExist()) {
            this.viewerPanel.forceActive();
        }
    }

    public void hideElementViewer() {
        if (this.isExist()) {
            this.viewerPanel.hide();
        }
    }

    public void update(VisualizeStyleInfo styleInfo) {
        this.styleInfo = styleInfo;
        if (this.isExist()) {
            this.viewerPanel.asyncUpdateValue(styleInfo);
        }
    }

    private boolean isExist() {
        return this.viewerPanel != null && !this.viewerPanel.isDisposed();
    }
}

