/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageFileReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.IoUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.JPEGReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.PBMReader;

public class ImageReader {
    public static BufferedImage readBufferedImage(String _fileName) throws LowVisionIOException {
        short type = IoUtil.getFileType(_fileName);
        if (type != 0) {
            return ImageReader.readBufferedImage(_fileName, type);
        }
        throw new LowVisionIOException("Unknown image format: _fileName");
    }

    public static BufferedImage readBufferedImage(String _fileName, short _type) throws LowVisionIOException {
        BufferedImage bufIm = null;
        if (_type == 1) {
            bufIm = BMPReader.readBufferedImage(_fileName);
        } else if (_type == 2) {
            bufIm = JPEGReader.readBufferedImage(_fileName);
        } else if (_type == 5) {
            bufIm = ImageFileReader.readBufferedImage(_fileName);
        } else if (_type == 6) {
            bufIm = ImageFileReader.readBufferedImage(_fileName);
        } else {
            throw new LowVisionIOException("Unknown image format: _fileName");
        }
        if (bufIm == null) {
            throw new LowVisionIOException("The image file cannot be read: " + _fileName);
        }
        return bufIm;
    }

    public static IInt2D readInt2D(String _fileName) throws LowVisionIOException {
        try {
            return ImageUtil.bufferedImageToInt2D(ImageReader.readBufferedImage(_fileName));
        }
        catch (ImageException e) {
            e.printStackTrace();
            throw new LowVisionIOException("ImageException occurred while converting BufferedImage into Int2D.");
        }
    }

    public static IInt2D readInt2D(String _fileName, short _type) throws LowVisionIOException {
        try {
            return ImageUtil.bufferedImageToInt2D(ImageReader.readBufferedImage(_fileName, _type));
        }
        catch (ImageException e) {
            e.printStackTrace();
            throw new LowVisionIOException("ImageException occurred while converting BufferedImage into Int2D.");
        }
    }

    public static BinaryImage readBinaryImage(String _fileName) throws LowVisionIOException {
        short type = IoUtil.getFileType(_fileName);
        if (type != 0) {
            return ImageReader.readBinaryImage(_fileName, type);
        }
        throw new LowVisionIOException("Unknown image format.");
    }

    public static BinaryImage readBinaryImage(String _fileName, short _type) throws LowVisionIOException {
        if (_type == 3) {
            return PBMReader.readBinaryImage(_fileName);
        }
        throw new LowVisionIOException("Unknown image format.");
    }
}

