/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;

public class Vector3D {
    double x;
    double y;
    double z;

    public Vector3D(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public static boolean isZeroVector(Vector3D _a) {
        return _a.x == 0.0 && _a.y == 0.0 && _a.z == 0.0;
    }

    public boolean isZeroVector() {
        return Vector3D.isZeroVector(this);
    }

    public static double magnitude2(Vector3D _a) {
        return _a.x * _a.x + _a.y * _a.y + _a.z * _a.z;
    }

    public double magnitude2() {
        return Vector3D.magnitude2(this);
    }

    public static double magnitude(Vector3D _a) {
        return Math.sqrt(Vector3D.magnitude2(_a));
    }

    public double magnitude() {
        return Vector3D.magnitude(this);
    }

    public static Vector3D add(Vector3D _a, Vector3D _b) {
        return new Vector3D(_a.x + _b.x, _a.y + _b.y, _a.z + _b.z);
    }

    public Vector3D add(Vector3D _a) {
        return Vector3D.add(this, _a);
    }

    public static Vector3D subtract(Vector3D _a, Vector3D _b) {
        return new Vector3D(_a.x - _b.x, _a.y - _b.y, _a.z - _b.z);
    }

    public Vector3D subtractFrom(Vector3D _a) {
        return Vector3D.subtract(_a, this);
    }

    public Vector3D subtractedBy(Vector3D _b) {
        return Vector3D.subtract(this, _b);
    }

    public static double innerProduct(Vector3D _a, Vector3D _b) {
        return _a.x * _b.x + _a.y * _b.y + _a.z * _b.z;
    }

    public static double cosine(Vector3D _a, Vector3D _b) throws ImageException {
        if (Vector3D.isZeroVector(_a) || Vector3D.isZeroVector(_b)) {
            throw new ImageException("Cannot calculate cosine of zero-vectors");
        }
        double answer = Vector3D.innerProduct(_a, _b) / (Vector3D.magnitude(_a) * Vector3D.magnitude(_b));
        if (answer < -1.0) {
            answer = -1.0;
        } else if (1.0 < answer) {
            answer = 1.0;
        }
        return answer;
    }

    public double cosine(Vector3D _a) throws ImageException {
        return Vector3D.cosine(this, _a);
    }

    public static double angle(Vector3D _a, Vector3D _b) throws ImageException {
        return Math.acos(Vector3D.cosine(_a, _b));
    }

    public double angle(Vector3D _a) throws ImageException {
        return Vector3D.angle(this, _a);
    }

    public static double sine(Vector3D _a, Vector3D _b) throws ImageException {
        return Math.sin(Vector3D.angle(_a, _b));
    }

    public double sine(Vector3D _a) throws ImageException {
        return Vector3D.sine(this, _a);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        _pw.println("-----");
        _pw.println("dumping Vector3D");
        _pw.println("(x,y,z) = ( " + this.x + ", " + this.y + ", " + this.z + ")");
        _pw.println("-----");
    }
}

