/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.LowVisionProblemConverter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateUnderlinedCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogram;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageImage
implements IPageImage {
    private static final String NULL_STRING = "";
    public static final boolean DO_CHECK_CHARACTERS = false;
    public static final boolean DO_CHECK_IMAGES = true;
    private static int SURROUNDINGS_WIDTH = 2;
    private static int SCROLL_BAR_WIDTH = 20;
    private static boolean REMOVE_SURROUNDINGS = true;
    private static boolean REMOVE_SCROLL_BAR_AT_RIGHT = false;
    private static boolean REMOVE_SCROLL_BAR_AT_BOTTOM = false;
    private static int THRESHOLD_MIN_OCCURRENCES = 300;
    public IInt2D pixel = null;
    int numContainers;
    Container[] containers;
    int numNonContainedCharacters;
    CharacterSM[] nonContainedCharacters;
    boolean extractedFlag = false;
    public ImagePositionInfo[] imagePositions = null;
    public boolean useImagePositions = false;
    public InteriorImage[] interiorImageArray = null;
    int currentContainerID = 1;
    int[][] containerMap = null;
    Vector<Container> containerVector = new Vector();
    Vector<CandidateCharacter> candidateCharacterVector = new Vector();
    Vector<CandidateUnderlinedCharacter> candidateUnderlinedCharacterVector = new Vector();
    PrintWriter writer = null;

    public PageImage() {
    }

    public PageImage(IInt2D _i2d) {
        this(_i2d, true);
    }

    public PageImage(IInt2D _i2d, boolean _removeScrollBar) {
        IInt2D i2d = null;
        if (_removeScrollBar) {
            int i;
            int j;
            Int2D tmpI2d;
            if (REMOVE_SURROUNDINGS) {
                try {
                    i2d = _i2d.cutMargin(SURROUNDINGS_WIDTH);
                }
                catch (ImageException imageException) {
                    i2d = _i2d;
                }
            } else {
                i2d = _i2d;
            }
            if (REMOVE_SCROLL_BAR_AT_RIGHT) {
                tmpI2d = new Int2D(i2d.getWidth() - SCROLL_BAR_WIDTH, i2d.getHeight());
                j = 0;
                while (j < tmpI2d.getHeight()) {
                    i = 0;
                    while (i < tmpI2d.getWidth()) {
                        tmpI2d.getData()[j][i] = i2d.getData()[j][i];
                        ++i;
                    }
                    ++j;
                }
                i2d = tmpI2d;
            }
            if (REMOVE_SCROLL_BAR_AT_BOTTOM) {
                tmpI2d = new Int2D(i2d.getWidth(), i2d.getHeight() - SCROLL_BAR_WIDTH);
                j = 0;
                while (j < tmpI2d.getHeight()) {
                    i = 0;
                    while (i < tmpI2d.getWidth()) {
                        tmpI2d.getData()[j][i] = i2d.getData()[j][i];
                        ++i;
                    }
                    ++j;
                }
                i2d = tmpI2d;
            }
        } else {
            i2d = _i2d;
        }
        this.pixel = i2d.deepCopy();
        i2d = null;
    }

    public void init(BufferedImage _bi) throws ImageException {
        this.pixel = ImageUtil.bufferedImageToInt2D(_bi);
    }

    public static IPageImage readFromFile(String _fileName) throws LowVisionIOException {
        BufferedImage bi = ImageReader.readBufferedImage(_fileName);
        Int2D i2d = new Int2D(bi);
        PageImage pi = new PageImage(i2d);
        return pi;
    }

    @Override
    public int getWidth() {
        return this.pixel.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixel.getHeight();
    }

    public int[][] getPixelData() {
        return this.pixel.getData();
    }

    @Override
    public BufferedImage getBufferedImage() {
        return ImageUtil.int2DToBufferedImage(this.pixel);
    }

    public IInt2D getInt2D() {
        return this.pixel;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public Container[] getContainers() {
        return this.containers;
    }

    public int getNumSMCharacters() {
        return this.numNonContainedCharacters;
    }

    public CharacterSM[] getSMCharacters() {
        return this.nonContainedCharacters;
    }

    public int getNumNonContainedCharacters() {
        return this.numNonContainedCharacters;
    }

    public CharacterSM[] getNonContainedCharacters() {
        return this.nonContainedCharacters;
    }

    public void setWriter(PrintWriter _pw) {
        this.writer = _pw;
    }

    @Override
    public ImagePositionInfo[] getInteriorImagePosition() {
        return this.imagePositions;
    }

    @Override
    public void setInteriorImagePosition(ImagePositionInfo[] infoArray) {
        if (infoArray != null) {
            this.imagePositions = infoArray;
        }
    }

    @Override
    public boolean hasInteriorImageArraySet() {
        return this.interiorImageArray != null && this.interiorImageArray.length != 0;
    }

    @Override
    public void extractCharacters() throws ImageException {
        if (this.imagePositions != null && this.imagePositions.length > 0) {
            this.useImagePositions = true;
        }
    }

    public void extractInteriorImages() {
        int k;
        if (this.imagePositions == null) {
            return;
        }
        int numImages = this.imagePositions.length;
        Vector<InteriorImage> imageVector = new Vector<InteriorImage>();
        if (REMOVE_SURROUNDINGS) {
            k = 0;
            while (k < numImages) {
                ImagePositionInfo pos = this.imagePositions[k];
                pos.setX(pos.getX() - SURROUNDINGS_WIDTH);
                if (pos.getX() < 0) {
                    pos.setX(0);
                }
                pos.setY(pos.getY() - SURROUNDINGS_WIDTH);
                if (pos.getY() < 0) {
                    pos.setY(0);
                }
                ++k;
            }
        }
        k = 0;
        while (k < numImages) {
            ImagePositionInfo curPos = this.imagePositions[k];
            if (this.isFullyContained(curPos)) {
                InteriorImage curIm = new InteriorImage(this, curPos);
                curIm.setImageElement(curPos.getElement());
                imageVector.addElement(curIm);
            }
            ++k;
        }
        int size = imageVector.size();
        if (size > 0) {
            this.interiorImageArray = new InteriorImage[size];
            int k2 = 0;
            while (k2 < size) {
                this.interiorImageArray[k2] = (InteriorImage)imageVector.elementAt(k2);
                ++k2;
            }
        }
    }

    private boolean isFullyContained(ImagePositionInfo _pos) {
        if (_pos.getX() + _pos.getWidth() > this.getWidth()) {
            return false;
        }
        return _pos.getY() + _pos.getHeight() <= this.getHeight();
    }

    public void extractAllCharacters() throws ImageException {
        int len;
        if (this.extractedFlag) {
            return;
        }
        int numProcessedColors = 0;
        this.containerMap = new int[this.pixel.getHeight()][this.pixel.getWidth()];
        ColorHistogram histogram = ColorHistogram.makeColorHistogram(this.pixel);
        numProcessedColors = len = histogram.getSize();
        ColorHistogramBin[] histoArray = histogram.getSortedArrayByOccurrence();
        int i = 0;
        while (i < len) {
            if (histoArray[i].occurrence < THRESHOLD_MIN_OCCURRENCES) {
                numProcessedColors = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < numProcessedColors) {
            int curColor = histoArray[i].color;
            BinaryImage binaryByColor = new BinaryImage(this.pixel, 0, curColor);
            LabeledImage curLabeledImage = new LabeledImage(binaryByColor, 0);
            int numComponents = curLabeledImage.numComponents;
            ConnectedComponent[] components = curLabeledImage.components;
            int j = 0;
            while (j < numComponents) {
                ConnectedComponent cc = components[j];
                short type = DecisionMaker.judgeComponentType(cc, this, true);
                if (type == 1) {
                    Container tmpContainer = new Container(this, this.currentContainerID, cc, curColor);
                    this.containerVector.addElement(tmpContainer);
                    this.paintContainerMap(this.currentContainerID, cc);
                    ++this.currentContainerID;
                } else if (type == 2) {
                    CandidateCharacter tmpC = new CandidateCharacter(this, cc, curColor);
                    this.candidateCharacterVector.addElement(tmpC);
                } else if (type == 3) {
                    CandidateUnderlinedCharacter tmpU = new CandidateUnderlinedCharacter(this, cc, curColor);
                    this.candidateUnderlinedCharacterVector.addElement(tmpU);
                } else if (type != 100) {
                    throw new ImageException("Unexpected type = " + type);
                }
                ++j;
            }
            ++i;
        }
        this.fillContainerMap(this.currentContainerID);
        int numCandChar = this.candidateCharacterVector.size();
        int k = numCandChar - 1;
        while (k >= 0) {
            CandidateCharacter cChar = this.candidateCharacterVector.elementAt(k);
            int w = cChar.cc.shape.width;
            int i2 = 0;
            while (i2 < w) {
                if (cChar.cc.shape.data[0][i2] != 0) break;
                ++i2;
            }
            int id = this.containerMap[cChar.cc.top][cChar.cc.left + i2];
            if (id > 0) {
                Container parentCont = this.containerVector.elementAt(id - 1);
                cChar.setContainer(parentCont);
                parentCont.candidateCharacterVector.addElement(cChar);
                this.candidateCharacterVector.removeElementAt(k);
            }
            --k;
        }
        int numCandUnderChar = this.candidateUnderlinedCharacterVector.size();
        int k2 = numCandUnderChar - 1;
        while (k2 >= 0) {
            CandidateUnderlinedCharacter cuChar = this.candidateUnderlinedCharacterVector.elementAt(k2);
            int w = cuChar.cc.shape.width;
            int i3 = 0;
            while (i3 < w) {
                if (cuChar.cc.shape.data[0][i3] != 0) break;
                ++i3;
            }
            int id = this.containerMap[cuChar.cc.top][cuChar.cc.left + i3];
            if (id > 0) {
                Container parentCont = this.containerVector.elementAt(id - 1);
                cuChar.setContainer(parentCont);
                parentCont.candidateUnderlinedCharacterVector.addElement(cuChar);
                this.candidateUnderlinedCharacterVector.removeElementAt(k2);
            }
            --k2;
        }
        Vector<CharacterSM> tmpSMCharacterVector = this.makeSMCharacterVector(this.candidateCharacterVector, this.candidateUnderlinedCharacterVector);
        this.candidateCharacterVector.removeAllElements();
        this.candidateUnderlinedCharacterVector.removeAllElements();
        int tmpTmpSMVecSize = tmpSMCharacterVector.size();
        int k3 = tmpTmpSMVecSize - 1;
        while (k3 >= 0) {
            CharacterSM tmpSM = tmpSMCharacterVector.elementAt(k3);
            if (!DecisionMaker.isSMCharacter(tmpSM)) {
                tmpSMCharacterVector.removeElementAt(k3);
            }
            --k3;
        }
        this.numNonContainedCharacters = tmpSMCharacterVector.size();
        this.nonContainedCharacters = new CharacterSM[this.numNonContainedCharacters];
        k3 = 0;
        while (k3 < this.numNonContainedCharacters) {
            this.nonContainedCharacters[k3] = tmpSMCharacterVector.elementAt(k3);
            ++k3;
        }
        tmpSMCharacterVector.removeAllElements();
        tmpSMCharacterVector = null;
        int numContainer = this.containerVector.size();
        int k4 = 0;
        while (k4 < numContainer) {
            Container curCont = this.containerVector.elementAt(k4);
            int contW = curCont.cc.shape.width;
            int contH = curCont.cc.shape.height;
            int contX = curCont.cc.left;
            int contY = curCont.cc.top;
            int contColor = curCont.getColor();
            BinaryImage contBin = new BinaryImage(contW, contH);
            BinaryImage filledContBin = new BinaryImage(contW, contH);
            int j = 0;
            while (j < contH) {
                int i4 = 0;
                while (i4 < contW) {
                    int curPixel = this.pixel.getData()[j + contY][i4 + contX];
                    try {
                        if (curPixel == contColor) {
                            contBin.data[j][i4] = 1;
                        }
                    }
                    catch (Exception exception) {
                        throw new ImageException("An error occurred while making contBin.");
                    }
                    if (this.containerMap[j + contY][i4 + contX] == k4 + 1) {
                        filledContBin.data[j][i4] = 1;
                    }
                    ++i4;
                }
                ++j;
            }
            BinaryImage fgBin = BinaryImage.subtract(filledContBin, contBin);
            LabeledImage curLabImg = new LabeledImage(fgBin, 0);
            int numComponents = curLabImg.numComponents;
            if (numComponents != 0) {
                CharacterSS ssc;
                ConnectedComponent[] components = curLabImg.components;
                int l = numComponents - 1;
                while (l >= 0) {
                    ConnectedComponent cc2 = components[l];
                    cc2.setLeft(cc2.getLeft() + contX);
                    cc2.setTop(cc2.getTop() + contY);
                    if (!this.collateCandidates(curCont, cc2) && DecisionMaker.isMSCharacter(cc2)) {
                        int fg = -1;
                        fg = this.getForegroundColor(cc2);
                        if (fg == -1) {
                            CharacterMS msc = new CharacterMS((IPageImage)this, cc2, curCont, this.pixel);
                            curCont.msCharacterVector.addElement(msc);
                        } else {
                            short ssType = DecisionMaker.judgeComponentType(cc2, this);
                            if (ssType == 2) {
                                ssc = new CharacterSS(this, cc2, curCont, fg);
                                curCont.ssCharacterVector.addElement(ssc);
                            } else if (ssType == 3) {
                                CandidateUnderlinedCharacter cuc = new CandidateUnderlinedCharacter(this, cc2, fg);
                                cuc.setContainer(curCont);
                                curCont.ssCharacterVector.addAll(this.removeUnderlineAndGenerateSS(cuc));
                            }
                        }
                    }
                    --l;
                }
                Vector<CharacterSM> tmpVec = this.makeSMCharacterVector(curCont.candidateCharacterVector, curCont.candidateUnderlinedCharacterVector);
                curCont.candidateCharacterVector.removeAllElements();
                curCont.candidateUnderlinedCharacterVector.removeAllElements();
                int tmpVecSize = tmpVec.size();
                int l2 = tmpVecSize - 1;
                while (l2 >= 0) {
                    CharacterSM smc = tmpVec.elementAt(l2);
                    if (smc.getForegroundColor() == curCont.getColor()) {
                        tmpVec.removeElementAt(l2);
                    } else if (this.includingMSCharacter(smc, curCont) != null) {
                        tmpVec.removeElementAt(l2);
                    } else if (this.getBackgroundColor(smc.cc) > -1) {
                        ssc = new CharacterSS(this, smc.cc, smc.container, smc.getForegroundColor());
                        curCont.ssCharacterVector.addElement(ssc);
                        tmpVec.removeElementAt(l2);
                    }
                    --l2;
                }
                int msVecSize = curCont.msCharacterVector.size();
                int l3 = msVecSize - 1;
                while (l3 >= 0) {
                    CharacterMS curMS = curCont.msCharacterVector.elementAt(l3);
                    if (DecisionMaker.isTooSmallThinedMSCharacter(curMS)) {
                        curCont.msCharacterVector.removeElementAt(l3);
                    }
                    --l3;
                }
                curCont.ssVector2Array();
                curCont.msVector2Array();
                int tmptmpVecSize = tmpVec.size();
                int l4 = tmptmpVecSize - 1;
                while (l4 >= 0) {
                    CharacterSM tmpSM = tmpVec.elementAt(l4);
                    if (!DecisionMaker.isSMCharacter(tmpSM)) {
                        tmpVec.removeElementAt(l4);
                    }
                    --l4;
                }
                curCont.numSMCharacters = tmpVec.size();
                curCont.smCharacters = new CharacterSM[curCont.numSMCharacters];
                l4 = 0;
                while (l4 < curCont.numSMCharacters) {
                    curCont.smCharacters[l4] = tmpVec.elementAt(l4);
                    ++l4;
                }
                tmpVec.removeAllElements();
                tmpVec = null;
            }
            ++k4;
        }
        k4 = numContainer - 1;
        while (k4 >= 0) {
            Container curCont = this.containerVector.elementAt(k4);
            if (curCont.numSSCharacters == 0 && curCont.numMSCharacters == 0 && curCont.numSMCharacters == 0) {
                this.containerVector.removeElementAt(k4);
            }
            --k4;
        }
        this.numContainers = this.containerVector.size();
        this.containers = new Container[this.numContainers];
        k4 = 0;
        while (k4 < this.numContainers) {
            this.containers[k4] = this.containerVector.elementAt(k4);
            ++k4;
        }
        this.containerVector.removeAllElements();
        this.extractedFlag = true;
    }

    private void paintContainerMap(int _id, ConnectedComponent _cc) {
        int w = _cc.shape.width;
        int h = _cc.shape.height;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (_cc.shape.data[j][i] != 0) {
                    this.containerMap[_cc.top + j][_cc.left + i] = _id;
                }
                ++i;
            }
            ++j;
        }
    }

    private void fillContainerMap(int _lastID) throws ImageException {
        int i = 1;
        while (i < _lastID) {
            this.fillOneContainer(i);
            ++i;
        }
    }

    private void fillOneContainer(int _id) throws ImageException {
        Container curCont = this.containerVector.elementAt(_id - 1);
        int curX0 = curCont.cc.left;
        int curY0 = curCont.cc.top;
        int curX1 = curX0 + curCont.cc.shape.width;
        int curY1 = curY0 + curCont.cc.shape.height;
        int[][] workMap = new int[this.pixel.getHeight()][this.pixel.getWidth()];
        int j = curY0;
        while (j < curY1) {
            boolean mostLeftFound = false;
            boolean otherContainerLeft = false;
            int i = curX0;
            while (i < curX1) {
                if (this.containerMap[j][i] == _id) {
                    if (!mostLeftFound) {
                        workMap[j][i] = 1;
                        mostLeftFound = true;
                        otherContainerLeft = false;
                    } else if (otherContainerLeft) {
                        workMap[j][i] = 1;
                        otherContainerLeft = false;
                    }
                } else if (this.containerMap[j][i] > 0) {
                    otherContainerLeft = true;
                }
                ++i;
            }
            boolean mostRightFound = false;
            boolean otherContainerRight = false;
            int i2 = curX1 - 1;
            while (i2 >= curX0) {
                if (this.containerMap[j][i2] == _id) {
                    if (!mostRightFound) {
                        workMap[j][i2] = workMap[j][i2] != 1 ? 2 : 3;
                        mostRightFound = true;
                        otherContainerRight = false;
                    } else if (otherContainerRight) {
                        workMap[j][i2] = workMap[j][i2] != 1 ? 2 : 3;
                        otherContainerRight = false;
                    }
                } else if (this.containerMap[j][i2] > 0) {
                    otherContainerRight = true;
                }
                --i2;
            }
            boolean inTheContainer = false;
            int i3 = curX0;
            while (i3 < curX1) {
                if (workMap[j][i3] == 0 && inTheContainer) {
                    if (this.containerMap[j][i3] != 0 && this.containerMap[j][i3] != _id) {
                        DebugUtil.outMsg(this, "i = " + i3 + ", j = " + j);
                        DebugUtil.outMsg(this, "Dumping containerMap");
                        int k = 0;
                        while (k < this.pixel.getWidth()) {
                            System.err.print(NULL_STRING + this.containerMap[j][k]);
                            ++k;
                        }
                        System.err.println(NULL_STRING);
                        DebugUtil.outMsg(this, "Dumping workMap");
                        k = 0;
                        while (k < this.pixel.getWidth()) {
                            System.err.print(NULL_STRING + workMap[j][k]);
                            ++k;
                        }
                        System.err.println(NULL_STRING);
                        throw new ImageException("filling error 0: id = " + _id);
                    }
                    this.containerMap[j][i3] = _id;
                } else if (workMap[j][i3] == 1) {
                    if (inTheContainer) {
                        throw new ImageException("filling error 1: id = " + _id);
                    }
                    inTheContainer = true;
                } else if (workMap[j][i3] == 2) {
                    inTheContainer = false;
                }
                ++i3;
            }
            ++j;
        }
    }

    private boolean collateCandidates(Container _cont, ConnectedComponent _cc) throws ImageException {
        int numCand = _cont.candidateCharacterVector.size();
        int k = numCand - 1;
        while (k >= 0) {
            CandidateCharacter cChar = _cont.candidateCharacterVector.elementAt(k);
            if (_cc.equals(cChar.cc)) {
                CharacterSS ssc = new CharacterSS(cChar);
                _cont.ssCharacterVector.addElement(ssc);
                _cont.candidateCharacterVector.removeElementAt(k);
                return true;
            }
            --k;
        }
        int numUCand = _cont.candidateUnderlinedCharacterVector.size();
        int k2 = numUCand - 1;
        while (k2 >= 0) {
            CandidateUnderlinedCharacter cuChar = _cont.candidateUnderlinedCharacterVector.elementAt(k2);
            if (_cc.equals(cuChar.cc)) {
                _cont.ssCharacterVector.addAll(this.removeUnderlineAndGenerateSS(cuChar));
                _cont.candidateUnderlinedCharacterVector.removeElementAt(k2);
                return true;
            }
            --k2;
        }
        return false;
    }

    private int getForegroundColor(ConnectedComponent _cc) {
        int fg = -1;
        int j = 0;
        while (j < _cc.shape.height) {
            int i = 0;
            while (i < _cc.shape.width) {
                if (_cc.shape.data[j][i] != 0) {
                    if (fg == -1) {
                        fg = this.pixel.getData()[j + _cc.top][i + _cc.left];
                    } else if (fg != this.pixel.getData()[j + _cc.top][i + _cc.left]) {
                        return -1;
                    }
                }
                ++i;
            }
            ++j;
        }
        return fg;
    }

    private int getBackgroundColor(ConnectedComponent _cc) {
        int bg = -1;
        int j = 0;
        while (j < _cc.shape.height) {
            int i = 0;
            while (i < _cc.shape.width) {
                if (_cc.shape.data[j][i] == 0) {
                    if (bg == -1) {
                        bg = this.pixel.getData()[j + _cc.top][i + _cc.left];
                    } else if (bg != this.pixel.getData()[j + _cc.top][i + _cc.left]) {
                        return -1;
                    }
                }
                ++i;
            }
            ++j;
        }
        return bg;
    }

    private Vector<CharacterSM> makeSMCharacterVector(Vector<CandidateCharacter> _cVec, Vector<CandidateUnderlinedCharacter> _uVec) throws ImageException {
        Vector<CharacterSM> tmpVec = new Vector<CharacterSM>();
        int numRemainingChar = _cVec.size();
        int k = 0;
        while (k < numRemainingChar) {
            CandidateCharacter cChar = _cVec.elementAt(k);
            CharacterSM smc = new CharacterSM(cChar, this.pixel);
            tmpVec.addElement(smc);
            ++k;
        }
        int numRemainingUnderlinedChar = _uVec.size();
        int k2 = 0;
        while (k2 < numRemainingUnderlinedChar) {
            CandidateUnderlinedCharacter cuChar = _uVec.elementAt(k2);
            tmpVec.addAll(this.removeUnderlineAndGenerateSM(cuChar));
            ++k2;
        }
        return tmpVec;
    }

    private CharacterMS includingMSCharacter(CharacterSM _smc, Container _cont) {
        int k = 0;
        while (k < _cont.msCharacterVector.size()) {
            CharacterMS curMS = _cont.msCharacterVector.elementAt(k);
            if (_smc.cc.isIncludedBy(curMS.cc)) {
                return curMS;
            }
            ++k;
        }
        return null;
    }

    @Override
    public List<IProblemItem> checkCharacters(LowVisionType _lvType, String urlS, int frameId) throws ImageException, LowVisionProblemException {
        Object charProblemGroupArray = null;
        LowVisionProblemGroup[] imgProblemGroupArray = null;
        LowVisionProblemGroup[] answerArray = null;
        if (this.useImagePositions) {
            this.extractInteriorImages();
            imgProblemGroupArray = this.checkInteriorImages(_lvType);
            this.interiorImageArray = null;
        }
        if (charProblemGroupArray == null) {
            answerArray = imgProblemGroupArray == null ? new LowVisionProblemGroup[]{} : imgProblemGroupArray;
        } else if (imgProblemGroupArray == null) {
            answerArray = charProblemGroupArray;
        } else {
            int charLen = (charProblemGroupArray).length;
            int imgLen = imgProblemGroupArray.length;
            int allLen = charLen + imgLen;
            LowVisionProblemGroup[] allProblemGroupArray = new LowVisionProblemGroup[allLen];
            int i = 0;
            while (i < charLen) {
                allProblemGroupArray[i] = charProblemGroupArray[i];
                ++i;
            }
            i = 0;
            while (i < imgLen) {
                allProblemGroupArray[charLen + i] = imgProblemGroupArray[i];
                ++i;
            }
            answerArray = allProblemGroupArray;
        }
        return LowVisionProblemConverter.convert(answerArray, urlS, frameId);
    }

    private LowVisionProblemGroup[] checkInteriorImages(LowVisionType _lvType) throws ImageException {
        if (!this.useImagePositions) {
            return new LowVisionProblemGroup[0];
        }
        Vector<LowVisionProblemGroup> problemVector = new Vector<LowVisionProblemGroup>();
        int numInteriorImages = 0;
        if (this.interiorImageArray != null && this.interiorImageArray.length > 0) {
            numInteriorImages = this.interiorImageArray.length;
        }
        int k = 0;
        while (k < numInteriorImages) {
            InteriorImage curIm = this.interiorImageArray[k];
            LowVisionProblemGroup[] probArray = curIm.checkColors(_lvType);
            if (probArray != null) {
                int numProb = probArray.length;
                int l = 0;
                while (l < numProb) {
                    problemVector.addElement(probArray[l]);
                    ++l;
                }
            }
            ++k;
        }
        int size = problemVector.size();
        if (size > 0) {
            LowVisionProblemGroup[] allProbArray = new LowVisionProblemGroup[size];
            int k2 = 0;
            while (k2 < size) {
                allProbArray[k2] = (LowVisionProblemGroup)problemVector.elementAt(k2);
                ++k2;
            }
            problemVector = null;
            return allProbArray;
        }
        problemVector = null;
        return new LowVisionProblemGroup[0];
    }

    private LabeledImage removeUnderlineAndCCL(CandidateUnderlinedCharacter _cuChar) throws ImageException {
        BinaryImage origImage = _cuChar.cc.shape;
        BinaryImage lineImage = origImage.drawUnderline();
        BinaryImage removedImage = origImage.subtract(lineImage);
        LabeledImage li = new LabeledImage(removedImage, 0);
        return li;
    }

    private Vector<CharacterSS> removeUnderlineAndGenerateSS(CandidateUnderlinedCharacter _cuChar) throws ImageException {
        Vector<CharacterSS> ssVec = new Vector<CharacterSS>();
        int offsetX = _cuChar.cc.left;
        int offsetY = _cuChar.cc.top;
        short conn = _cuChar.cc.connectivity;
        LabeledImage li = this.removeUnderlineAndCCL(_cuChar);
        int numCC = li.numComponents;
        int k = 0;
        while (k < numCC) {
            ConnectedComponent cc = li.components[k];
            cc.left += offsetX;
            cc.top += offsetY;
            cc.connectivity = conn;
            if (DecisionMaker.judgeComponentType(cc, this) == 2) {
                CharacterSS ssc = new CharacterSS(this, cc, _cuChar.container, _cuChar.getForegroundColor());
                ssVec.addElement(ssc);
            }
            ++k;
        }
        return ssVec;
    }

    private Vector<CharacterSM> removeUnderlineAndGenerateSM(CandidateUnderlinedCharacter _cuChar) throws ImageException {
        Vector<CharacterSM> smVec = new Vector<CharacterSM>();
        int offsetX = _cuChar.cc.left;
        int offsetY = _cuChar.cc.top;
        short conn = _cuChar.cc.connectivity;
        LabeledImage li = this.removeUnderlineAndCCL(_cuChar);
        int numCC = li.numComponents;
        int k = 0;
        while (k < numCC) {
            ConnectedComponent cc = li.components[k];
            cc.left += offsetX;
            cc.top += offsetY;
            cc.connectivity = conn;
            if (DecisionMaker.judgeComponentType(cc, this) == 2) {
                CharacterSM smc = new CharacterSM((IPageImage)this, cc, _cuChar.container, _cuChar.getForegroundColor(), this.pixel);
                smVec.addElement(smc);
            }
            ++k;
        }
        return smVec;
    }

    @Override
    public void writeToBMPFile(String name) throws LowVisionIOException {
        this.pixel.writeToBMPFile(name);
    }

    @Override
    public void writeToBMPFile(String name, int count) throws LowVisionIOException {
        this.pixel.writeToBMPFile(name, count);
    }
}

