/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;

public class ImageUtil {
    public static Int2D bufferedImageToInt2D(BufferedImage _bi) throws ImageException {
        if (_bi == null) {
            throw new ImageException("Input BufferedImage is null.");
        }
        int width = _bi.getWidth();
        int height = _bi.getHeight();
        Int2D i2d = new Int2D(width, height);
        WritableRaster srcRaster = _bi.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                i2d.getData()[j][i] = srcArray[k];
                ++k;
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public static BufferedImage int2DToBufferedImage(IInt2D _i2d) {
        return ImageUtil.int2DArrayToBufferedImage(_i2d.getData(), _i2d.getWidth(), _i2d.getHeight());
    }

    public static int[][] bufferedImageToInt2DArray(BufferedImage _bi, int _width, int _height) {
        int[][] pixel = new int[_height][_width];
        WritableRaster srcRaster = _bi.copyData(null);
        DataBufferInt srcBufInt = (DataBufferInt)srcRaster.getDataBuffer();
        int[] srcArray = srcBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                pixel[j][i] = srcArray[k];
                ++k;
                ++i;
            }
            ++j;
        }
        return pixel;
    }

    public static BufferedImage int2DArrayToBufferedImage(int[][] _pixel, int _width, int _height) {
        BufferedImage destBufferedImage = new BufferedImage(_width, _height, 1);
        WritableRaster destRaster = destBufferedImage.copyData(null);
        DataBufferInt destBufInt = (DataBufferInt)destRaster.getDataBuffer();
        int[] destArray = destBufInt.getData();
        int k = 0;
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                destArray[k] = _pixel[j][i];
                ++k;
                ++i;
            }
            ++j;
        }
        destBufferedImage.setData(destRaster);
        return destBufferedImage;
    }

    public static int[][] copyInt2DArray(int[][] _src, int _width, int _height) {
        int[][] destArray2D = new int[_height][_width];
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                destArray2D[j][i] = _src[j][i];
                ++i;
            }
            ++j;
        }
        return destArray2D;
    }

    public static void dumpInt2DArray(PrintStream _ps, int[][] _data, int _width, int _height) {
        PrintWriter pw = new PrintWriter(_ps, false);
        ImageUtil.dumpInt2DArray(pw, _data, _width, _height);
    }

    public static void dumpInt2DArray(PrintWriter _pw, int[][] _data, int _width, int _height) {
        _pw.println("-------");
        _pw.println("dumping int[][]");
        _pw.println("width = " + _width + ", height = " + _height);
        _pw.println("data:");
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                _pw.print("" + _data[j][i]);
                ++i;
            }
            _pw.println("");
            ++j;
        }
        _pw.println("-------");
        _pw.flush();
    }
}

