/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorXYZ {
    ICC_ColorSpace cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
    private float[] xyz = new float[3];

    public ColorXYZ() {
    }

    public ColorXYZ(float[] _xyz) throws ColorException {
        this(_xyz, false);
    }

    public ColorXYZ(float[] _xyz, boolean _check) throws ColorException {
        this(_xyz[0], _xyz[1], _xyz[2], _check);
    }

    public ColorXYZ(float _x, float _y, float _z) throws ColorException {
        this(_x, _y, _z, false);
    }

    public ColorXYZ(float _x, float _y, float _z, boolean _check) throws ColorException {
        this.setX(_x, _check);
        this.setY(_y, _check);
        this.setZ(_z, _check);
    }

    public float getX() {
        return this.xyz[0];
    }

    public float getY() {
        return this.xyz[1];
    }

    public float getZ() {
        return this.xyz[2];
    }

    public void setX(float _x) throws ColorException {
        this.setX(_x, false);
    }

    public void setX(float _x, boolean _check) throws ColorException {
        if (_x < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[0] = 0.0f;
        } else if (1.0f < _x) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[0] = 1.0f;
        } else {
            this.xyz[0] = _x;
        }
    }

    public void setY(float _y) throws ColorException {
        this.setY(_y, false);
    }

    public void setY(float _y, boolean _check) throws ColorException {
        if (_y < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[1] = 0.0f;
        } else if (1.0f < _y) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[1] = 1.0f;
        } else {
            this.xyz[1] = _y;
        }
    }

    public void setZ(float _z) throws ColorException {
        this.setZ(_z, false);
    }

    public void setZ(float _z, boolean _check) throws ColorException {
        if (_z < 0.0f) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[2] = 0.0f;
        } else if (1.0f < _z) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[2] = 1.0f;
        } else {
            this.xyz[2] = _z;
        }
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean _check) throws ColorException {
        float[] frgb = this.cs.fromCIEXYZ(this.xyz);
        ColorSRGB s = new ColorSRGB(frgb[0], frgb[1], frgb[2], _check);
        return s;
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean _check) throws ColorException {
        float sum = this.xyz[0] + this.xyz[1] + this.xyz[2];
        ColorYXY yxy = new ColorYXY();
        if (sum == 0.0f) {
            yxy.setYY(0.0f);
            yxy.setX(0.0f);
            yxy.setY(0.0f);
        } else {
            yxy.setYY(this.xyz[1], _check);
            yxy.setX(this.xyz[0] / sum, _check);
            yxy.setY(this.xyz[1] / sum, _check);
        }
        return yxy;
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean _check) throws ColorException {
        return this.toSRGB(_check).toIRGB(_check);
    }

    public ColorLAB toLAB() {
        return new ColorLAB(this);
    }
}

