/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorIRGB {
    int R;
    int G;
    int B;

    public ColorIRGB() {
    }

    public ColorIRGB(int _i) {
        this.R = _i >> 16 & 0xFF;
        this.G = _i >> 8 & 0xFF;
        this.B = _i & 0xFF;
    }

    public ColorIRGB(int _r, int _g, int _b) throws ColorException {
        this.setR(_r);
        this.setG(_g);
        this.setB(_b);
    }

    public ColorIRGB(int _r, int _g, int _b, boolean _check) throws ColorException {
        this.setR(_r, _check);
        this.setG(_g, _check);
        this.setB(_b, _check);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorIRGB(String _str) throws ColorException {
        Pattern patRemoveSpace = Pattern.compile("^\\s*(\\S.+\\S)\\s*$");
        Matcher matRemoveSpace = patRemoveSpace.matcher(_str.toLowerCase());
        if (!matRemoveSpace.find()) {
            throw new ColorException("There no color spacifications. Input string is \"" + _str + "\"");
        }
        String spec = matRemoveSpace.group(1);
        String tmpS = ColorUtil.predefinedColor2Pound(spec);
        if (tmpS != null) {
            spec = tmpS;
        }
        if (spec.startsWith("#")) {
            if ((spec = spec.substring(1)).length() == 6) {
                String rStr = spec.substring(0, 2);
                String gStr = spec.substring(2, 4);
                String bStr = spec.substring(4);
                try {
                    this.R = Integer.parseInt(rStr, 16);
                    this.G = Integer.parseInt(gStr, 16);
                    this.B = Integer.parseInt(bStr, 16);
                    return;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ColorException("Bad color specification(1): #" + spec);
                }
            } else {
                if (spec.length() != 3) throw new ColorException("Bad color specification(3): #" + spec);
                String rStr = spec.substring(0, 1);
                String gStr = spec.substring(1, 2);
                String bStr = spec.substring(2);
                try {
                    this.R = Integer.parseInt(String.valueOf(rStr) + rStr, 16);
                    this.G = Integer.parseInt(String.valueOf(gStr) + gStr, 16);
                    this.B = Integer.parseInt(String.valueOf(bStr) + bStr, 16);
                    return;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ColorException("Bad color specification(2): #" + spec);
                }
            }
        } else if (spec.startsWith("rgb(") && spec.endsWith(")")) {
            spec = spec.substring(4);
            if ((spec = spec.substring(0, spec.length() - 1)).indexOf("%") == -1) {
                Pattern patRGB = Pattern.compile("^\\s*([\\+\\-]?\\d+)\\s*\\,\\s*([\\+\\-]?\\d+)\\s*\\,\\s*([\\+\\-]?\\d+)\\s*$");
                Matcher matRGB = patRGB.matcher(spec);
                if (!matRGB.find()) {
                    throw new ColorException("Bad color specification(4): rgb(" + spec + ")");
                }
                try {
                    this.setR(Integer.parseInt(matRGB.group(1)), false);
                    this.setG(Integer.parseInt(matRGB.group(2)), false);
                    this.setB(Integer.parseInt(matRGB.group(3)), false);
                    return;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new ColorException("Bad color specification(5): rgb(" + spec + ")");
                }
            } else {
                Pattern patRGB = Pattern.compile("^\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*\\,\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*\\,\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*$");
                Matcher matRGB = patRGB.matcher(spec);
                if (!matRGB.find()) {
                    throw new ColorException("Bad color specification(6): rgb(" + spec + ")");
                }
                try {
                    this.setR((int)(Float.parseFloat(matRGB.group(1)) / 100.0f * 255.0f), false);
                    this.setG((int)(Float.parseFloat(matRGB.group(3)) / 100.0f * 255.0f), false);
                    this.setB((int)(Float.parseFloat(matRGB.group(5)) / 100.0f * 255.0f), false);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ColorException("Bad color specification(7): rgb(" + spec + ")");
                }
            }
        } else {
            if (!spec.equals("transparent")) throw new ColorException("Unknown color specification: " + spec);
            this.R = 255;
            this.G = 255;
            this.B = 255;
        }
    }

    public int getR() {
        return this.R;
    }

    public int getG() {
        return this.G;
    }

    public int getB() {
        return this.B;
    }

    public void setR(int _r) throws ColorException {
        this.setR(_r, false);
    }

    public void setR(int _r, boolean _check) throws ColorException {
        if (_r < 0) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.R = 0;
        } else if (255 < _r) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.R = 255;
        } else {
            this.R = _r;
        }
    }

    public void setG(int _g) throws ColorException {
        this.setG(_g, false);
    }

    public void setG(int _g, boolean _check) throws ColorException {
        if (_g < 0) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.G = 0;
        } else if (255 < _g) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.G = 255;
        } else {
            this.G = _g;
        }
    }

    public void setB(int _b) throws ColorException {
        this.setB(_b, false);
    }

    public void setB(int _b, boolean _check) throws ColorException {
        if (_b < 0) {
            if (_check) {
                throw new ColorException("Smaller than minimum.");
            }
            this.B = 0;
        } else if (255 < _b) {
            if (_check) {
                throw new ColorException("Larger than maximum.");
            }
            this.B = 255;
        } else {
            this.B = _b;
        }
    }

    public boolean equals(ColorIRGB _c) throws ColorException {
        if (_c == null) {
            throw new ColorException("The parameter is null.");
        }
        return _c.getR() == this.R && _c.getG() == this.G && _c.getB() == this.B;
    }

    public boolean equals(int _i) {
        return this.toInt() == _i;
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean _check) throws ColorException {
        ColorSRGB s = new ColorSRGB((float)this.R / 255.0f, (float)this.G / 255.0f, (float)this.B / 255.0f, _check);
        return s;
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean _check) throws ColorException {
        return this.toSRGB(_check).toXYZ(_check);
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean _check) throws ColorException {
        return this.toSRGB(_check).toXYZ(_check).toYXY(_check);
    }

    public int toInt() {
        return (this.R & 0xFF) << 16 | (this.G & 0xFF) << 8 | this.B & 0xFF;
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        _pw.println("-------");
        _pw.println("dumping color values");
        _pw.println("R= " + this.R + ", G= " + this.G + ", B= " + this.B);
        _pw.println("-------");
    }
}

