/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.LengthUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.checker.W3CColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorCSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.FixedSizeFontProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.FixedSmallFontProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedBackgroundColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedBothColorsProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProhibitedForegroundColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.SmallFontProblem;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageElement {
    static final String IE_LARGEST_FONT = "16pt";
    static final double IE_EM_SCALING = 1.33;
    static final double IE_LARGER_SCALING = 1.67;
    static final double IE_SMALLER_SCALING = 1.0;
    public static final double SEVERITY_FIXED_SIZE_FONT = 0.25;
    public static final double SEVERITY_SMALL_FONT = 0.25;
    public static final double SEVERITY_FIXED_SMALL_FONT = 0.5;
    public static final double SEVERITY_PROHIBITED_FOREGROUND_COLOR = 0.5;
    public static final double SEVERITY_PROHIBITED_BACKGROUND_COLOR = 0.5;
    public static final double SEVERITY_PROHIBITED_BOTH_COLORS = 1.0;
    private static final String DELIM = "/";
    private static final String[] nonTextTagNames = new String[]{"area", "base", "basefont", "br", "col", "colgroup", "frame", "frameset", "head", "html", "hr", "img", "isindex", "link", "meta", "optgroup", "param", "script", "select", "style", "title"};
    private static final String[] fontSizeChangeTags = new String[]{"big", "code", "h1", "h2", "h3", "h5", "h6", "kbd", "pre", "samp", "small", "sub", "sup", "tt"};
    public static final int UNSET_POSITION = -1;
    public static final int UNSET_COLOR = -1;
    private String id = null;
    private ICurrentStyles style = null;
    private String tagName = null;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private int foregroundColor = -1;
    private int backgroundColor = -1;
    private static final short FONT_SIZE_UNKNOWN = 0;
    private static final short FONT_SIZE_FIXED = 1;
    private static final short FONT_SIZE_PT = 2;
    private static final short FONT_SIZE_RELATIVE = 3;
    private static final short FONT_SIZE_ABSOLUTE = 4;
    private static final short FONT_SIZE_PERCENT = 5;
    private static final short FONT_SIZE_EM = 6;

    public PageElement(String _key, ICurrentStyles _cs) throws ImageException {
        this.id = _key;
        this.style = _cs;
        this.tagName = this.style.getTagName().toLowerCase();
        this.setDimension();
        this.setColors();
    }

    private void setDimension() {
        Rectangle rect = this.style.getRectangle();
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    private void setColors() throws ImageException {
        if (!this.isTextTag()) {
            return;
        }
        String fgStr = this.style.getComputedColor();
        String bgStr = this.style.getComputedBackgroundColor();
        try {
            this.foregroundColor = new ColorCSS(fgStr).toInt();
            this.backgroundColor = new ColorCSS(bgStr).toInt();
        }
        catch (ColorException e) {
            e.printStackTrace();
            throw new ImageException("Could not interpret colors.");
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public LowVisionProblem[] check(LowVisionType _lvType, String[] allowedFgColors, String[] allowedBgColors) {
        Vector problemVec = new Vector();
        if (this.x < 0 || this.y < 0) {
            return new LowVisionProblem[0];
        }
        List<Object> cp = new ArrayList();
        try {
            cp = this.checkColors(_lvType);
        }
        catch (LowVisionException e) {
            DebugUtil.errMsg(this, "Error occurred in checking colors: id = " + this.id);
            e.printStackTrace();
        }
        problemVec.addAll(cp);
        FixedSizeFontProblem fsfp = null;
        try {
            fsfp = this.checkFixedSizeFont(_lvType);
        }
        catch (LowVisionException e) {
            DebugUtil.errMsg(this, "Error occurred in checking fixed-size font: id = " + this.id);
            e.printStackTrace();
        }
        SmallFontProblem sfp = null;
        try {
            sfp = this.checkSmallFont(_lvType);
        }
        catch (LowVisionException e) {
            DebugUtil.errMsg(this, "Error occurred in checking small font: id = " + this.id);
            e.printStackTrace();
        }
        if (fsfp != null && sfp != null) {
            double proba = 0.5;
            FixedSmallFontProblem newProblem = null;
            try {
                newProblem = new FixedSmallFontProblem(this, _lvType, proba);
                newProblem.setElement(fsfp.getElement());
                problemVec.addElement(newProblem);
            }
            catch (LowVisionProblemException e) {
                e.printStackTrace();
            }
        } else if (fsfp != null) {
            problemVec.addElement(fsfp);
        } else if (sfp != null) {
            problemVec.addElement(sfp);
        }
        ProhibitedForegroundColorProblem pfcp = null;
        ProhibitedBackgroundColorProblem pbcp = null;
        if (allowedFgColors != null && allowedFgColors.length > 0) {
            try {
                pfcp = this.checkAllowedForegroundColors(_lvType, allowedFgColors);
            }
            catch (LowVisionException lve) {
                lve.printStackTrace();
            }
        }
        if (allowedBgColors != null && allowedBgColors.length > 0) {
            try {
                pbcp = this.checkAllowedBackgroundColors(_lvType, allowedBgColors);
            }
            catch (LowVisionException lve) {
                lve.printStackTrace();
            }
        }
        if (pfcp != null && pbcp != null) {
            try {
                problemVec.addElement(new ProhibitedBothColorsProblem(this, _lvType, 1.0));
            }
            catch (LowVisionProblemException lvpe) {
                lvpe.printStackTrace();
            }
            pfcp = null;
            pbcp = null;
        } else if (pfcp != null) {
            problemVec.addElement(pfcp);
        } else if (pbcp != null) {
            problemVec.addElement(pbcp);
        }
        int size = problemVec.size();
        LowVisionProblem[] problemArray = new LowVisionProblem[size];
        int i = 0;
        while (i < size) {
            problemArray[i] = (LowVisionProblem)problemVec.elementAt(i);
            ++i;
        }
        return problemArray;
    }

    private List<ColorProblem> checkColors(LowVisionType _lvType) throws LowVisionException {
        ArrayList<ColorProblem> result = new ArrayList<ColorProblem>();
        if (!this.isTextTag()) {
            return result;
        }
        try {
            if (this.style.hasDescendantTextWithBGImage()) {
                ColorProblem cp = new ColorProblem(this, _lvType, 0.0);
                cp.setElement(this.style.getElement());
                cp.setHasBackgroundImage(true);
                cp.setTargetStrings(this.style.getDescendantTextsWithBGImage());
                cp.setIsWarning(true);
                result.add(cp);
            }
            if (!this.style.hasChildText()) {
                return result;
            }
            boolean hasBgImage = this.style.getComputedBackgroundImage() != null && !this.style.getComputedBackgroundImage().equalsIgnoreCase("none");
            ColorIRGB fgOrg = new ColorIRGB(this.foregroundColor);
            ColorIRGB bgOrg = new ColorIRGB(this.backgroundColor);
            W3CColorChecker w3c = new W3CColorChecker(fgOrg, bgOrg);
            double contrast = w3c.calcContrast();
            if (contrast < 7.0) {
                ColorProblem cp = new ColorProblem(this, _lvType, w3c.calcSeverity());
                cp.setElement(this.style.getElement());
                cp.setContrast(contrast);
                cp.setTargetStrings(this.style.getChildTexts());
                cp.setHasBackgroundImage(hasBgImage);
                result.add(cp);
            }
        }
        catch (LowVisionProblemException lowVisionProblemException) {}
        return result;
    }

    private FixedSizeFontProblem checkFixedSizeFont(LowVisionType _lvType) throws LowVisionException {
        if (!this.isTextTag()) {
            return null;
        }
        if (!this.style.hasChildText()) {
            return null;
        }
        String fontStr = this.style.getFontSize().toLowerCase();
        if (fontStr.indexOf(DELIM) == -1) {
            short type = this.fontSizeType(fontStr = this.digitToFontSetting(fontStr));
            if (type == 1) {
                try {
                    FixedSizeFontProblem problem = new FixedSizeFontProblem(this, _lvType, 0.25);
                    problem.setElement(this.style.getElement());
                    return problem;
                }
                catch (LowVisionProblemException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        boolean fixedFlag = false;
        StringTokenizer st = new StringTokenizer(fontStr, DELIM);
        int tokenCount = st.countTokens();
        String myFont = this.digitToFontSetting(st.nextToken());
        short myType = this.fontSizeType(myFont);
        if (myType == 1) {
            fixedFlag = true;
        } else if (myType != 3 && myType != 4) {
            String[] fontSequence = new String[tokenCount];
            fontSequence[tokenCount - 1] = myFont;
            int i = tokenCount - 2;
            while (i >= 0) {
                fontSequence[i] = this.digitToFontSetting(st.nextToken());
                --i;
            }
            StringTokenizer stTag = new StringTokenizer(this.tagName, DELIM);
            if (stTag.countTokens() != tokenCount) {
                throw new LowVisionException("# of tagNames and fontSizes did not match.");
            }
            String[] tagNameSequence = new String[tokenCount];
            int i2 = tokenCount - 1;
            while (i2 >= 0) {
                tagNameSequence[i2] = stTag.nextToken();
                --i2;
            }
            String curFont = fontSequence[0];
            short curType = this.fontSizeType(curFont);
            boolean firstPtFlag = true;
            if (curType != 2) {
                firstPtFlag = false;
            }
            if (curType == 1) {
                fixedFlag = true;
            }
            int i3 = 1;
            while (i3 < tokenCount) {
                String tmpFont = fontSequence[i3];
                String tmpTag = tagNameSequence[i3];
                if (tmpTag.equals("td") || tmpTag.equals("th")) {
                    firstPtFlag = true;
                    if (curType != 2) {
                        firstPtFlag = false;
                    }
                    if (curType == 1) {
                        fixedFlag = true;
                    }
                } else if (!curFont.equals(tmpFont)) {
                    short tmpType = this.fontSizeType(tmpFont);
                    if (tmpType == 1) {
                        fixedFlag = true;
                        firstPtFlag = true;
                    } else if (tmpType == 3 || tmpType == 4) {
                        fixedFlag = false;
                        firstPtFlag = true;
                    } else if (tmpType == 2) {
                        if (!firstPtFlag) {
                            firstPtFlag = true;
                            fixedFlag = false;
                        } else if (curType != 2 || fixedFlag || !this.isFontSizeChangeTag(tmpTag)) {
                            fixedFlag = true;
                        }
                    }
                    curFont = tmpFont;
                    curType = tmpType;
                }
                ++i3;
            }
        }
        if (fixedFlag) {
            try {
                FixedSizeFontProblem problem = new FixedSizeFontProblem(this, _lvType, 0.25);
                problem.setElement(this.style.getElement());
                return problem;
            }
            catch (LowVisionProblemException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private short fontSizeType(String _fontSize) {
        String s = _fontSize.toLowerCase();
        if (s.endsWith("mm") || s.endsWith("cm") || s.endsWith("in") || s.endsWith("pc") || s.endsWith("px")) {
            return 1;
        }
        if (s.endsWith("pt")) {
            return 2;
        }
        if (s.endsWith("%")) {
            return 5;
        }
        if (s.endsWith("em") || s.endsWith("ex")) {
            return 6;
        }
        if (s.equals("smaller") || s.equals("larger")) {
            return 3;
        }
        return 4;
    }

    private String digitToFontSetting(String _fontStr) throws LowVisionException {
        if (_fontStr.length() == 1) {
            if (_fontStr.equals("1")) {
                return "xx-small";
            }
            if (_fontStr.equals("2")) {
                return "x-small";
            }
            if (_fontStr.equals("3")) {
                return "small";
            }
            if (_fontStr.equals("4")) {
                return "medium";
            }
            if (_fontStr.equals("5")) {
                return "large";
            }
            if (_fontStr.equals("6")) {
                return "x-large";
            }
            if (_fontStr.equals("7")) {
                return "xx-large";
            }
            throw new LowVisionException("Invalid font size setting: " + _fontStr);
        }
        if (_fontStr.startsWith("+")) {
            if (_fontStr.equals("+1")) {
                return "120%";
            }
            if (_fontStr.equals("+2")) {
                return "144%";
            }
            if (_fontStr.equals("+3")) {
                return "173%";
            }
            if (_fontStr.equals("+4")) {
                return "207%";
            }
            if (_fontStr.equals("+5")) {
                return "249%";
            }
            if (_fontStr.equals("+6")) {
                return "299%";
            }
            if (_fontStr.equals("+0")) {
                return "100%";
            }
            throw new LowVisionException("Invalid font size setting: " + _fontStr);
        }
        if (_fontStr.startsWith("-")) {
            if (_fontStr.equals("-1")) {
                return "83%";
            }
            if (_fontStr.equals("-2")) {
                return "69%";
            }
            if (_fontStr.equals("-3")) {
                return "58%";
            }
            if (_fontStr.equals("-4")) {
                return "48%";
            }
            if (_fontStr.equals("-5")) {
                return "40%";
            }
            if (_fontStr.equals("-6")) {
                return "33%";
            }
            if (_fontStr.equals("-0")) {
                return "100%";
            }
            throw new LowVisionException("Invalid font size setting: " + _fontStr);
        }
        return _fontStr;
    }

    private boolean isFontSizeChangeTag(String _st) {
        int len = fontSizeChangeTags.length;
        String s = _st.toLowerCase();
        int i = 0;
        while (i < len) {
            if (s.equals(fontSizeChangeTags[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SmallFontProblem checkSmallFont(LowVisionType _lvType) throws LowVisionException {
        if (!_lvType.doBlur()) {
            return null;
        }
        double eyesightLength = _lvType.getEyesightLength();
        if (!this.isTextTag()) {
            return null;
        }
        if (!this.style.hasChildText()) {
            return null;
        }
        if (this.tagName.startsWith("option")) {
            return null;
        }
        String fontStr = this.style.getFontSize().toLowerCase();
        StringTokenizer fontSt = new StringTokenizer(fontStr, DELIM);
        Vector<String> fontSequence = new Vector<String>();
        StringTokenizer tagSt = new StringTokenizer(this.tagName, DELIM);
        String curFont = fontSt.nextToken();
        String curTag = tagSt.nextToken();
        fontSequence.addElement(curFont);
        while (fontSt.hasMoreTokens()) {
            String tmpFont = fontSt.nextToken();
            curTag = tagSt.nextToken();
            if (curTag.equals("td") || curTag.equals("th")) {
                if (tmpFont.equals(curFont)) break;
                fontSequence.addElement(tmpFont);
                break;
            }
            if (!tmpFont.equals(curFont)) {
                fontSequence.addElement(tmpFont);
            }
            curFont = tmpFont;
        }
        int numFontSizeSettings = fontSequence.size();
        String[] fontSizeSettings = new String[numFontSizeSettings];
        int i = 0;
        while (i < numFontSizeSettings) {
            String tmpSetting = (String)fontSequence.elementAt(i);
            fontSizeSettings[i] = this.digitToFontSetting(tmpSetting);
            ++i;
        }
        fontSequence = null;
        String curFontSize = fontSizeSettings[numFontSizeSettings - 1];
        if (this.fontSizeType(curFontSize) == 2) {
            fontSizeSettings[numFontSizeSettings - 1] = IE_LARGEST_FONT;
            int i2 = numFontSizeSettings - 2;
            while (i2 >= 0) {
                if (!fontSizeSettings[i2].equals(curFontSize)) break;
                fontSizeSettings[i2] = IE_LARGEST_FONT;
                --i2;
            }
        }
        float scaling = 1.0f;
        int curType = 0;
        int i3 = 0;
        while (i3 < numFontSizeSettings) {
            double value;
            curFontSize = fontSizeSettings[i3];
            curType = this.fontSizeType(curFontSize);
            if (curType == 1 || curType == 2) break;
            if (curType == 4) {
                if (curFontSize.equals("xx-large")) {
                    curFontSize = "48pt";
                    break;
                }
                if (curFontSize.equals("x-large")) {
                    curFontSize = "32pt";
                    break;
                }
                if (curFontSize.equals("large")) {
                    curFontSize = "24pt";
                    break;
                }
                if (curFontSize.equals("medium")) {
                    curFontSize = "18pt";
                    break;
                }
                if (curFontSize.equals("small")) {
                    curFontSize = IE_LARGEST_FONT;
                    break;
                }
                if (curFontSize.equals("x-small")) {
                    curFontSize = "14pt";
                    break;
                }
                if (!curFontSize.equals("xx-small")) break;
                curFontSize = "12pt";
                break;
            }
            if (curType == 5) {
                value = Double.parseDouble(curFontSize.substring(0, curFontSize.length() - 1));
                scaling = (float)((double)scaling * (value / 100.0));
            } else if (curType == 6) {
                value = 0.0;
                value = Double.parseDouble(curFontSize.substring(0, curFontSize.length() - 2));
                if (curFontSize.endsWith("ex")) {
                    value /= 2.0;
                }
                scaling = (float)((double)scaling * (value * 1.33));
            } else if (curFontSize.equals("larger")) {
                scaling = (float)((double)scaling * 1.67);
            } else if (curFontSize.equals("smaller")) {
                scaling = (float)((double)scaling * 1.0);
            } else {
                throw new LowVisionException("unknown font size setting: " + curFontSize);
            }
            ++i3;
        }
        if (curType != 1 && curType != 2 && curType != 4) {
            curFontSize = IE_LARGEST_FONT;
        }
        float value = Float.parseFloat(curFontSize.substring(0, curFontSize.length() - 2));
        float sizeInMm = 0.0f;
        if (curFontSize.endsWith("in")) {
            sizeInMm = LengthUtil.in2mm(value);
        } else if (curFontSize.endsWith("cm")) {
            sizeInMm = LengthUtil.cm2mm(value);
        } else if (curFontSize.endsWith("mm")) {
            sizeInMm = value;
        } else if (curFontSize.endsWith("pt")) {
            sizeInMm = LengthUtil.pt2mm(value);
        } else if (curFontSize.endsWith("pc")) {
            sizeInMm = LengthUtil.pc2mm(value);
        } else if (curFontSize.endsWith("px")) {
            sizeInMm = LengthUtil.px2mm(value);
        } else {
            throw new LowVisionException("unknown font size unit: " + curFontSize);
        }
        double severity = 2.0 - (double)(sizeInMm *= scaling) / (10.0 * eyesightLength);
        if (severity > 1.0) {
            severity = 1.0;
        } else if (severity < 0.0) {
            severity = 0.0;
        }
        if (severity > 0.0) {
            try {
                SmallFontProblem problem = new SmallFontProblem(this, _lvType, 0.25);
                problem.setElement(this.style.getElement());
                return problem;
            }
            catch (LowVisionProblemException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private ProhibitedForegroundColorProblem checkAllowedForegroundColors(LowVisionType _lvType, String[] _allowedColors) throws LowVisionException {
        if (_allowedColors == null) {
            return null;
        }
        int len = _allowedColors.length;
        if (len == 0) {
            return null;
        }
        if (!this.isTextTag()) {
            return null;
        }
        if (this.tagName.startsWith("a/")) {
            return null;
        }
        if (this.foregroundColor == 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            String curColorString = _allowedColors[i];
            ColorIRGB templateColor = null;
            try {
                templateColor = new ColorIRGB(curColorString);
            }
            catch (ColorException ce) {
                ce.printStackTrace();
                throw new LowVisionException("ColorException occurs while converting String \"" + curColorString + "\" to a color.");
            }
            if (templateColor.equals(this.foregroundColor)) {
                return null;
            }
            ++i;
        }
        try {
            return new ProhibitedForegroundColorProblem(this, _lvType, 0.5);
        }
        catch (LowVisionProblemException lvpe) {
            lvpe.printStackTrace();
            return null;
        }
    }

    private ProhibitedBackgroundColorProblem checkAllowedBackgroundColors(LowVisionType _lvType, String[] _allowedColors) throws LowVisionException {
        if (_allowedColors == null) {
            return null;
        }
        int len = _allowedColors.length;
        if (len == 0) {
            return null;
        }
        if (!this.isTextTag()) {
            return null;
        }
        if (this.backgroundColor == 0xFFFFFF) {
            return null;
        }
        int i = 0;
        while (i < len) {
            String curColorString = _allowedColors[i];
            ColorIRGB templateColor = null;
            try {
                templateColor = new ColorIRGB(curColorString);
            }
            catch (ColorException ce) {
                ce.printStackTrace();
                throw new LowVisionException("ColorException occurs while converting String \"" + curColorString + "\" to a color.");
            }
            if (templateColor.equals(this.backgroundColor)) {
                return null;
            }
            ++i;
        }
        try {
            return new ProhibitedBackgroundColorProblem(this, _lvType, 0.5);
        }
        catch (LowVisionProblemException lvpe) {
            lvpe.printStackTrace();
            return null;
        }
    }

    private boolean isTextTag() {
        String tagName = this.style.getTagName().toLowerCase();
        int len = nonTextTagNames.length;
        int i = 0;
        while (i < len) {
            if (tagName.startsWith(nonTextTagNames[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

