/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.ui.dialogs;

import java.util.EventObject;
import org.eclipse.actf.examples.adesigner.ADesignerPlugin;
import org.eclipse.actf.examples.adesigner.internal.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ModeSwitchDialog
extends TitleAreaDialog {
    private static final String MODE_SELECTED = "MODE_SELECTED";
    private Image htmlImage = ADesignerPlugin.getImageDescriptor("icons/perspectives/html.png").createImage();
    private Image flashImage = ADesignerPlugin.getImageDescriptor("icons/perspectives/flash.png").createImage();
    private Image guiImage = ADesignerPlugin.getImageDescriptor("icons/perspectives/msaa_ia2.png").createImage();
    private Image odfImage = ADesignerPlugin.getImageDescriptor("icons/perspectives/odf.png").createImage();
    private IWorkbenchWindow _window;
    private String _selectedPerspectiveID = ADesignerPlugin.getDefault().getPreferenceStore().getString("adesigner.preferences.selected.mode.perspective");
    private Composite _selectedComp = null;
    private Button _okButton;
    private Button _startupCheckButton;
    private Image[] modeIcons;

    public ModeSwitchDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this._window = window;
    }

    public String getSelectedPerspective() {
        return this._selectedPerspectiveID;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this._okButton.setFocus();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IPerspectiveDescriptor[] perspectiveDesc = this._window.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int length = perspectiveDesc.length;
        String[] modePerspectiveIDs = new String[length];
        String[] modeNames = new String[length];
        this.modeIcons = new Image[length];
        int i = 0;
        while (i < length) {
            IPerspectiveDescriptor desc = perspectiveDesc[i];
            modePerspectiveIDs[i] = desc.getId();
            modeNames[i] = desc.getLabel().replaceAll(" ", System.getProperty("line.separator"));
            Image tmpImg = null;
            if (modePerspectiveIDs[i].startsWith("org.eclipse.actf.visualization.ui.perspectives.")) {
                if (modePerspectiveIDs[i].endsWith("HTMLPerspective")) {
                    tmpImg = this.htmlImage;
                } else if (modePerspectiveIDs[i].endsWith("ODFPerspective")) {
                    tmpImg = this.odfImage;
                } else if (modePerspectiveIDs[i].endsWith("FlashPerspective")) {
                    tmpImg = this.flashImage;
                } else if (modePerspectiveIDs[i].endsWith("GUIPerspective")) {
                    tmpImg = this.guiImage;
                }
            }
            if (tmpImg == null) {
                tmpImg = desc.getImageDescriptor().createImage();
                ImageData tmpImgData = tmpImg.getImageData();
                this.modeIcons[i] = new Image((Device)this._window.getShell().getDisplay(), tmpImgData.scaledTo(tmpImgData.width * 2, tmpImgData.height * 2));
            } else {
                this.modeIcons[i] = tmpImg;
            }
            ++i;
        }
        int modeNum = modeNames.length;
        Composite modeBaseComp = new Composite(dialogArea, 0);
        modeBaseComp.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, true);
        modeBaseComp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 5;
        gridLayout.numColumns = modeNum;
        modeBaseComp.setLayout((Layout)gridLayout);
        int i2 = 0;
        while (i2 < modeNum) {
            Composite modeComp = new Composite(modeBaseComp, 0);
            modeComp.setBackground(Display.getCurrent().getSystemColor(1));
            gridData = new GridData(4, 4, true, true);
            modeComp.setLayoutData((Object)gridData);
            gridData.minimumWidth = 100;
            gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 0;
            modeComp.setLayout((Layout)gridLayout);
            this.createModeComposite(modeComp, modeNames[i2], this.modeIcons[i2], modePerspectiveIDs[i2]);
            ++i2;
        }
        Composite startupCheckComp = new Composite(dialogArea, 0);
        startupCheckComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridLayout = new GridLayout();
        gridLayout.marginRight = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginHeight = 0;
        startupCheckComp.setLayout((Layout)gridLayout);
        this._startupCheckButton = new Button(startupCheckComp, 32);
        this._startupCheckButton.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this._startupCheckButton.setText(Messages.ModeSwitchDialog_checkShowDialog);
        this._startupCheckButton.setSelection(ADesignerPlugin.getDefault().getPreferenceStore().getString("adesigner.preferences.startup.option") == "adesigner.preferences.startup.choise.show.mode.dialog");
        this.setMessage(Messages.ModeSwitchDialog_message);
        this.setTitle(Messages.ModeSwitchDialog_title);
        return dialogArea;
    }

    private void createModeComposite(Composite parent, String modeName, Image iconImage, String perspectiveID) {
        Composite iconComp = new Composite(parent, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 100;
        iconComp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        iconComp.setLayout((Layout)gridLayout);
        Label iconImageLabel = new Label(iconComp, 0);
        iconImageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        iconImageLabel.setImage(iconImage);
        Link modeNameLabel = new Link(parent, 0);
        modeNameLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        modeNameLabel.setText("<a>" + modeName + "</a>");
        modeNameLabel.addSelectionListener((SelectionListener)new ModeSwitchMouseAdapter(perspectiveID));
        modeNameLabel.addFocusListener((FocusListener)new ModeSwitchMouseAdapter(perspectiveID));
        modeNameLabel.setBackground(Display.getCurrent().getSystemColor(1));
        iconComp.addMouseListener((MouseListener)new ModeSwitchMouseAdapter(perspectiveID));
        iconComp.addMouseTrackListener((MouseTrackListener)new ModeSwitchMouseTrackAdapter());
        iconImageLabel.addMouseListener((MouseListener)new ModeSwitchMouseAdapter(perspectiveID));
        iconImageLabel.addMouseTrackListener((MouseTrackListener)new ModeSwitchMouseTrackAdapter());
        boolean isSelected = this._selectedPerspectiveID.equals(perspectiveID);
        iconComp.setData(MODE_SELECTED, (Object)new Boolean(isSelected));
        if (isSelected) {
            this.changeModeCompColor(iconComp, 27, 26);
            this._selectedComp = iconComp;
        } else {
            this.changeModeCompColor(iconComp, 2, 1);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADesignerPlugin.getResourceString("adesigner.window.title"));
    }

    protected void handleShellCloseEvent() {
        this.checkCache();
        super.handleShellCloseEvent();
    }

    protected void cancelPressed() {
        this.checkCache();
        super.cancelPressed();
    }

    protected void checkCache() {
        IPreferenceStore store = ADesignerPlugin.getDefault().getPreferenceStore();
        store.getString("adesigner.preferences.selected.mode.perspective").equals("org.eclipse.actf.visualization.ui.perspectives.FlashPerspective");
    }

    protected void okPressed() {
        try {
            IPerspectiveRegistry registry = this._window.getWorkbench().getPerspectiveRegistry();
            IWorkbenchPage page = this._window.getActivePage();
            page.setPerspective(registry.findPerspectiveWithId(this.getSelectedPerspective()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPreferenceStore store = ADesignerPlugin.getDefault().getPreferenceStore();
        if (this._startupCheckButton.getSelection()) {
            store.setValue("adesigner.preferences.startup.option", "adesigner.preferences.startup.choise.show.mode.dialog");
        } else {
            store.setValue("adesigner.preferences.startup.option", "adesigner.preferences.startup.choise.donot.show.mode.dialog");
        }
        store.setValue("adesigner.preferences.selected.mode.perspective", this._selectedPerspectiveID);
        this.checkCache();
        super.okPressed();
    }

    protected void changeModeCompColor(Composite selectedComp, int iFgColor, int iBgColor) {
        Composite selectedCompParent = selectedComp;
        selectedCompParent.setBackground(Display.getCurrent().getSystemColor(iBgColor));
        Control[] children = selectedCompParent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setBackground(Display.getCurrent().getSystemColor(iBgColor));
            children[i].setForeground(Display.getCurrent().getSystemColor(iFgColor));
            ++i;
        }
    }

    protected Composite getSelectedComp(EventObject evt) {
        Composite selectedComp = null;
        Object evtSrc = evt.getSource();
        selectedComp = evtSrc instanceof Label ? ((Label)evtSrc).getParent() : (evtSrc instanceof Link ? (Composite)((Link)evtSrc).getParent().getChildren()[0] : (Composite)evtSrc);
        return selectedComp;
    }

    private class ModeSwitchMouseAdapter
    extends MouseAdapter
    implements SelectionListener,
    FocusListener {
        private String _perspectiveID;

        ModeSwitchMouseAdapter(String perspectiveID) {
            this._perspectiveID = perspectiveID;
        }

        public void mouseUp(MouseEvent evt) {
            this.select((EventObject)evt);
        }

        public void select(EventObject evt) {
            ModeSwitchDialog.this._selectedPerspectiveID = this._perspectiveID;
            Composite selectedComp = ModeSwitchDialog.this.getSelectedComp(evt);
            if (selectedComp != null) {
                ModeSwitchDialog.this.changeModeCompColor(selectedComp, 27, 26);
                selectedComp.setData(ModeSwitchDialog.MODE_SELECTED, (Object)Boolean.TRUE);
                if (ModeSwitchDialog.this._selectedComp != null && !ModeSwitchDialog.this._selectedComp.equals(selectedComp)) {
                    ModeSwitchDialog.this._selectedComp.setData(ModeSwitchDialog.MODE_SELECTED, (Object)Boolean.FALSE);
                    ModeSwitchDialog.this.changeModeCompColor(ModeSwitchDialog.this._selectedComp, 2, 1);
                }
                ModeSwitchDialog.this._selectedComp = selectedComp;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.select((EventObject)e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.select((EventObject)e);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class ModeSwitchMouseTrackAdapter
    extends MouseTrackAdapter {
        private ModeSwitchMouseTrackAdapter() {
        }

        public void mouseEnter(MouseEvent evt) {
            this.select((EventObject)evt);
        }

        public void select(EventObject evt) {
            Composite selectedComp = ModeSwitchDialog.this.getSelectedComp(evt);
            if (selectedComp != null) {
                ModeSwitchDialog.this.changeModeCompColor(selectedComp, 27, 26);
            }
        }

        public void mouseExit(MouseEvent evt) {
            this.deselect((EventObject)evt);
        }

        public void deselect(EventObject evt) {
            Boolean isSelected;
            Composite selectedComp = ModeSwitchDialog.this.getSelectedComp(evt);
            if (selectedComp != null && (isSelected = (Boolean)selectedComp.getData(ModeSwitchDialog.MODE_SELECTED)) != null && !isSelected.booleanValue()) {
                ModeSwitchDialog.this.changeModeCompColor(selectedComp, 2, 1);
            }
        }
    }
}

