/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultTableLabelProviderLV
extends LabelProvider
implements ITableLabelProvider {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private int guidelineFinPos = 1 + this.guidelineHolder.getGuidelineData().length;

    public Image getColumnImage(Object object, int n) {
        IProblemItemImage iProblemItemImage = (IProblemItemImage)object;
        if (n == 0) {
            return iProblemItemImage.getIconImage();
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        IProblemItemImage iProblemItemImage = (IProblemItemImage)object;
        if (n == 0) {
            return iProblemItemImage.getIconTooltip();
        }
        if (n < this.guidelineFinPos) {
            try {
                return iProblemItemImage.getEvaluationItem().getTableDataGuideline()[n - 1];
            }
            catch (Exception exception) {
                return "";
            }
        }
        switch (n - this.guidelineFinPos) {
            case 0: {
                if (iProblemItemImage.getSeverityLV() > 0) {
                    return Integer.toString(iProblemItemImage.getSeverityLV());
                }
                return "-";
            }
            case 1: {
                return iProblemItemImage.getForeground();
            }
            case 2: {
                return iProblemItemImage.getBackground();
            }
            case 3: {
                return Integer.toString(iProblemItemImage.getX());
            }
            case 4: {
                return Integer.toString(iProblemItemImage.getY());
            }
            case 5: {
                return Integer.toString(iProblemItemImage.getArea());
            }
            case 6: {
                return iProblemItemImage.getEvaluationItem().getTableDataTechniques();
            }
            case 7: {
                return iProblemItemImage.getDescription();
            }
        }
        return "";
    }
}

