/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.sapi.engine;

import org.eclipse.actf.ai.tts.sapi.engine.ISpVoice;
import org.eclipse.actf.ai.tts.sapi.engine.SpEvent;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;

public class ISpNotifySource
extends IDispatch {
    public static final GUID IID = COMUtil.IIDFromString((String)"{5EFF4AEF-8487-11D2-961C-00C04F8EE628}");
    public static final int SPEI_START_INPUT_STREAM = 1;
    public static final int SPEI_END_INPUT_STREAM = 2;
    public static final int SPEI_VOICE_CHANGE = 3;
    public static final int SPEI_TTS_BOOKMARK = 4;
    public static final int SPEI_WORD_BOUNDARY = 5;
    public static final int SPEI_PHONEME = 6;
    public static final int SPEI_SENTENCE_BOUNDARY = 7;
    public static final int SPEI_VISEME = 8;
    public static final int SPEI_TTS_AUDIO_LEVEL = 9;
    private int address;
    private Callback callback = null;
    private IVoiceEventListener eventListener = null;

    public ISpNotifySource(int address) {
        super(address);
        this.address = address;
        this.callback = new Callback((Object)this, "SAPINotifyCallback", 2);
        this.SetNotifyCallbackFunction(this.callback.getAddress(), 0, 0);
        this.SetInterest(16, 16);
    }

    public static ISpNotifySource getNotifySource(ISpVoice dispatch) {
        int[] ppv = new int[1];
        if (dispatch.QueryInterface(IID, ppv) == 0) {
            return new ISpNotifySource(ppv[0]);
        }
        return null;
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.eventListener = eventListener;
    }

    int SAPINotifyCallback(int wParam, int lParam) {
        SpEvent se = new SpEvent();
        try {
            while (this.GetEvent(se.getAddress()) == 0) {
                String eventName;
                if (this.eventListener != null) {
                    if (4 != se.getEventId()) continue;
                    this.eventListener.indexReceived(se.getWParam());
                    continue;
                }
                switch (se.getEventId()) {
                    case 1: {
                        eventName = "SPEI_START_INPUT_STREAM";
                        break;
                    }
                    case 2: {
                        eventName = "SPEI_END_INPUT_STREAM";
                        break;
                    }
                    case 3: {
                        eventName = "SPEI_VOICE_CHANGE";
                        break;
                    }
                    case 4: {
                        eventName = "SPEI_TTS_BOOKMARK";
                        break;
                    }
                    case 5: {
                        eventName = "SPEI_WORD_BOUNDARY";
                        break;
                    }
                    case 6: {
                        eventName = "SPEI_PHONEME";
                        break;
                    }
                    case 7: {
                        eventName = "SPEI_SENTENCE_BOUNDARY";
                        break;
                    }
                    case 8: {
                        eventName = "SPEI_VISEME";
                        break;
                    }
                    case 9: {
                        eventName = "SPEI_TTS_AUDIO_LEVEL";
                        break;
                    }
                    default: {
                        eventName = "Unknown+(" + se.getEventId() + ")";
                    }
                }
                System.out.println(String.valueOf(eventName) + ": " + se.getLParamType() + "/" + se.getStreamNum() + "/" + se.getAudioStreamOffset() + "/" + se.getLParam() + "/" + se.getWParam());
            }
        }
        finally {
            se.dispose();
        }
        return 0;
    }

    public int SetNotifyCallbackFunction(int pCallbackAddress, int wParam, int lParam) {
        return COMUtil.VtblCall((int)5, (int)this.address, (int)pCallbackAddress, (int)wParam, (int)lParam);
    }

    public int SetInterest(int eventInterest, int queuedInterest) {
        return COMUtil.VtblCall((int)10, (int)this.address, (int)(0x40000000 | eventInterest), (int)2, (int)(0x40000000 | queuedInterest), (int)2);
    }

    public int GetEvent(int pSPEVENTAddress) {
        return COMUtil.VtblCall((int)11, (int)this.address, (int)1, (int)pSPEVENTAddress, (int)0);
    }
}

