/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.base.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.AbstractODFNodeFactory;
import org.eclipse.actf.model.dom.odf.base.impl.ODFAttrImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFCharacterDataImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFCommentImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFNodeListImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFProcessingInstructionImpl;
import org.eclipse.actf.model.dom.odf.base.impl.ODFTextImpl;
import org.eclipse.actf.model.dom.odf.chart.impl.ChartNodeFactory;
import org.eclipse.actf.model.dom.odf.dr3d.impl.Dr3dNodeFactory;
import org.eclipse.actf.model.dom.odf.draw.impl.DrawNodeFactory;
import org.eclipse.actf.model.dom.odf.form.impl.FormNodeFactory;
import org.eclipse.actf.model.dom.odf.number.impl.NumberNodeFactory;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.DocumentStylesElement;
import org.eclipse.actf.model.dom.odf.office.impl.OfficeNodeFactory;
import org.eclipse.actf.model.dom.odf.presentation.impl.PresentationNodeFactory;
import org.eclipse.actf.model.dom.odf.style.impl.StyleNodeFactory;
import org.eclipse.actf.model.dom.odf.svg.impl.SVGNodeFactory;
import org.eclipse.actf.model.dom.odf.table.impl.TableNodeFactory;
import org.eclipse.actf.model.dom.odf.text.impl.TextNodeFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFDocumentImpl
extends ODFNodeImpl
implements ODFDocument {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Class<? extends AbstractODFNodeFactory>> factoryMap = new HashMap<String, Class<? extends AbstractODFNodeFactory>>();
    private Map<Node, ODFNode> internalNodeMap = new HashMap<Node, ODFNode>();
    private String sUrl = null;
    private ODFDocument styleDoc = null;

    static {
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:chart:1.0", ChartNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0", Dr3dNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", DrawNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:form:1.0", FormNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0", NumberNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:office:1.0", OfficeNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:presentation:1.0", PresentationNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:style:1.0", StyleNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:table:1.0", TableNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:text:1.0", TextNodeFactory.class);
        factoryMap.put("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", SVGNodeFactory.class);
    }

    public ODFDocumentImpl(Document doc) {
        super(doc);
        this.internalNodeMap.put(doc, this);
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createCDATASection(data);
        }
        return null;
    }

    @Override
    public Comment createComment(String data) {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createComment(data);
        }
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        if (this.iNode instanceof Document) {
            return (Element)((Object)this.getODFNode(((Document)this.iNode).createElement(tagName)));
        }
        return null;
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (this.iNode instanceof Document) {
            return (Element)((Object)this.getODFNode(((Document)this.iNode).createElementNS(namespaceURI, qualifiedName)));
        }
        return null;
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createEntityReference(name);
        }
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).createProcessingInstruction(target, data);
        }
        return null;
    }

    @Override
    public Text createTextNode(String data) {
        if (this.iNode instanceof Document) {
            Text iText = ((Document)this.iNode).createTextNode(data);
            return (Text)((Object)this.getODFNode(iText));
        }
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDoctype();
        }
        return null;
    }

    @Override
    public Element getDocumentElement() {
        if (this.iNode instanceof Document) {
            Element iElem = ((Document)this.iNode).getDocumentElement();
            if (iElem == null) {
                return iElem;
            }
            return (Element)((Object)this.getODFNode(iElem));
        }
        return null;
    }

    @Override
    public String getDocumentURI() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDocumentURI();
        }
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getDomConfig();
        }
        return null;
    }

    @Override
    public Element getElementById(String elementId) {
        if (this.iNode instanceof Document) {
            Element iElem = ((Document)this.iNode).getElementById(elementId);
            if (iElem == null) {
                return null;
            }
            return (Element)((Object)this.getODFNode(iElem));
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        if (this.iNode instanceof Document) {
            NodeList iNodeList = ((Document)this.iNode).getElementsByTagName(tagname);
            if (iNodeList == null) {
                return null;
            }
            return new ODFNodeListImpl(this, iNodeList);
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (this.iNode instanceof Document) {
            NodeList iNodeList = ((Document)this.iNode).getElementsByTagNameNS(namespaceURI, localName);
            if (iNodeList == null) {
                return null;
            }
            return new ODFNodeListImpl(this, iNodeList);
        }
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getImplementation();
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getInputEncoding();
        }
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getStrictErrorChecking();
        }
        return false;
    }

    @Override
    public String getXmlEncoding() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlEncoding();
        }
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlStandalone();
        }
        return false;
    }

    @Override
    public String getXmlVersion() {
        if (this.iNode instanceof Document) {
            return ((Document)this.iNode).getXmlVersion();
        }
        return null;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setDocumentURI(documentURI);
        }
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setStrictErrorChecking(strictErrorChecking);
        }
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setXmlStandalone(xmlStandalone);
        }
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        if (this.iNode instanceof Document) {
            ((Document)this.iNode).setXmlVersion(xmlVersion);
        }
    }

    private Method findCreateElementMethod(Class<? extends AbstractODFNodeFactory> cs) {
        Method[] methods = cs.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] parms;
            if ("createElement".equals(methods[i].getName()) && (parms = methods[i].getParameterTypes()).length == 3 && parms[0].equals(ODFDocument.class) && parms[1].equals(String.class) && parms[2].equals(Element.class)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public ODFNode getODFNode(Node node) {
        ODFNode result = this.internalNodeMap.get(node);
        if (result != null) {
            return result;
        }
        Class<? extends AbstractODFNodeFactory> factory = factoryMap.get(node.getNamespaceURI());
        if (factory != null && node instanceof Element) {
            Method createElemMethod = this.findCreateElementMethod(factory);
            try {
                result = (ODFNode)createElemMethod.invoke(factory, this, node.getLocalName(), (Element)node);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (result == null) {
            result = node instanceof Element ? new ODFElementImpl((ODFDocument)this, (Element)node) : (node instanceof Attr ? new ODFAttrImpl((ODFDocument)this, (Attr)node) : (node instanceof Text ? new ODFTextImpl((ODFDocument)this, (Text)node) : (node instanceof Comment ? new ODFCommentImpl((ODFDocument)this, (Comment)node) : (node instanceof CharacterData ? new ODFCharacterDataImpl((ODFDocument)this, (CharacterData)node) : (node instanceof ProcessingInstruction ? new ODFProcessingInstructionImpl((ODFDocument)this, (ProcessingInstruction)node) : new ODFNodeImpl(this, node))))));
        }
        this.internalNodeMap.put(node, result);
        return result;
    }

    @Override
    public String getURL() {
        return this.sUrl;
    }

    @Override
    public void setURL(String sUrl) {
        this.sUrl = sUrl;
    }

    @Override
    public void setODFVersion(double version) {
        Element root = this.getDocumentElement();
        root.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", new Double(version).toString());
    }

    @Override
    public double getODFVersion() {
        Element root = this.getDocumentElement();
        if (root instanceof DocumentContentElement) {
            return ((DocumentContentElement)root).getAttrOfficeVersion();
        }
        if (root instanceof DocumentStylesElement) {
            return ((DocumentStylesElement)root).getAttrOfficeVersion();
        }
        return -1.0;
    }

    @Override
    public void setStyleDocument(ODFDocument styleDoc) {
        this.styleDoc = styleDoc;
    }

    @Override
    public ODFDocument getStyleDocument() {
        return this.styleDoc;
    }
}

