/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.actf.util.FileUtils;

public class TempFileUtil {
    static final int EOF = -1;
    private static FileInputStream fis = null;
    private static FileOutputStream fos = null;
    private static DataInputStream dis = null;
    private static DataOutputStream dos = null;
    private static CopyStreamTempFileThread instCopyThread = null;
    private static WriteStreamTempFileThread instWriteThread = null;
    private static boolean statusActiveThread = false;
    private static ArrayList<Integer> listStartTime = null;
    private static ArrayList<Integer> listVolLvl = null;

    public static File createTempFile(String parentDir, String prefix, String suffix) {
        File tempFile = null;
        try {
            File dh = TempFileUtil.createTempDirectory(parentDir);
            if (dh != null) {
                tempFile = File.createTempFile(prefix, suffix, dh);
            }
        }
        catch (IOException ee) {
            System.out.println("createTempFile() : " + ee);
        }
        return tempFile;
    }

    private static File createTempDirectory(String parentDir) {
        File result = null;
        String tmpS = String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + "tmp" + File.separator + parentDir + File.separator;
        if (FileUtils.isAvailableDirectory((String)tmpS)) {
            result = new File(tmpS);
        } else {
            System.err.println("createTempDirectory() : can't create tmp Directory");
            result = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + parentDir);
        }
        return result;
    }

    public static String getAbsTempFile(File fh) {
        return fh.getAbsolutePath();
    }

    public static void copyStreamTempFile(String srcFilePath, String desFilePath) {
        if (!statusActiveThread) {
            fis = null;
            fos = null;
            try {
                fis = new FileInputStream(srcFilePath);
                fos = new FileOutputStream(desFilePath);
                if (fis != null && fos != null) {
                    statusActiveThread = true;
                    instCopyThread = new CopyStreamTempFileThread();
                    instCopyThread.start();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void writeStreamTempFile(ArrayList<Integer> srcData1, ArrayList<Integer> srcData2, String desFilePath) {
        if (!statusActiveThread) {
            fos = null;
            dos = null;
            try {
                fos = new FileOutputStream(desFilePath);
                if (fos != null) {
                    dos = new DataOutputStream(fos);
                    listStartTime = new ArrayList<Integer>(srcData1);
                    listVolLvl = new ArrayList<Integer>(srcData2);
                    statusActiveThread = true;
                    instWriteThread = new WriteStreamTempFileThread();
                    instWriteThread.start();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean openInputStreamTempFile(String srcFilePath) {
        if (!statusActiveThread) {
            fis = null;
            dis = null;
            try {
                fis = new FileInputStream(srcFilePath);
                dis = new DataInputStream(fis);
                if (fis != null && dis != null) {
                    statusActiveThread = true;
                }
            }
            catch (Exception exception) {}
        }
        return statusActiveThread;
    }

    public static int readIntValueTempFile() {
        int result = -1;
        try {
            result = dis.readInt();
        }
        catch (EOFException eOFException) {
            result = -1;
        }
        catch (Exception exception) {
            result = -1;
        }
        return result;
    }

    public static void closeInputStreamTempFile() {
        try {
            try {
                dis.close();
                fis.close();
            }
            catch (Exception exception) {
                statusActiveThread = false;
            }
        }
        finally {
            statusActiveThread = false;
        }
    }

    public static boolean isActiveTempFileThread() {
        return statusActiveThread;
    }

    public static URI getResource(String fpath) {
        URI result = null;
        fpath = fpath.replace("file:/", "");
        File fh = new File(fpath);
        result = fh.toURI();
        return result;
    }

    private static class CopyStreamTempFileThread
    extends Thread {
        private CopyStreamTempFileThread() {
        }

        @Override
        public void run() {
            byte[] copyBuffer = new byte[4096];
            try {
                while (statusActiveThread) {
                    int len;
                    if (fis.available() > 0) {
                        len = fis.read(copyBuffer);
                        if (len == -1) {
                            this.closeThread();
                            break;
                        }
                    } else {
                        this.closeThread();
                        break;
                    }
                    fos.write(copyBuffer, 0, len);
                    Thread.yield();
                }
            }
            catch (Exception exception) {}
        }

        private void closeThread() {
            statusActiveThread = false;
            instCopyThread = null;
            try {
                fis.close();
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static class WriteStreamTempFileThread
    extends Thread {
        private WriteStreamTempFileThread() {
        }

        @Override
        public void run() {
            int location = 0;
            int max = listStartTime.size();
            try {
                while (statusActiveThread) {
                    if (++location >= max) {
                        this.closeThread();
                        break;
                    }
                    dos.writeInt((Integer)listStartTime.get(location));
                    dos.writeInt((Integer)listVolLvl.get(location));
                    Thread.yield();
                }
            }
            catch (Exception exception) {}
        }

        private void closeThread() {
            statusActiveThread = false;
            instWriteThread = null;
            try {
                dos.close();
                fos.close();
                listStartTime.clear();
                listVolLvl.clear();
                listStartTime = null;
                listVolLvl = null;
            }
            catch (Exception exception) {}
        }
    }
}

