/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.data;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.util.FileUtils;

public class ScriptData
implements IUNIT {
    private static ScriptData ownInst = null;
    private ArrayList<String> ScriptList;
    private ArrayList<Integer> ScriptStartTime;
    private ArrayList<Integer> ScriptEndTime;
    private ArrayList<StructScriptComment> ScriptComment;
    private ArrayList<StructExtendData> ExtendList;
    private ArrayList<Integer> listStartTimeWav = null;
    private ArrayList<Integer> listEndTimeWav = null;
    private ArrayList<URI> listFileNameWav = null;
    private ArrayList<Boolean> listEnableWav = null;
    private ArrayList<Float> listPlaySpeedWav = null;
    private boolean status_edit_scripts = false;
    private boolean status_import_csv = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptData getInstance() {
        if (ownInst != null) return ownInst;
        Class<ScriptData> clazz = ScriptData.class;
        synchronized (ScriptData.class) {
            if (ownInst != null) return ownInst;
            ownInst = new ScriptData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ownInst;
        }
    }

    public ScriptData() {
        this.initializeScriptData();
        this.initializeWavData();
    }

    private void initializeScriptData() {
        this.ScriptList = new ArrayList();
        this.ScriptStartTime = new ArrayList();
        this.ScriptEndTime = new ArrayList();
        this.ExtendList = new ArrayList();
        this.ScriptComment = new ArrayList();
    }

    private void initializeWavData() {
        this.listStartTimeWav = new ArrayList();
        this.listEndTimeWav = new ArrayList();
        this.listFileNameWav = new ArrayList();
        this.listEnableWav = new ArrayList();
        this.listPlaySpeedWav = new ArrayList();
    }

    public void clearScriptData() {
        this.ScriptList.clear();
        this.ScriptStartTime.clear();
        this.ScriptEndTime.clear();
        this.ScriptComment.clear();
        this.ExtendList.clear();
    }

    private int indexScriptData(int startTime) {
        int index = -1;
        if (this.ScriptStartTime.isEmpty()) {
            index = 0;
        } else {
            int i = 0;
            while (i < this.ScriptStartTime.size()) {
                if (startTime < this.ScriptStartTime.get(i)) break;
                ++i;
            }
            index = i;
        }
        return index;
    }

    public int getLengthScriptList() {
        return this.ScriptList.size();
    }

    public int setScriptData(String data, int startTime, int endTime) {
        this.ScriptList.add(data);
        this.ScriptStartTime.add(startTime);
        this.ScriptEndTime.add(endTime);
        return this.ScriptList.size();
    }

    public int searchScriptData(int startTime) {
        int index = this.ScriptStartTime.indexOf(startTime);
        return index;
    }

    public int parseIntStartTime(String MM, String SS, String MS) {
        int startTime = Integer.parseInt(MM) * 60 + Integer.parseInt(SS);
        startTime = startTime * 1000 + Integer.parseInt(MS);
        return startTime;
    }

    public int parseIntStartTime(String MMSSMS) {
        String[] eachTime = MMSSMS.split(":", 0);
        int startTime = Integer.parseInt(eachTime[0]) * 60 + Integer.parseInt(eachTime[1]);
        startTime = startTime * 1000 + Integer.parseInt(eachTime[2]);
        return startTime;
    }

    public int getStatusSaveScripts() {
        int result = 0;
        if (this.getStatusImportCsv()) {
            result = 5;
        } else if (this.getStatusEditingScripts()) {
            result = 2;
        }
        return result;
    }

    public boolean getStatusEditingScripts() {
        return this.status_edit_scripts;
    }

    public boolean getStatusImportCsv() {
        return this.status_import_csv;
    }

    public void setStatusSaveScripts(int mode, boolean stat) {
        if (!stat) {
            this.setStatusEditingScripts(stat);
            this.setStatusImportCsv(stat);
        } else if (mode == 1 || mode == 2) {
            this.setStatusEditingScripts(stat);
        } else if (mode == 5) {
            this.setStatusImportCsv(stat);
        }
    }

    public void setStatusEditingScripts(boolean stat) {
        this.status_edit_scripts = stat;
    }

    public void setStatusImportCsv(boolean stat) {
        this.status_import_csv = stat;
    }

    public String getScriptData(int index) {
        String currentScriptData = new String();
        currentScriptData = index >= 0 && index <= this.ScriptList.size() - 1 ? this.ScriptList.get(index).toString() : "";
        return currentScriptData;
    }

    public int getScriptStartTime(int index) {
        int currentScriptStartTime = -1;
        if (index >= 0 && index <= this.ScriptStartTime.size() - 1) {
            currentScriptStartTime = this.ScriptStartTime.get(index);
        }
        return currentScriptStartTime;
    }

    public int getScriptEndTime(int index) {
        int currentScriptEndTime = -1;
        if (index >= 0 && index <= this.ScriptEndTime.size() - 1) {
            currentScriptEndTime = this.ScriptEndTime.get(index);
        }
        return currentScriptEndTime;
    }

    public int getIndexScriptData(String startMM, String startSS, String startMS) {
        int startTime = 0;
        startTime = this.parseIntStartTime(startMM, startSS, startMS);
        int index = this.searchScriptData(startTime);
        return index;
    }

    public int getIndexScriptData(int startTime) {
        int index = this.searchScriptData(startTime);
        return index;
    }

    public int updateScriptEndTime(int startTime, int endTime) {
        int index = this.ScriptStartTime.indexOf(startTime);
        if (index >= 0) {
            this.ScriptEndTime.set(index, endTime);
        }
        return index;
    }

    public boolean appendScriptData(String scriptData, int startTime, int endTime) {
        boolean result = true;
        int index = -1;
        if (scriptData.isEmpty()) {
            result = false;
        } else {
            index = this.searchScriptData(startTime);
            if (index >= 0) {
                this.ScriptList.set(index, scriptData);
                this.ScriptEndTime.set(index, endTime);
            } else {
                index = this.indexScriptData(startTime);
                if (index >= 0) {
                    this.ScriptList.add(index, scriptData);
                    this.ScriptStartTime.add(index, startTime);
                    this.ScriptEndTime.add(index, endTime);
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean appendScriptData(String scriptData, int startTime, int endTime, String comment) {
        boolean result = true;
        result = this.appendScriptData(scriptData, startTime, endTime);
        if (result) {
            this.setScriptComment(startTime, comment);
        }
        return result;
    }

    public boolean appendScriptData(String scriptData, String startMM, String startSS, String startMS, int endTime) {
        boolean result = true;
        int startTime = 0;
        int index = -1;
        startTime = this.parseIntStartTime(startMM, startSS, startMS);
        if (scriptData.isEmpty()) {
            result = false;
        } else {
            index = this.searchScriptData(startTime);
            if (index >= 0) {
                this.ScriptList.set(index, scriptData);
                this.ScriptEndTime.set(index, endTime);
            } else {
                index = this.indexScriptData(startTime);
                if (index >= 0) {
                    this.ScriptList.add(index, scriptData);
                    this.ScriptStartTime.add(index, startTime);
                    this.ScriptEndTime.add(index, endTime);
                } else {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean deleteScriptData(String startMM, String startSS, String startMS) {
        boolean result = true;
        int startTime = 0;
        int index = -1;
        startTime = this.parseIntStartTime(startMM, startSS, startMS);
        index = this.searchScriptData(startTime);
        if (index >= 0) {
            this.ScriptList.remove(index);
            this.ScriptStartTime.remove(index);
            this.ScriptEndTime.remove(index);
        } else {
            result = false;
        }
        return result;
    }

    public boolean deleteScriptData(int index) {
        boolean result = true;
        try {
            this.ScriptList.remove(index);
            this.ScriptStartTime.remove(index);
            this.ScriptEndTime.remove(index);
        }
        catch (Exception e) {
            System.out.println("deleteScriptData() : Exception = " + e);
            result = false;
        }
        return result;
    }

    public Boolean getExtendExtended(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getExtended();
    }

    public Boolean getExtendGender(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getGender();
    }

    public int getExtendSpeed(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getSpeed();
    }

    public int getExtendPitch(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getPitch();
    }

    public int getExtendVolume(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getVolume();
    }

    public String getExtendLang(int index) {
        StructExtendData currentExtendData = this.ExtendList.get(index);
        return currentExtendData.getLang();
    }

    public void appendExtendData(int index, int starttime, Boolean extendExtended, Boolean extendSex, int extendSpeed, int extendPitch, int extendVolume, String extendLang) {
        StructExtendData newExtendData = new StructExtendData(starttime, extendExtended, extendSex, extendSpeed, extendPitch, extendVolume, extendLang);
        if (this.ExtendList.isEmpty()) {
            this.ExtendList.add(0, newExtendData);
        } else if (index >= this.ExtendList.size()) {
            this.ExtendList.add(index, newExtendData);
        } else {
            try {
                StructExtendData currentExtendData = this.ExtendList.get(index);
                if (starttime != currentExtendData.getStartTime()) {
                    this.ExtendList.add(index, newExtendData);
                } else {
                    this.ExtendList.set(index, newExtendData);
                }
            }
            catch (Exception e) {
                System.out.println("appendExtendData() : Exception = " + e);
            }
        }
    }

    public void deleteExtendData(int starttime) {
        if (!this.ExtendList.isEmpty()) {
            int index = 0;
            while (index < this.ExtendList.size()) {
                StructExtendData currentExtendData = this.ExtendList.get(index);
                if (starttime == currentExtendData.getStartTime()) {
                    this.ExtendList.remove(index);
                    break;
                }
                ++index;
            }
        }
    }

    public String makeFormatHHMMSS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00:00:00";
        } else {
            Integer hh = totalSec / 3600;
            Integer mm = totalSec / 60 - hh * 60;
            Integer ss = totalSec % 60;
            formTime = "";
            if (hh < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + hh.toString();
            formTime = String.valueOf(formTime) + ":";
            if (mm < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + mm.toString();
            formTime = String.valueOf(formTime) + ":";
            if (ss < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ss.toString();
        }
        return formTime;
    }

    public String makeFormatMMSSMS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00 : 00 . 000";
        } else {
            Integer mm = totalSec / 1000 / 60;
            Integer ss = totalSec / 1000 % 60;
            Integer ms = totalSec % 1000;
            formTime = "";
            if (mm < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + mm.toString();
            formTime = String.valueOf(formTime) + " : ";
            if (ss < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ss.toString();
            formTime = String.valueOf(formTime) + " . ";
            if (ms < 10) {
                formTime = String.valueOf(formTime) + "00";
            } else if (ms < 100 && ms >= 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ms.toString();
        }
        return formTime;
    }

    public String makeFormatHH(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00";
        } else {
            Integer hh = totalSec / 3600;
            formTime = "";
            if (hh < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + hh.toString();
        }
        return formTime;
    }

    public String makeFormatMM(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00";
        } else {
            Integer tm = totalSec / 1000;
            Integer mm = tm / 60;
            formTime = "";
            if (mm < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + mm.toString();
        }
        return formTime;
    }

    public String makeFormatSS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "00";
        } else {
            Integer ss = totalSec / 1000 % 60;
            formTime = "";
            if (ss < 10) {
                formTime = String.valueOf(formTime) + "0";
            }
            formTime = String.valueOf(formTime) + ss.toString();
        }
        return formTime;
    }

    public String makeFormatMS(int totalSec) {
        String formTime = new String();
        if (totalSec <= 0) {
            formTime = "000";
        } else {
            Integer ms = totalSec % 1000;
            formTime = "";
            if (ms < 10) {
                formTime = "00";
            } else if (ms < 100 && ms >= 10) {
                formTime = "0";
            }
            formTime = String.valueOf(formTime) + ms.toString();
        }
        return formTime;
    }

    public String toXMLfragment() {
        StringBuffer tmpSB = new StringBuffer();
        int i = 0;
        while (i < this.getLengthScriptList()) {
            int startTime = this.getScriptStartTime(i);
            String strStartTime = String.valueOf(this.makeFormatMM(startTime)) + ":" + this.makeFormatSS(startTime) + ":" + this.makeFormatMS(startTime);
            int duration = this.getScriptEndTime(i) - startTime;
            String strDuration = String.valueOf(this.makeFormatMM(duration)) + ":" + this.makeFormatSS(duration) + ":" + this.makeFormatMS(duration);
            String strDesc = this.getScriptData(i);
            int speed = this.getExtendSpeed(i);
            String strSpeed = String.valueOf(speed);
            boolean gender = this.getExtendGender(i);
            String strGender = new String(gender ? "male" : "female");
            String strExtended = new String(this.getExtendExtended(i) != false ? " extended=\"true\"" : "");
            String strServerUri = "";
            String strLocalUri = "";
            String strWavSpeed = "";
            int wavNo = this.getIndexWavList(startTime);
            boolean wavEnable = false;
            if (wavNo >= 0) {
                wavEnable = this.getEnableWavList(wavNo);
            }
            String LINE_SEP = FileUtils.LINE_SEP;
            tmpSB.append("\t<item importance=\"high\">" + LINE_SEP);
            tmpSB.append("\t  <start type=\"relTime\">" + strStartTime + "</start>" + LINE_SEP);
            tmpSB.append("\t  <duration>" + strDuration + "</duration>" + LINE_SEP);
            tmpSB.append("\t  <description xml:lang=\"" + this.getExtendLang(i) + "\" " + "speed=\"" + strSpeed + "\" " + "gender=\"" + strGender + "\"" + strExtended + ">" + strDesc + "</description>" + LINE_SEP);
            if (wavNo >= 0) {
                try {
                    strServerUri = this.getFileNameWavList(wavNo).toURL().toString();
                    strLocalUri = this.getFileNameWavList(wavNo).toURL().toString();
                    strWavSpeed = String.valueOf((int)(this.getPlaySpeedWavList(wavNo) * 100.0f));
                    duration = this.getEndTimeWavList(wavNo) - this.getStartTimeWavList(wavNo);
                    strDuration = String.valueOf(this.makeFormatMM(duration)) + ":" + this.makeFormatSS(duration) + ":" + this.makeFormatMS(duration);
                    tmpSB.append("\t  <wave uri=\"" + strServerUri + "\" local=\"" + strLocalUri + "\" duration=\"" + strDuration + "\" speed=\"" + strWavSpeed + "\"");
                    if (!wavEnable) {
                        tmpSB.append(" enabled=\"false\"");
                    }
                    tmpSB.append("/>" + LINE_SEP);
                }
                catch (MalformedURLException e) {
                    System.out.println("toXMLfragment() : " + e);
                }
                catch (Exception exception) {}
            }
            tmpSB.append("\t</item>" + LINE_SEP);
            ++i;
        }
        return tmpSB.toString();
    }

    public String toCSVfragment() {
        String LINE_SEP = FileUtils.LINE_SEP;
        String COLUMN_SEP = ",";
        String DQUOTE_CODE = "\"";
        StringBuffer tmpSB = new StringBuffer();
        int i = 0;
        while (i < this.getLengthScriptList()) {
            int index;
            int startTime = this.getScriptStartTime(i);
            String strStartTime = String.valueOf(this.makeFormatMM(startTime)) + ":" + this.makeFormatSS(startTime) + ":" + this.makeFormatMS(startTime);
            String wavLocalPath = "";
            String wavEnable = "";
            String wavSpeed = "";
            int wavNo = this.getIndexWavList(startTime);
            if (wavNo >= 0) {
                wavLocalPath = this.getFileNameWavList(wavNo).getPath().replace("/", "\\");
                wavEnable = this.getEnableWavList(wavNo) ? "1" : "0";
                wavSpeed = String.valueOf((int)(this.getPlaySpeedWavList(wavNo) * 100.0f));
            }
            String strExtended = this.getExtendExtended(index = this.getIndexScriptData(startTime)) != false ? "1" : "0";
            String strGender = this.getExtendGender(index) != false ? "male" : "female";
            String strSpeed = String.valueOf(this.getExtendSpeed(index));
            String strPitch = String.valueOf(this.getExtendPitch(index));
            String strVolume = String.valueOf(this.getExtendVolume(index));
            String strDesc = this.getScriptData(i);
            if (strDesc.indexOf("\n") >= 0 || strDesc.indexOf("\r") >= 0) {
                strDesc = String.valueOf(DQUOTE_CODE) + strDesc + DQUOTE_CODE;
            }
            tmpSB.append(String.valueOf(strStartTime) + COLUMN_SEP);
            tmpSB.append(String.valueOf(wavLocalPath) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strExtended) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strGender) + COLUMN_SEP);
            tmpSB.append(String.valueOf(this.getExtendLang(index)) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strSpeed) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strPitch) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strVolume) + COLUMN_SEP);
            tmpSB.append(String.valueOf(wavEnable) + COLUMN_SEP);
            tmpSB.append(String.valueOf(wavSpeed) + COLUMN_SEP);
            tmpSB.append(String.valueOf(strDesc) + COLUMN_SEP);
            tmpSB.append(LINE_SEP);
            ++i;
        }
        return tmpSB.toString();
    }

    public int getIndexScriptComment(int startTime) {
        int index = -1;
        if (!this.ScriptComment.isEmpty()) {
            int i = 0;
            while (i < this.ScriptComment.size()) {
                StructScriptComment currentScriptComment = this.ScriptComment.get(i);
                if (startTime == currentScriptComment.getStartTime()) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    public String getScriptComment(int index) {
        String comment = "";
        if (!this.ScriptComment.isEmpty() && index >= 0 && index < this.ScriptComment.size()) {
            StructScriptComment currentScriptComment = this.ScriptComment.get(index);
            comment = currentScriptComment.getScriptComment();
        }
        return comment;
    }

    public void setScriptComment(int startTime, String comment) {
        int index = this.getIndexScriptComment(startTime);
        if (index >= 0) {
            StructScriptComment targetComment = this.ScriptComment.get(index);
            targetComment.setScriptComment(comment);
        } else {
            StructScriptComment newComment = new StructScriptComment(startTime, comment);
            this.ScriptComment.add(newComment);
        }
    }

    public void cleanupWavList() {
        this.listStartTimeWav.clear();
        this.listEndTimeWav.clear();
        this.listFileNameWav.clear();
        this.listEnableWav.clear();
        this.listPlaySpeedWav.clear();
    }

    public int getLengthWavList() {
        int len = -1;
        if (!this.listStartTimeWav.isEmpty()) {
            len = this.listStartTimeWav.size();
        }
        return len;
    }

    public int getIndexWavList(int startTime) {
        int index = -1;
        int len = this.getLengthWavList();
        if (len > 0) {
            index = this.listStartTimeWav.indexOf(startTime);
        }
        return index;
    }

    public int searchInsertIndexWavList(int startTime) {
        int index = -1;
        if (this.listStartTimeWav.isEmpty()) {
            index = 0;
        } else {
            int i = 0;
            while (i < this.listStartTimeWav.size()) {
                if (startTime < this.listStartTimeWav.get(i)) break;
                ++i;
            }
            index = i;
        }
        return index;
    }

    public int getStartTimeWavList(int index) {
        int result = -1;
        int len = this.getLengthWavList();
        if (len > 0 && index >= 0 && index < len) {
            result = this.listStartTimeWav.get(index);
        }
        return result;
    }

    public int getEndTimeWavList(int index) {
        int result = -1;
        int len = this.getLengthWavList();
        if (len > 0 && index >= 0 && index < len) {
            result = this.listEndTimeWav.get(index);
        }
        return result;
    }

    public URI getFileNameWavList(int index) {
        URI result = null;
        int len = this.getLengthWavList();
        if (len > 0 && index >= 0 && index < len) {
            result = this.listFileNameWav.get(index);
        }
        return result;
    }

    public boolean getEnableWavList(int index) {
        boolean result = false;
        int len = this.getLengthWavList();
        if (len > 0 && index >= 0 && index < len) {
            result = this.listEnableWav.get(index);
        }
        return result;
    }

    public float getPlaySpeedWavList(int index) {
        float result = -1.0f;
        int len = this.getLengthWavList();
        if (len > 0 && index >= 0 && index < len) {
            result = this.listPlaySpeedWav.get(index).floatValue();
        }
        return result;
    }

    public void deleteIndexWavList(int index) {
        if (this.getStartTimeWavList(index) > 0) {
            this.listStartTimeWav.remove(index);
            this.listEndTimeWav.remove(index);
            this.listFileNameWav.remove(index);
            this.listEnableWav.remove(index);
            this.listPlaySpeedWav.remove(index);
        }
    }

    public void deleteStartTimeWavList(int startTime) {
        int index = this.getIndexWavList(startTime);
        if (index >= 0) {
            this.listStartTimeWav.remove(index);
            this.listEndTimeWav.remove(index);
            this.listFileNameWav.remove(index);
            this.listEnableWav.remove(index);
            this.listPlaySpeedWav.remove(index);
        }
    }

    public int appendDataWavList(int startTime, int endTime, URI strWavFileName, boolean statEnaWav, float competitiveRatioWav) {
        int index = -1;
        index = this.getIndexWavList(startTime);
        if (index >= 0) {
            this.listEndTimeWav.set(index, endTime);
            this.listFileNameWav.set(index, strWavFileName);
            this.listEnableWav.set(index, statEnaWav);
            this.listPlaySpeedWav.set(index, Float.valueOf(competitiveRatioWav));
        } else {
            index = this.searchInsertIndexWavList(startTime);
            if (index >= 0) {
                this.listStartTimeWav.add(index, startTime);
                this.listEndTimeWav.add(index, endTime);
                this.listFileNameWav.add(index, strWavFileName);
                this.listEnableWav.add(index, statEnaWav);
                this.listPlaySpeedWav.add(index, Float.valueOf(competitiveRatioWav));
            }
        }
        return index;
    }

    private class StructExtendData {
        private int StartTime;
        private Boolean Extended;
        private Boolean Gender;
        private int Speed;
        private int Pitch;
        private int Volume;
        private String Lang;

        public StructExtendData(int starttime, boolean extended, boolean gender, int speed, int pitch, int volume, String lang) {
            this.StartTime = starttime;
            this.Extended = extended;
            this.Gender = gender;
            this.Speed = speed;
            this.Pitch = pitch;
            this.Volume = volume;
            this.Lang = lang;
        }

        public int getStartTime() {
            return this.StartTime;
        }

        public Boolean getExtended() {
            return this.Extended;
        }

        public Boolean getGender() {
            return this.Gender;
        }

        public int getSpeed() {
            return this.Speed;
        }

        public int getPitch() {
            return this.Pitch;
        }

        public int getVolume() {
            return this.Volume;
        }

        public String getLang() {
            return this.Lang;
        }

        public void setStartTime(int starttime) {
            this.StartTime = starttime;
        }

        public void setExtended(Boolean extended) {
            this.Extended = extended;
        }

        public void setGender(Boolean gender) {
            this.Gender = gender;
        }

        public void setSpeed(int speed) {
            this.Speed = speed;
        }

        public void setPitch(int pitch) {
            this.Pitch = pitch;
        }

        public void setVolume(int volume) {
            this.Volume = volume;
        }

        public void setLang(String lang) {
            this.Lang = lang;
        }
    }

    private class StructScriptComment {
        private int startTime;
        private String comment;

        public StructScriptComment(int startTime, String comment) {
            this.startTime = startTime;
            this.comment = new String(comment);
        }

        public int getStartTime() {
            return this.startTime;
        }

        public String getScriptComment() {
            return this.comment;
        }

        public void setStartTime(int startTime) {
            this.startTime = startTime;
        }

        public void setScriptComment(String comment) {
            this.comment = comment;
        }
    }
}

