/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class RegistryUtil {
    private static final int REG_NONE = 0;
    private static final int REG_SZ = 1;
    private static final int REG_EXPAND_SZ = 2;
    private static final int REG_BINARY = 3;
    private static final int REG_DWORD = 4;
    private static final int REG_DWORD_BIG_ENDIAN = 5;
    private static final int REG_LINK = 6;
    private static final int REG_MULTI_SZ = 7;
    private static final int REG_RESOURCE_LIST = 8;
    private static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    private static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    private static final int REG_QWORD = 11;
    private static final int KEY_READ = 131097;
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;

    public static int getRegistryInt(int hKeyParent, String subKeyString, String valueString) {
        int hKey = RegistryUtil.open(hKeyParent, subKeyString, 0, 131097);
        if (hKey != 0) {
            try {
                int n = RegistryUtil.getIntegerValue(hKey, valueString);
                return n;
            }
            finally {
                RegistryUtil.close(hKey);
            }
        }
        return 0;
    }

    public static String getRegistryString(int hKeyParent, String subKeyString, String valueString) {
        int hKey = RegistryUtil.open(hKeyParent, subKeyString, 0, 131097);
        if (hKey != 0) {
            try {
                String string = RegistryUtil.getStringValue(hKey, valueString);
                return string;
            }
            finally {
                RegistryUtil.close(hKey);
            }
        }
        return null;
    }

    private static int open(int hKeyParent, String subKeyString, int ulOptions, int samDesired) {
        TCHAR keyName = new TCHAR(0, subKeyString, true);
        int[] phKey = new int[1];
        if (OS.RegOpenKeyEx((int)hKeyParent, (TCHAR)keyName, (int)ulOptions, (int)samDesired, (int[])phKey) == 0) {
            return phKey[0];
        }
        return 0;
    }

    private static int close(int hKey) {
        return OS.RegCloseKey((int)hKey);
    }

    private static int getIntegerValue(int hKey, String valueString) {
        TCHAR valueName = new TCHAR(0, valueString, true);
        int[] pType = new int[1];
        int[] pData = new int[1];
        int[] pcbData = new int[]{4};
        if (OS.RegQueryValueEx((int)hKey, (TCHAR)valueName, (int)0, (int[])pType, (int[])pData, (int[])pcbData) == 0 && 4 == pType[0]) {
            return pData[0];
        }
        return 0;
    }

    private static String getStringValue(int hKey, String valueString) {
        TCHAR buff;
        TCHAR valueName = new TCHAR(0, valueString, true);
        int[] pType = new int[1];
        int[] pcbData = new int[1];
        if (OS.RegQueryValueEx((int)hKey, (TCHAR)valueName, (int)0, (int[])pType, null, (int[])pcbData) == 0 && 1 == pType[0] && OS.RegQueryValueEx((int)hKey, (TCHAR)valueName, (int)0, (int[])pType, (TCHAR)(buff = new TCHAR(0, pcbData[0] / TCHAR.sizeof)), (int[])pcbData) == 0) {
            return buff.toString(0, buff.strlen());
        }
        return null;
    }
}

