/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import java.util.ArrayList;
import org.eclipse.actf.util.win32.OverlayWindow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class OverlayLabel
extends CLabel {
    public Object associatedObject;
    private Menu popupMenu;
    private static String ownerId = null;
    private static final String MENU_SEPARATOR = "\n----------------";

    private OverlayLabel(Composite parent, int style) {
        super(parent, style);
        this.setForeground(this.getDisplay().getSystemColor(28));
        this.setBackground(this.getDisplay().getSystemColor(29));
        this.setLayoutData(new GridData());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle rect = OverlayLabel.this.getClientArea();
                event.gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        });
    }

    public static void removeAll() {
        OverlayLabel.removeAll(true);
    }

    public static void removeAll(boolean force) {
        final Composite composite = OverlayLabel.getOverlayComposite(false);
        if (composite != null) {
            if (force) {
                OverlayLabel.removeChildren(composite);
            } else {
                composite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!composite.isDisposed() && composite.getDisplay().getActiveShell() == null) {
                            OverlayLabel.removeChildren(composite);
                        }
                    }
                });
            }
        }
    }

    private static void removeChildren(Composite composite) {
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof OverlayLabel) {
                controls[i].dispose();
            }
            ++i;
        }
    }

    public static OverlayLabel create(Object associatedObject) {
        Composite composite = OverlayLabel.getOverlayComposite(true);
        composite.moveAbove(null);
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof OverlayLabel && associatedObject.equals(((OverlayLabel)controls[i]).associatedObject)) {
                return null;
            }
            ++i;
        }
        OverlayLabel label = new OverlayLabel(composite, 0);
        label.associatedObject = associatedObject;
        return label;
    }

    public static OverlayLabel[] getLabelsAtPosition(Point position) {
        ArrayList<OverlayLabel> labelList = new ArrayList<OverlayLabel>();
        Composite composite = OverlayLabel.getOverlayComposite(false);
        if (composite != null) {
            Control[] controls = composite.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (controls[i] instanceof OverlayLabel && controls[i].getBounds().contains(position)) {
                    labelList.add((OverlayLabel)controls[i]);
                }
                ++i;
            }
        }
        return labelList.toArray(new OverlayLabel[labelList.size()]);
    }

    private static Composite getOverlayComposite(boolean create) {
        OverlayWindow window = OverlayWindow.getInstance(1, create);
        if (window != null) {
            return window.getComposite();
        }
        return null;
    }

    public Menu createPopupMenu() {
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        this.popupMenu = new Menu((Control)this);
        return this.popupMenu;
    }

    public void dispose() {
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        super.dispose();
    }

    public static String getOwnerId() {
        return ownerId;
    }

    public static void setOwnerId(String id) {
        ownerId = id;
    }

    public void setTooltop(String text, String[][] properties) {
        text = String.valueOf(text) + MENU_SEPARATOR;
        int i = 0;
        while (i < properties.length) {
            if (properties[i][1].length() > 0) {
                text = String.valueOf(text) + "\n" + properties[i][0] + ": " + properties[i][1];
            }
            ++i;
        }
        this.setToolTipText(text);
    }

    public String getMenuText() {
        String text = this.getToolTipText();
        int sep = text.indexOf(MENU_SEPARATOR);
        if (sep > 0) {
            text = text.substring(0, sep);
        }
        text = text.replaceAll("\n", " | ");
        return text;
    }
}

