/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.MemoryUtil;

public class NativeIntAccess {
    private int pIntAddress = 0;

    public NativeIntAccess() {
        this(1);
    }

    public NativeIntAccess(int size) {
        this.pIntAddress = MemoryUtil.GlobalAlloc(4 * size);
    }

    public void dispose() {
        MemoryUtil.GlobalFree(this.pIntAddress);
    }

    public int getAddress() {
        return this.getAddress(0);
    }

    public int getAddress(int index) {
        return this.pIntAddress + index * 4;
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int index) {
        int[] pInt = new int[1];
        MemoryUtil.MoveMemory(pInt, this.getAddress(index), 4);
        return pInt[0];
    }

    public void setInt(int value) {
        this.setInt(0, value);
    }

    public void setInt(int index, int value) {
        int[] pInt = new int[]{value};
        MemoryUtil.MoveMemory(this.getAddress(index), pInt, 4);
    }
}

