/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jxpath;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.eclipse.actf.util.jxpath.DOMExNodeIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMExNodePointer
extends DOMNodePointer {
    private static final long serialVersionUID = 7107226604740248209L;

    private Node getDOMNode() {
        return (Node)this.getImmediateNode();
    }

    public DOMExNodePointer(Node node, Locale locale) {
        super(node, locale);
    }

    public DOMExNodePointer(Node node, Locale locale, String id) {
        super(node, locale, id);
    }

    public DOMExNodePointer(NodePointer parent, Node node) {
        super(parent, node);
    }

    public DOMExNodePointer(DOMNodePointer ptOrg) {
        super(ptOrg.getParent(), (Node)ptOrg.getImmediateNode());
    }

    public boolean testNode(NodeTest test) {
        NodeNameTest nnt;
        String nsTest;
        if (test instanceof NodeTypeTest) {
            NodeTypeTest ntt = (NodeTypeTest)test;
            if (ntt.getNodeType() == 1) {
                return true;
            }
        } else if (test instanceof NodeNameTest && (nsTest = (nnt = (NodeNameTest)test).getNamespaceURI()) == null) {
            test = new NodeNameTest(nnt.getNodeName(), "");
        }
        return super.testNode(test);
    }

    public Pointer getPointerByID(JXPathContext context, String id) {
        Node node = this.getDOMNode();
        Document doc = node.getOwnerDocument();
        Element element = doc.getElementById(id);
        if (element == null) {
            return new NullPointer(this.getLocale(), id);
        }
        return new DOMExNodePointer(element, this.getLocale(), id);
    }

    public NodePointer getParent() {
        NodePointer pointer = this.getImmediateParentPointer();
        while (pointer != null && pointer.isContainer()) {
            pointer = pointer.getImmediateParentPointer();
        }
        return pointer;
    }

    public NodePointer getImmediateParentPointer() {
        if (this.parent != null) {
            return this.parent;
        }
        Node node = this.getDOMNode();
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            return null;
        }
        return new DOMExNodePointer(parentNode, this.getLocale());
    }

    public Object getRootNode() {
        Node node = this.getDOMNode();
        return node.getOwnerDocument();
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodeNameTest nnt;
        String nsTest;
        if (test instanceof NodeNameTest && (nsTest = (nnt = (NodeNameTest)test).getNamespaceURI()) == null) {
            test = new NodeNameTest(nnt.getNodeName(), "");
        }
        return new DOMExNodeIterator((NodePointer)this, test, reverse, startWith);
    }

    public String getNamespaceURI() {
        Node node = this.getDOMNode();
        String ns = node.getNamespaceURI();
        if (ns.length() == 0) {
            return null;
        }
        return ns;
    }
}

