/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.ui.actions;

import org.eclipse.actf.model.flash.proxy.FlashCacheUtil;
import org.eclipse.actf.model.flash.proxy.internal.WSTR;
import org.eclipse.actf.model.flash.proxy.internal.WinInet;
import org.eclipse.actf.model.internal.flash.proxy.Messages;
import org.eclipse.actf.ui.util.ProgressContribution;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteCacheAction
implements IWorkbenchWindowActionDelegate {
    private static final int BUFFER_SIZE = 32768;
    private IWorkbenchWindow window;
    private static final String NEVER_DELETE = "|gif|jpg|jpeg|png|bmp|ico|pdf|txt|text|doc|xls|ppt|htm|html|shtml|jsp|asp|php|hta|htc|ashx|xml|css|js|vb|vbs|vbx|au|avi|mp3|aif|aiff|asf|asx|wm|wmv|wma|mid|exe|cab|zip|flv|";
    private boolean background = false;
    private ProgressContribution pc;
    private IStatusLineManager manager;

    public DeleteCacheAction() {
        this(false);
    }

    public DeleteCacheAction(boolean background) {
        this.background = background;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        try {
            FlashCacheUtil.cacheChecked = true;
            if (this.background) {
                this.initProgress();
                new Thread(new Runnable(){

                    public void run() {
                        DeleteCacheAction.this.deleteCacheEntries();
                        DeleteCacheAction.this.endProgress();
                    }
                }).start();
            } else if (this.window != null) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.window.getShell());
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        int total = DeleteCacheAction.this.countCacheEntries();
                        monitor.beginTask(Messages.proxy_deleting_cache, total);
                        DeleteCacheAction.this.deleteCacheEntries(monitor, total);
                        monitor.done();
                    }
                });
            } else {
                this.deleteCacheEntries();
            }
        }
        catch (Exception exception) {}
    }

    private void initProgress() {
        try {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DeleteCacheAction.this.getProgressContribution();
                    if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                        DeleteCacheAction.this.pc.setVisible(true);
                        DeleteCacheAction.this.pc.setText(Messages.DeleteCacheAction_0);
                        DeleteCacheAction.this.manager.update(true);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getProgressContribution() {
        String id = "actf.progress";
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart part = window.getActivePage().getViewReferences()[0].getView(false);
        IViewSite viewSite = part.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        this.manager = actionBars.getStatusLineManager();
        this.pc = (ProgressContribution)this.manager.find(id);
    }

    private void endProgress() {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                        DeleteCacheAction.this.pc.setVisible(false);
                        DeleteCacheAction.this.manager.update(true);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    private int countCacheEntries() {
        int count = 1;
        int pCacheEntry = MemoryUtil.GlobalAlloc((int)32768);
        try {
            int[] pSize = new int[]{32768};
            MemoryUtil.MoveMemory((int)pCacheEntry, (int[])pSize, (int)4);
            int hEnum = WinInet.FindFirstUrlCacheEntryW(0, pCacheEntry, pSize);
            if (hEnum != 0) {
                do {
                    int[] pEntries = new int[20];
                    MemoryUtil.MoveMemory((int[])pEntries, (int)pCacheEntry, (int)(4 * pEntries.length));
                    if ((pEntries[3] & 0x300000) == 0) {
                        int pos;
                        String localFileName = new WSTR(pEntries[2]).getString();
                        boolean skip = false;
                        if (localFileName.indexOf(63) < 0 && -1 != (pos = localFileName.lastIndexOf(46))) {
                            String ext = localFileName.substring(pos + 1).toLowerCase();
                            boolean bl = skip = -1 != NEVER_DELETE.indexOf("|" + ext + "|");
                        }
                        if (!skip) {
                            ++count;
                        }
                    }
                    pSize[0] = 32768;
                } while (WinInet.FindNextUrlCacheEntryW(hEnum, pCacheEntry, pSize));
                WinInet.FindCloseUrlCache(hEnum);
            }
        }
        finally {
            MemoryUtil.GlobalFree((int)pCacheEntry);
        }
        return count;
    }

    private void deleteCacheEntries() {
        this.deleteCacheEntries(null, 0);
    }

    private void deleteCacheEntries(IProgressMonitor monitor, int total) {
        int count = 0;
        int pCacheEntry = MemoryUtil.GlobalAlloc((int)32768);
        try {
            int[] pSize = new int[]{32768};
            MemoryUtil.MoveMemory((int)pCacheEntry, (int[])pSize, (int)4);
            int hEnum = WinInet.FindFirstUrlCacheEntryW(0, pCacheEntry, pSize);
            if (hEnum != 0) {
                while (monitor == null || !monitor.isCanceled()) {
                    int[] pEntries = new int[20];
                    MemoryUtil.MoveMemory((int[])pEntries, (int)pCacheEntry, (int)(4 * pEntries.length));
                    if ((pEntries[3] & 0x300000) == 0) {
                        int pos;
                        String localFileName = new WSTR(pEntries[2]).getString();
                        boolean skip = false;
                        if (localFileName.indexOf(63) < 0 && -1 != (pos = localFileName.lastIndexOf(46))) {
                            String ext = localFileName.substring(pos + 1).toLowerCase();
                            boolean bl = skip = -1 != NEVER_DELETE.indexOf("|" + ext + "|");
                        }
                        if (!skip) {
                            WSTR wsSourceUrlName = new WSTR(pEntries[1]);
                            ++count;
                            if (monitor != null) {
                                monitor.subTask(wsSourceUrlName.getString());
                                monitor.worked(1);
                            }
                            WinInet.DeleteUrlCacheEntryW(wsSourceUrlName.getAddress());
                            if (this.background && total > 0) {
                                this.changeProgress(count * 100 / total);
                            }
                        }
                    }
                    pSize[0] = 32768;
                    if (!WinInet.FindNextUrlCacheEntryW(hEnum, pCacheEntry, pSize)) break;
                }
                WinInet.FindCloseUrlCache(hEnum);
            }
        }
        finally {
            MemoryUtil.GlobalFree((int)pCacheEntry);
        }
    }

    private void changeProgress(final int value) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (DeleteCacheAction.this.pc != null && DeleteCacheAction.this.manager != null) {
                    DeleteCacheAction.this.pc.setValue(value);
                    DeleteCacheAction.this.manager.update(true);
                }
            }
        });
    }
}

