/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.actf.model.internal.dom.sgml.util.IMutableTreeNodeFactory;
import org.eclipse.actf.model.internal.dom.sgml.util.MutableTreeNodeFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableTreeNodeImpl
implements MutableTreeNode {
    private Node domNode;
    private IMutableTreeNodeFactory factory;
    private static IMutableTreeNodeFactory sfactory;

    public Node getDomNode() {
        return this.domNode;
    }

    public static MutableTreeNodeImpl createNode(Node node) {
        if (sfactory == null) {
            sfactory = new MutableTreeNodeFactoryImpl();
        }
        return (MutableTreeNodeImpl)sfactory.createNode(node);
    }

    protected MutableTreeNodeImpl(Node node, IMutableTreeNodeFactory factory) {
        this.domNode = node;
        this.factory = factory;
    }

    public String toString() {
        return this.domNode.toString();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        Node ret = this.domNode.getFirstChild();
        while (childIndex > 0 && ret != null) {
            ret = ret.getNextSibling();
            --childIndex;
        }
        return ret != null ? this.factory.createNode(ret) : null;
    }

    @Override
    public int getChildCount() {
        int ret = 0;
        Node child = this.domNode.getFirstChild();
        while (child != null) {
            ++ret;
            child = child.getNextSibling();
        }
        return ret;
    }

    @Override
    public TreeNode getParent() {
        Node domParent = this.domNode.getParentNode();
        return domParent == null ? null : this.factory.createNode(domParent);
    }

    @Override
    public int getIndex(TreeNode node) {
        Node targetChild = ((MutableTreeNodeImpl)node).domNode;
        int ret = 0;
        Node child = this.domNode.getFirstChild();
        while (child != null) {
            if (child == targetChild) {
                return ret;
            }
            ++ret;
            child = child.getNextSibling();
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.domNode instanceof Element || this.domNode instanceof Document;
    }

    @Override
    public boolean isLeaf() {
        return !(this.domNode instanceof Element) && !this.domNode.hasChildNodes() && !(this.domNode instanceof Document);
    }

    public Enumeration<MutableTreeNode> children() {
        return new Enumeration<MutableTreeNode>(){
            private Node nextChild;
            {
                this.nextChild = MutableTreeNodeImpl.this.domNode.getFirstChild();
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextChild != null;
            }

            @Override
            public MutableTreeNode nextElement() {
                if (this.nextChild == null) {
                    throw new NoSuchElementException();
                }
                MutableTreeNode ret = MutableTreeNodeImpl.this.factory.createNode(this.nextChild);
                this.nextChild = this.nextChild.getNextSibling();
                return ret;
            }
        };
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        Node after = this.domNode.getFirstChild();
        while (after != null && index > 0) {
            after = after.getNextSibling();
            --index;
        }
        this.domNode.insertBefore(((MutableTreeNodeImpl)child).domNode, after);
    }

    @Override
    public void remove(int index) {
        Node child = this.domNode.getFirstChild();
        while (index > 0 && child != null) {
            child = child.getNextSibling();
            --index;
        }
        if (child != null) {
            this.domNode.removeChild(child);
        }
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.domNode.removeChild(((MutableTreeNodeImpl)node).domNode);
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof Node) {
            this.domNode = (Node)object;
        }
    }

    @Override
    public void removeFromParent() {
        this.domNode.getParentNode().removeChild(this.domNode);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
    }
}

