/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocumentFragment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGMLParentNode
extends SGMLNode {
    private static final long serialVersionUID = 3126509435625384557L;
    SGMLNode firstChild;
    SGMLNode lastChild;
    private static WeakHashMap<Document, HashMap<String, ArrayList<WeakReference<Node>>>> documentTagNameMap = new WeakHashMap();
    private static WeakHashMap<Document, HashMap<String, List<WeakReference<Element>>>> documentIdMap = new WeakHashMap();
    private static WeakHashMap<Document, HashMap<String, Long>> documentUpdatedMap = new WeakHashMap();

    SGMLParentNode(Document doc) {
        super(doc);
    }

    abstract void check(Node var1) throws DOMException;

    @Override
    public Node cloneNode(boolean deep) {
        SGMLParentNode ret = null;
        if (deep && this.firstChild != null) {
            ret = this.cloneNodeDeep();
            if (ret == null) {
                return null;
            }
        } else {
            try {
                ret = (SGMLParentNode)this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
            ret.firstChild = null;
            ret.lastChild = null;
        }
        ret.previousSibling = null;
        ret.nextSibling = null;
        ret.parent = null;
        return ret;
    }

    private SGMLParentNode cloneNodeDeep() {
        try {
            SGMLParentNode ret = (SGMLParentNode)this.clone();
            ret.lastChild = null;
            ret.firstChild = null;
            ret.parent = null;
            ret.nextSibling = null;
            ret.previousSibling = null;
            if (this.firstChild == null) {
                return ret;
            }
            SGMLNode child = ret.firstChild = (SGMLNode)this.firstChild.cloneNode(true);
            child.parent = ret;
            SGMLNode source = this.firstChild.nextSibling;
            while (source != null) {
                child.nextSibling = (SGMLNode)source.cloneNode(true);
                child.nextSibling.previousSibling = child;
                child = child.nextSibling;
                child.parent = ret;
                source = source.nextSibling;
            }
            ret.lastChild = child;
            return ret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeList(){

            public Node item(int index) {
                SGMLNode ret = SGMLParentNode.this.firstChild;
                while (index > 0 && ret != null) {
                    ret = ret.nextSibling;
                    --index;
                }
                return index == 0 ? ret : null;
            }

            public int getLength() {
                int ret = 0;
                SGMLNode child = SGMLParentNode.this.firstChild;
                while (child != null) {
                    ++ret;
                    child = child.nextSibling;
                }
                return ret;
            }
        };
    }

    @Override
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.lastChild;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        if (node instanceof SGMLDocumentFragment && node.getOwnerDocument() == this.getOwnerDocument()) {
            SGMLDocumentFragment fragment = (SGMLDocumentFragment)node;
            SGMLNode child = fragment.firstChild;
            while (child != null) {
                child.parent = this;
                child = child.nextSibling;
            }
            if (this.firstChild == null) {
                this.firstChild = fragment.firstChild;
                this.lastChild = fragment.lastChild;
            } else {
                this.lastChild.nextSibling = fragment.firstChild;
                fragment.firstChild.previousSibling = this.lastChild;
                this.lastChild = fragment.lastChild;
            }
            return node;
        }
        this.check(node);
        SGMLNode sgmlNode = (SGMLNode)node;
        if (sgmlNode.parent != null) {
            sgmlNode.parent.removeChild(sgmlNode);
        }
        sgmlNode.parent = this;
        if (this.firstChild == null) {
            this.firstChild = this.lastChild = sgmlNode;
            if (node instanceof Element) {
                this.processNodeForOptimization((Element)node);
            }
            return node;
        }
        this.lastChild.nextSibling = sgmlNode;
        sgmlNode.previousSibling = this.lastChild;
        this.lastChild = sgmlNode;
        if (node instanceof Element) {
            this.processNodeForOptimization((Element)node);
        }
        return node;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        SGMLNode sgmlRefChild = (SGMLNode)refChild;
        if (sgmlRefChild.parent != this) {
            throw new DOMException(8, "There isn't " + refChild + " as a children"){
                private static final long serialVersionUID = -401620698015402759L;
            };
        }
        if (newChild instanceof SGMLDocumentFragment && newChild.getOwnerDocument() == this.getOwnerDocument()) {
            SGMLDocumentFragment fragment = (SGMLDocumentFragment)newChild;
            SGMLNode child = fragment.firstChild;
            while (child != null) {
                child.parent = this;
                child = child.nextSibling;
            }
            if (this.firstChild == refChild) {
                this.firstChild.previousSibling = fragment.lastChild;
                fragment.lastChild.nextSibling = this.firstChild;
                this.firstChild = fragment.firstChild;
            } else {
                fragment.firstChild.previousSibling = sgmlRefChild.previousSibling;
                fragment.lastChild.nextSibling = sgmlRefChild;
                sgmlRefChild.previousSibling.nextSibling = fragment.firstChild;
                sgmlRefChild.previousSibling = fragment.lastChild;
            }
            return newChild;
        }
        this.check(newChild);
        SGMLNode sgmlNewChild = (SGMLNode)newChild;
        if (sgmlNewChild.parent != null) {
            sgmlNewChild.parent.removeChild(sgmlNewChild);
        }
        if (this.firstChild == refChild) {
            this.firstChild.previousSibling = sgmlNewChild;
            sgmlNewChild.nextSibling = this.firstChild;
            sgmlNewChild.parent = this;
            this.firstChild = sgmlNewChild;
        } else {
            sgmlNewChild.previousSibling = sgmlRefChild.previousSibling;
            sgmlNewChild.nextSibling = sgmlRefChild;
            sgmlRefChild.previousSibling.nextSibling = sgmlNewChild;
            sgmlRefChild.previousSibling = sgmlNewChild;
            sgmlNewChild.parent = this;
        }
        if (newChild instanceof Element) {
            this.processNodeForOptimization((Element)newChild);
        }
        return newChild;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        SGMLNode sgmlOldChild;
        block11: {
            block10: {
                if (this.firstChild == null || !(oldChild instanceof SGMLNode)) break block10;
                sgmlOldChild = (SGMLNode)oldChild;
                if (sgmlOldChild.parent == this) break block11;
            }
            throw new DOMException(8, "There isn't " + oldChild + " as a children"){
                private static final long serialVersionUID = -4190622701270985282L;
            };
        }
        if (this.firstChild == oldChild) {
            if (this.firstChild == this.lastChild) {
                this.lastChild = null;
                this.firstChild = null;
            } else {
                this.firstChild = sgmlOldChild.nextSibling;
                this.firstChild.previousSibling = null;
            }
        } else if (this.lastChild == oldChild) {
            this.lastChild = sgmlOldChild.previousSibling;
            this.lastChild.nextSibling = null;
        } else {
            sgmlOldChild.nextSibling.previousSibling = sgmlOldChild.previousSibling;
            sgmlOldChild.previousSibling.nextSibling = sgmlOldChild.nextSibling;
        }
        sgmlOldChild.nextSibling = null;
        sgmlOldChild.previousSibling = null;
        sgmlOldChild.parent = null;
        if (oldChild instanceof Element) {
            this.processNodeForOptimization((Element)oldChild);
        }
        return oldChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.check(newChild);
        SGMLNode sgmlNewChild = (SGMLNode)newChild;
        SGMLNode sgmlOldChild = (SGMLNode)oldChild;
        if (sgmlOldChild.parent != this) {
            throw new DOMException(8, this + "doesn't have " + newChild + " as a child"){
                private static final long serialVersionUID = 164773639627266417L;
            };
        }
        if (this.firstChild == oldChild) {
            if (this.firstChild != this.lastChild) {
                sgmlNewChild.nextSibling = this.firstChild.nextSibling;
                this.firstChild.nextSibling.previousSibling = sgmlNewChild;
            } else {
                this.lastChild = sgmlNewChild;
            }
            this.firstChild = sgmlNewChild;
            sgmlOldChild.nextSibling = null;
            sgmlOldChild.previousSibling = null;
            sgmlOldChild.parent = null;
            sgmlNewChild.parent = this;
        } else if (this.lastChild == oldChild) {
            this.lastChild.previousSibling.nextSibling = sgmlNewChild;
            sgmlNewChild.previousSibling = this.lastChild.previousSibling;
            this.lastChild = sgmlNewChild;
            sgmlOldChild.previousSibling = null;
            sgmlOldChild.parent = null;
            sgmlNewChild.parent = this;
        } else {
            sgmlNewChild.previousSibling = sgmlOldChild.previousSibling;
            sgmlNewChild.nextSibling = sgmlOldChild.nextSibling;
            sgmlOldChild.previousSibling.nextSibling = sgmlNewChild;
            sgmlOldChild.nextSibling.previousSibling = sgmlNewChild;
            sgmlOldChild.nextSibling = null;
            sgmlOldChild.previousSibling = null;
            sgmlOldChild.parent = null;
            sgmlNewChild.parent = this;
        }
        if (sgmlOldChild instanceof Element) {
            this.processNodeForOptimization((Element)((Object)sgmlOldChild));
        }
        if (sgmlNewChild instanceof Element) {
            this.processNodeForOptimization((Element)((Object)sgmlNewChild));
        }
        return newChild;
    }

    @Override
    public void normalize() {
        SGMLNode n = this.firstChild;
        while (n != null) {
            if (n.getNodeType() == 3) {
                if (n.nextSibling != null && n.nextSibling.getNodeType() == 3) {
                    ((Text)((Object)n)).appendData(((Text)((Object)n.nextSibling)).getData());
                    this.removeChild(n.nextSibling);
                    continue;
                }
                n = n.nextSibling;
                continue;
            }
            n.normalize();
            n = n.nextSibling;
        }
    }

    protected void processNodeForOptimization(Element element) {
        if (element.getParentNode() == null) {
            this.removeNodeForOptimization(element);
        } else {
            this.addNodeForOptimization(element);
        }
    }

    private void removeNodeForOptimization(Element element) {
        String name;
        List<WeakReference<Element>> list;
        String id = element.getAttribute("id");
        HashMap<String, List<WeakReference<Element>>> idMap = SGMLParentNode.getIdMap(this.ownerDocument);
        if (id != null && (list = idMap.get(id)) != null) {
            Iterator<WeakReference<Element>> i = list.iterator();
            while (i.hasNext()) {
                if (i.next().get() != element) continue;
                i.remove();
            }
        }
        if ((name = element.getNodeName().toLowerCase()) != null) {
            ArrayList<WeakReference<Node>> nodeList = SGMLParentNode.getNodeList(this.ownerDocument, name);
            int index = nodeList.size() - 1;
            while (index >= 0) {
                if (nodeList.get(index).get() == element) break;
                --index;
            }
            if (index != -1) {
                nodeList.remove(index);
            }
        }
        SGMLParentNode.updateNodeList(this.ownerDocument, name);
        Node f = element.getFirstChild();
        while (f != null) {
            if (f instanceof Element) {
                this.removeNodeForOptimization((Element)f);
            }
            f = f.getNextSibling();
        }
    }

    private void addNodeForOptimization(Element element) {
        this.processIdForOptimization(element);
        String name = element.getNodeName().toLowerCase();
        if (name != null) {
            ArrayList<WeakReference<Node>> nodeList = SGMLParentNode.getNodeList(this.ownerDocument, name);
            if (nodeList.size() == 0) {
                nodeList.add(new WeakReference<Element>(element));
            } else {
                Node node = this.findPreviousNodeByTagName(element, name);
                int index1 = nodeList.size() - 1;
                if (node != null) {
                    while (index1 >= 0) {
                        if (nodeList.get(index1).get() == node) break;
                        --index1;
                    }
                }
                int index2 = nodeList.size() - 1;
                while (index2 >= 0) {
                    if (nodeList.get(index2).get() == element) break;
                    --index2;
                }
                if (index2 != -1) {
                    if (index1 + 1 != index2) {
                        nodeList.remove(index2);
                        if (index1 + 1 < nodeList.size()) {
                            nodeList.add(index1 + 1, new WeakReference<Element>(element));
                        } else {
                            nodeList.add(new WeakReference<Element>(element));
                        }
                    }
                } else {
                    nodeList.add(index1 + 1, new WeakReference<Element>(element));
                }
            }
        }
        SGMLParentNode.updateNodeList(this.ownerDocument, name);
        Node f = element.getFirstChild();
        while (f != null) {
            if (f instanceof Element) {
                this.addNodeForOptimization((Element)f);
            }
            f = f.getNextSibling();
        }
    }

    protected void processIdForOptimization(Element element) {
        String id = element.getAttribute("id");
        HashMap<String, List<WeakReference<Element>>> idMap = SGMLParentNode.getIdMap(this.ownerDocument);
        for (String key : idMap.keySet()) {
            List<WeakReference<Element>> list = idMap.get(key);
            if (list == null) continue;
            Iterator<WeakReference<Element>> i = list.iterator();
            while (i.hasNext()) {
                if (i.next().get() != element) continue;
                i.remove();
            }
        }
        if (id != null && id.length() > 0) {
            List<WeakReference<Element>> list = idMap.get(id);
            if (list == null) {
                list = new ArrayList<WeakReference<Element>>();
                idMap.put(id, list);
            }
            boolean flag = true;
            Iterator<WeakReference<Element>> i = list.iterator();
            while (i.hasNext()) {
                if (i.next().get() != element) continue;
                flag = false;
            }
            if (flag) {
                list.add(new WeakReference<Element>(element));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Node findPreviousNodeByTagName(Node element, String name) {
        block2: {
            do {
                block3: {
                    prev = element.getPreviousSibling();
                    p = element.getParentNode();
                    if (prev != null) ** GOTO lbl8
                    element = p != null ? p : null;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        prev = prev.getLastChild();
lbl8:
                        // 2 sources

                        ** while (prev.getLastChild() != null)
                    }
lbl9:
                    // 1 sources

                    element = prev;
                }
                if (element == null) break block2;
            } while (!element.getNodeName().toLowerCase().equals(name));
            return element;
        }
        return null;
    }

    protected static ArrayList<WeakReference<Node>> getNodeList(Document doc, String name) {
        ArrayList<WeakReference<Node>> nodeList;
        HashMap<String, ArrayList<WeakReference<Node>>> tagNameMap = documentTagNameMap.get(doc);
        if (tagNameMap == null) {
            tagNameMap = new HashMap();
            documentTagNameMap.put(doc, tagNameMap);
        }
        if ((nodeList = tagNameMap.get(name)) == null) {
            nodeList = new ArrayList();
            tagNameMap.put(name, nodeList);
        }
        return nodeList;
    }

    protected static HashMap<String, List<WeakReference<Element>>> getIdMap(Document doc) {
        HashMap<String, List<WeakReference<Element>>> idMap = documentIdMap.get(doc);
        if (idMap == null) {
            idMap = new HashMap();
            documentIdMap.put(doc, idMap);
        }
        return idMap;
    }

    private static HashMap<String, Long> getUpdatedMap(Document doc, String name) {
        HashMap<String, Long> updatedMap = documentUpdatedMap.get(doc);
        if (updatedMap == null) {
            updatedMap = new HashMap();
            documentUpdatedMap.put(doc, updatedMap);
        }
        return updatedMap;
    }

    protected static long getNodeListUpdatedAt(Document doc, String name) {
        HashMap<String, Long> updatedMap = SGMLParentNode.getUpdatedMap(doc, name);
        Long l = updatedMap.get(name);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected static void updateNodeList(Document doc, String name) {
        HashMap<String, Long> updatedMap = SGMLParentNode.getUpdatedMap(doc, name);
        Long n = updatedMap.get(name);
        if (n == null) {
            n = 0L;
        }
        n = n + 1L;
        updatedMap.put(name, n);
    }
}

