/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.actf.model.internal.dom.sgml.IPrintXML;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLElement;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLAttribute;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParentNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SGMLElement
extends SGMLParentNode
implements ISGMLElement {
    private static final long serialVersionUID = -8088815760723728378L;
    private String tagName;
    private SGMLAttribute[] attributes = new SGMLAttribute[8];
    private int attrNum = 0;

    public SGMLElement(String name, Document doc) {
        super(doc);
        this.tagName = name;
    }

    void check(Node node) throws DOMException {
        if (node == null) {
            throw new DOMException(3, "trying to insert null"){
                private static final long serialVersionUID = -3195872655825042328L;
            };
        }
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMException(4, node + " created from " + node.getOwnerDocument() + ". " + this + " created from " + this.ownerDocument){
                private static final long serialVersionUID = -3952917378943559036L;
            };
        }
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new DOMException(3, node + " is not allowed as a child of " + this){
                    private static final long serialVersionUID = 2793178675397177186L;
                };
            }
        }
    }

    public String getAttribute(String name) {
        int i = this.attrNum - 1;
        while (i >= 0) {
            SGMLAttribute attr = this.attributes[i];
            if (attr.getNodeName().equalsIgnoreCase(name)) {
                return attr.getNodeValue();
            }
            --i;
        }
        if (this.getDefaultValue(name) != null) {
            return this.getDefaultValue(name);
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        int i = this.attrNum - 1;
        while (i >= 0) {
            SGMLAttribute ret = this.attributes[i];
            if (ret.getNodeName().equalsIgnoreCase(name)) {
                return ret;
            }
            --i;
        }
        return null;
    }

    private void expandAttrBuf() {
        SGMLAttribute[] newBuf = new SGMLAttribute[this.attrNum * 2];
        System.arraycopy(this.attributes, 0, newBuf, 0, this.attrNum);
        this.attributes = newBuf;
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMap(){

            public String toString() {
                StringBuffer ret = new StringBuffer(91);
                int i = 0;
                while (i < SGMLElement.this.attrNum - 1) {
                    ret.append(SGMLElement.this.attributes[i] + ", ");
                    ++i;
                }
                if (SGMLElement.this.attrNum > 0) {
                    ret.append(SGMLElement.this.attributes[SGMLElement.this.attrNum - 1]);
                }
                ret.append(']');
                return ret.toString();
            }

            public Node getNamedItem(String name) {
                return SGMLElement.this.getAttributeNode(name);
            }

            public Node getNamedItemNS(String namespaceURI, String localName) {
                return this.getNamedItem(localName);
            }

            public Node setNamedItem(Node arg) throws DOMException {
                if (arg instanceof SGMLAttribute) {
                    int i = SGMLElement.this.attrNum - 1;
                    while (i >= 0) {
                        SGMLAttribute ret = SGMLElement.this.attributes[i];
                        if (ret.getNodeName().equalsIgnoreCase(arg.getNodeName())) {
                            ((SGMLElement)SGMLElement.this).attributes[i] = (SGMLAttribute)arg;
                            SGMLElement.this.attributes[i].setOwnerElement(SGMLElement.this);
                            return ret;
                        }
                        --i;
                    }
                    if (SGMLElement.this.attrNum == SGMLElement.this.attributes.length) {
                        SGMLElement.this.expandAttrBuf();
                    }
                    SGMLAttribute[] sGMLAttributeArray = SGMLElement.this.attributes;
                    SGMLElement sGMLElement = SGMLElement.this;
                    int n = sGMLElement.attrNum;
                    sGMLElement.attrNum = n + 1;
                    sGMLAttributeArray[n] = (SGMLAttribute)arg;
                    ((SGMLAttribute)arg).setOwnerElement(SGMLElement.this);
                    return null;
                }
                throw new DOMException(7, "only Attr instance can be set: " + arg){
                    private static final long serialVersionUID = -8500293705674064623L;
                };
            }

            public Node setNamedItemNS(Node arg) throws DOMException {
                return this.setNamedItem(arg);
            }

            public Node removeNamedItem(String name) throws DOMException {
                int i = SGMLElement.this.attrNum - 1;
                while (i >= 0) {
                    SGMLAttribute attr = SGMLElement.this.attributes[i];
                    if (attr.getNodeName().equalsIgnoreCase(name)) {
                        ((SGMLElement)SGMLElement.this).attributes[i] = null;
                        attr.setOwnerElement(null);
                        ++i;
                        while (i < SGMLElement.this.attrNum) {
                            ((SGMLElement)SGMLElement.this).attributes[i - 1] = SGMLElement.this.attributes[i];
                            ++i;
                        }
                        SGMLElement sGMLElement = SGMLElement.this;
                        sGMLElement.attrNum = sGMLElement.attrNum - 1;
                        return attr;
                    }
                    --i;
                }
                return null;
            }

            public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
                return this.removeNamedItem(localName);
            }

            public Node item(int index) {
                if (index >= 0 && index < SGMLElement.this.attrNum) {
                    return SGMLElement.this.attributes[index];
                }
                return null;
            }

            public int getLength() {
                return SGMLElement.this.attrNum;
            }
        };
    }

    public NodeList getElementsByTagName(String name) {
        class MyNodeList
        implements NodeList {
            private String name;
            private ArrayList<WeakReference<Node>> list;
            private int s;
            private int e;
            private long lastupdated;

            MyNodeList(String name) {
                this.name = name;
                this.list = SGMLElement.getNodeList(SGMLElement.this.ownerDocument, name);
                this.init();
            }

            private void init() {
                this.s = 0;
                Node start = SGMLElement.this.findPreviousNodeByTagName(SGMLElement.this, this.name);
                if (start != null) {
                    while (this.s < this.list.size()) {
                        if (this.list.get(this.s).get() == start) {
                            ++this.s;
                            break;
                        }
                        ++this.s;
                    }
                }
                if (this.s < this.list.size() && this.list.get(this.s).get() == SGMLElement.this) {
                    ++this.s;
                }
                this.e = this.list.size();
                Node next = SGMLElement.this.getNextSibling();
                Node p = SGMLElement.this.getParentNode();
                while (p != null && next == null) {
                    next = p.getNextSibling();
                    if (next != null) continue;
                    p = p.getParentNode();
                }
                if (next != null) {
                    Node end = SGMLElement.this.findPreviousNodeByTagName(next, this.name);
                    if (end != null) {
                        --this.e;
                        while (this.e >= 0) {
                            if (this.list.get(this.e).get() == end) {
                                ++this.e;
                                break;
                            }
                            --this.e;
                        }
                    } else {
                        this.e = 0;
                    }
                }
                this.lastupdated = SGMLElement.getNodeListUpdatedAt(SGMLElement.this.ownerDocument, this.name);
            }

            public int getLength() {
                if (this.lastupdated != SGMLElement.getNodeListUpdatedAt(SGMLElement.this.ownerDocument, this.name)) {
                    this.init();
                }
                return this.e - this.s;
            }

            public Node item(int index) {
                if (this.getLength() <= index) {
                    return null;
                }
                return (Node)this.list.get(this.s + index).get();
            }
        }
        return new MyNodeList(name);
    }

    public String getNodeName() {
        return this.tagName;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void removeAttribute(String name) throws DOMException {
        int i = this.attrNum - 1;
        while (i >= 0) {
            SGMLAttribute attr = this.attributes[i];
            if (attr.getNodeName().equalsIgnoreCase(name)) {
                String defaultValue = this.getDefaultValue(name);
                if (defaultValue != null) {
                    attr.setNodeValue(defaultValue);
                } else {
                    this.attributes[i] = null;
                    attr.setOwnerElement(null);
                    ++i;
                    while (i < this.attrNum) {
                        this.attributes[i - 1] = this.attributes[i];
                        ++i;
                    }
                    --this.attrNum;
                }
                this.processIdForOptimization(this);
                return;
            }
            --i;
        }
    }

    private String getDefaultValue(String attrName) {
        SGMLDocTypeDef dtd = ((SGMLDocument)this.ownerDocument).getDTD();
        if (dtd == null) {
            return null;
        }
        ElementDefinition edef = dtd.getElementDefinition(this.tagName);
        if (edef == null) {
            return null;
        }
        AttributeDefinition adef = edef.getAttributeDef(attrName);
        return adef != null ? adef.getDefaultValue() : null;
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        int i = this.attrNum - 1;
        while (i >= 0) {
            if (this.attributes[i] == oldAttr) {
                String defaultValue = this.getDefaultValue(oldAttr.getNodeName());
                if (defaultValue != null) {
                    SGMLAttribute attr = (SGMLAttribute)this.ownerDocument.createAttribute(oldAttr.getNodeName());
                    attr.setValue(defaultValue);
                    this.attributes[i] = attr;
                    attr.setOwnerElement(this);
                    break;
                }
                this.attributes[i] = null;
                ++i;
                while (i < this.attrNum) {
                    this.attributes[i - 1] = this.attributes[i];
                    ++i;
                }
                --this.attrNum;
                break;
            }
            --i;
        }
        ((SGMLAttribute)oldAttr).setOwnerElement(this);
        this.processIdForOptimization(this);
        return oldAttr;
    }

    public void setAttribute(String name, String value) throws DOMException {
        SGMLAttribute attr;
        int i = this.attrNum - 1;
        while (i >= 0) {
            attr = this.attributes[i];
            if (attr.getName().equalsIgnoreCase(name)) {
                attr.setValue(value);
                this.processIdForOptimization(this);
                return;
            }
            --i;
        }
        attr = (SGMLAttribute)this.ownerDocument.createAttribute(name);
        attr.setValue(value);
        attr.setOwnerElement(this);
        if (this.attributes.length == this.attrNum) {
            this.expandAttrBuf();
        }
        this.attributes[this.attrNum++] = attr;
        this.processIdForOptimization(this);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (!(newAttr instanceof SGMLAttribute)) {
            throw new DOMException(4, newAttr + "is not SGMLAttribute"){
                private static final long serialVersionUID = -2574702797917329018L;
            };
        }
        int i = this.attrNum - 1;
        while (i >= 0) {
            SGMLAttribute attr = this.attributes[i];
            if (attr.getName().equalsIgnoreCase(newAttr.getName())) {
                attr.setOwnerElement(null);
                this.attributes[i] = (SGMLAttribute)newAttr;
                this.attributes[i].setOwnerElement(this);
                this.processIdForOptimization(this);
                return attr;
            }
            --i;
        }
        if (this.attributes.length == this.attrNum) {
            this.expandAttrBuf();
        }
        this.attributes[this.attrNum] = (SGMLAttribute)newAttr;
        this.attributes[this.attrNum++].setOwnerElement(this);
        this.processIdForOptimization(this);
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(7, "can't set value in " + this){
            private static final long serialVersionUID = 159616090913212538L;
        };
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append('<');
        ret.append(this.tagName);
        int i = 0;
        while (i < this.attrNum) {
            ret.append(this.attributes[i].toString());
            ++i;
        }
        ret.append('>');
        return new String(ret);
    }

    public void printAsXML(PrintWriter pw, int indentLevel, boolean indent) {
        int i;
        if (indent && (this.previousSibling == null || this.previousSibling.getNodeType() != 3 && this.previousSibling.getNodeType() != 4)) {
            i = 0;
            while (i < indentLevel) {
                pw.print(' ');
                ++i;
            }
        }
        pw.print(String.valueOf('<') + this.getTagName());
        i = 0;
        while (i < this.attrNum) {
            pw.print(this.attributes[i].toXMLString());
            ++i;
        }
        if (this.hasChildNodes()) {
            pw.print('>');
            Node child = this.getFirstChild();
            while (child != null) {
                if (indent && child.getNodeType() != 3 && child.getNodeType() != 4) {
                    pw.println();
                }
                ((IPrintXML)((Object)child)).printAsXML(pw, indentLevel + 1, indent);
                child = child.getNextSibling();
            }
            if (indent && (this.getLastChild() == null || this.getLastChild().getNodeType() != 3 && this.getLastChild().getNodeType() != 4)) {
                pw.println();
                i = indentLevel;
                while (i > 0) {
                    pw.print(' ');
                    --i;
                }
            }
            pw.print("</" + this.getTagName() + '>');
        } else {
            pw.print("/>");
        }
    }

    public void printAsSGML(PrintWriter pw, int indentLevel, boolean indent) {
        if (indent && (this.previousSibling == null || this.previousSibling.getNodeType() != 3 && this.previousSibling.getNodeType() != 4)) {
            int i = indentLevel;
            while (i > 0) {
                pw.print(' ');
                --i;
            }
        }
        pw.print(this.toString());
        boolean parent = this.hasChildNodes();
        if (parent) {
            Node child = this.getFirstChild();
            while (child != null) {
                if (indent && child.getNodeType() != 3 && child.getNodeType() != 4) {
                    pw.println();
                }
                ((IPrintXML)((Object)child)).printAsSGML(pw, indentLevel + 1, indent);
                child = child.getNextSibling();
            }
        }
        SGMLDocTypeDef dtd = ((SGMLDocument)this.getOwnerDocument()).getDTD();
        ElementDefinition ed = null;
        if (dtd != null) {
            ed = dtd.getElementDefinition(this.tagName);
        }
        if (parent || ed == null || ed.getContentModel() != SGMLParser.empty) {
            if (indent && (this.getLastChild() == null || this.getLastChild().getNodeType() != 3 && this.getLastChild().getNodeType() != 4)) {
                pw.println();
                int i = indentLevel;
                while (i > 0) {
                    pw.print(' ');
                    --i;
                }
            }
            pw.print("</" + this.getTagName() + '>');
        }
    }

    public Node cloneNode(boolean deep) {
        SGMLElement ret = (SGMLElement)super.cloneNode(deep);
        SGMLAttribute[] cloneAttributes = new SGMLAttribute[this.attributes.length];
        int i = this.attrNum - 1;
        while (i >= 0) {
            cloneAttributes[i] = (SGMLAttribute)this.attributes[i].cloneNode(false);
            cloneAttributes[i].setOwnerElement(ret);
            --i;
        }
        ret.attributes = cloneAttributes;
        return ret;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.setAttribute(qualifiedName, value);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.removeAttribute(localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    public boolean hasAttribute(String name) {
        int i = this.attrNum - 1;
        while (i >= 0) {
            SGMLAttribute attr = this.attributes[i];
            if (attr.getNodeName().equalsIgnoreCase(name)) {
                return true;
            }
            --i;
        }
        return this.getDefaultValue(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    public boolean hasAttributes() {
        return this.attrNum > 0;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.processIdForOptimization(this);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.processIdForOptimization(this);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.processIdForOptimization(this);
    }
}

