/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.impl;

import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.impl.SHElement;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class SHTableSectionElement
extends SHElement
implements HTMLTableSectionElement {
    private static final long serialVersionUID = 6890717929157559373L;

    protected SHTableSectionElement(String name, SHDocument doc) {
        super(name, doc);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getCh() {
        return this.getAttribute("char");
    }

    public void setCh(String ch) {
        this.setAttribute("char", ch);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public String getVAlign() {
        return this.getAttribute("valign");
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    public HTMLCollection getRows() {
        int len = 0;
        Node[] rows = new HTMLTableRowElement[8];
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableRowElement) {
                if (rows.length == len) {
                    HTMLTableRowElement[] buf = new HTMLTableRowElement[len * 2];
                    System.arraycopy(rows, 0, buf, 0, len);
                    rows = buf;
                }
                rows[len++] = (HTMLTableRowElement)child;
            }
            child = child.getNextSibling();
        }
        return ((SHDocument)this.getOwnerDocument()).createCollection(rows, len);
    }

    public HTMLElement insertRow(int index) {
        if (index < 0) {
            return null;
        }
        int i = 0;
        Node after = this.getFirstChild();
        while (after != null) {
            if (i == index) {
                HTMLElement ret = (HTMLElement)this.getOwnerDocument().createElement("TR");
                this.insertBefore(ret, after);
                return ret;
            }
            ++i;
            after = after.getNextSibling();
        }
        if (i == 0) {
            HTMLElement ret = (HTMLElement)this.getOwnerDocument().createElement("TR");
            this.insertBefore(ret, null);
            return ret;
        }
        return null;
    }

    public void deleteRow(int index) {
        if (index < 0) {
            return;
        }
        int i = 0;
        Node child = this.getFirstChild();
        while (child != null) {
            if (i == index) {
                this.removeChild(child);
                return;
            }
            ++i;
            child = child.getNextSibling();
        }
    }
}

