/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.editor.browser;

import java.util.ArrayList;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTFEventListener;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class WebBrowserEventUtil {
    private static final String TAG_LISTENER = "listener";
    private static final String ATTR_CLASS = "class";
    private static WebBrowserEventUtil[] cachedExtensions;
    private final IConfigurationElement configElement;
    private IWebBrowserACTFEventListener listener;

    private static WebBrowserEventUtil[] getExtensions() {
        if (cachedExtensions != null) {
            return cachedExtensions;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.model.ui", "webBrowserEventListener").getExtensions();
        ArrayList<WebBrowserEventUtil> l = new ArrayList<WebBrowserEventUtil>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                WebBrowserEventUtil ex = WebBrowserEventUtil.parseExtension(configElements[j], l.size());
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        cachedExtensions = l.toArray(new WebBrowserEventUtil[l.size()]);
        return cachedExtensions;
    }

    private static WebBrowserEventUtil parseExtension(IConfigurationElement configElement, int idx) {
        if (!configElement.getName().equals(TAG_LISTENER)) {
            return null;
        }
        try {
            return new WebBrowserEventUtil(configElement, idx);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void disposeExtensions() {
        if (cachedExtensions == null) {
            return;
        }
        int i = 0;
        while (i < cachedExtensions.length) {
            cachedExtensions[i].dispose();
            ++i;
        }
        cachedExtensions = null;
    }

    public static void navigateComplete(IWebBrowserACTF iWebBrowser, String url) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().navigateComplete(iWebBrowser, url);
            ++i;
        }
    }

    public static void titleChange(IWebBrowserACTF iWebBrowser, String title) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().titleChange(iWebBrowser, title);
            ++i;
        }
    }

    public static void progressChange(IWebBrowserACTF iWebBrowser, int progress, int progressMax) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().progressChange(iWebBrowser, progress, progressMax);
            ++i;
        }
    }

    public static void rootDocumentComplete(IWebBrowserACTF iWebBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().rootDocumentComplete(iWebBrowser);
            ++i;
        }
    }

    public static void getFocus(IWebBrowserACTF iWebBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().getFocus(iWebBrowser);
            ++i;
        }
    }

    public static void browserDisposed(IWebBrowserACTF iWebBrowser, String title) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().browserDisposed(iWebBrowser, title);
            ++i;
        }
    }

    public static void beforeNavigate(IWebBrowserACTF iWebBrowser, String url, String targetFrameName, boolean isInNavigation) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().beforeNavigate(iWebBrowser, url, targetFrameName, isInNavigation);
            ++i;
        }
    }

    public static void refreshStart(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().refreshStart(webBrowser);
            ++i;
        }
    }

    public static void refreshComplete(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().refreshComplete(webBrowser);
            ++i;
        }
    }

    public static void navigateStop(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().navigateStop(webBrowser);
            ++i;
        }
    }

    public static void focusGainedOfAddressText(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().focusGainedOfAddressText(webBrowser);
            ++i;
        }
    }

    public static void focusLostOfAddressText(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().focusLostOfAddressText(webBrowser);
            ++i;
        }
    }

    public static void newWindow(IWebBrowserACTF webBrowser) {
        WebBrowserEventUtil[] exs = WebBrowserEventUtil.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getListener().newWindow(webBrowser);
            ++i;
        }
    }

    private WebBrowserEventUtil(IConfigurationElement configElement, int idx) {
        this.configElement = configElement;
    }

    private IWebBrowserACTFEventListener getListener() {
        if (this.listener != null) {
            return this.listener;
        }
        try {
            this.listener = (IWebBrowserACTFEventListener)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {}
        return this.listener;
    }

    private void dispose() {
        if (this.listener == null) {
            return;
        }
        this.listener.dispose();
        this.listener = null;
    }
}

