/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import org.eclipse.actf.model.internal.flash.proxy.BitBuffer;

class SwfStageResizer {
    private static final Logger LOGGER = Logger.getLogger(SwfStageResizer.class.getName());
    private static final int COMPRESSED_FLAG = 67;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int byteCount = 0;
    private byte[] buf2 = new byte[17];
    private ByteArrayOutputStream bo;
    private InputStream bi;

    SwfStageResizer() {
    }

    public static byte[] resize(byte[] swf, int w, int h) {
        return new SwfStageResizer().doResize(swf, w, h);
    }

    public byte[] doResize(byte[] swf, int w, int h) {
        try {
            LOGGER.info("Resizing SWF to " + w / 20 + "x" + h / 20 + " pixels...");
            this.bo = new ByteArrayOutputStream();
            this.bi = new ByteArrayInputStream(swf);
            int data = this.bi.read();
            this.bo.write(70);
            boolean isCompressed = data == 67;
            LOGGER.fine("compressed? = " + isCompressed);
            this.bo.write(this.bi.read());
            this.bo.write(this.bi.read());
            data = this.bi.read();
            this.bo.write(data);
            int swfVersion = data & 0xFF;
            LOGGER.fine("SWF version = " + swfVersion);
            byte[] buf = new byte[4];
            this.bi.read(buf);
            int length = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | buf[3] << 24;
            LOGGER.fine("length = " + length);
            this.bo.write(buf);
            if (isCompressed) {
                this.bi = new InflaterInputStream(this.bi);
            }
            int[] size = this.readFrameSize();
            LOGGER.fine("original frame size (in twips) = " + size[0] + "x" + size[1]);
            this.writeFrameSize(w, h);
            data = this.bi.read();
            int rate = (data & 0xFF) << 8;
            this.bo.write(data);
            data = this.bi.read();
            this.bo.write(data);
            LOGGER.fine("framerate = " + (rate |= data & 0xFF));
            data = this.bi.read();
            int framecount = data & 0xFF;
            this.bo.write(data);
            data = this.bi.read();
            this.bo.write(data);
            LOGGER.fine("framecount = " + (framecount |= (data & 0xFF) << 8));
            while ((data = this.bi.read()) >= 0) {
                this.bo.write(data);
            }
            byte[] array = this.bo.toByteArray();
            int fileSize = array.length;
            LOGGER.info("Modifying file size field from " + length + " to " + fileSize);
            int i = 4;
            while (i <= 7) {
                array[i] = (byte)(fileSize & 0xFF);
                fileSize >>= 8;
                ++i;
            }
            LOGGER.fine("done");
            return array;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private int[] readFrameSize() throws IOException {
        int[] size = new int[2];
        int nBits = this.readUBits(5);
        LOGGER.fine("frame size X min = " + Integer.toString(this.readSBits(nBits)));
        size[0] = this.readSBits(nBits);
        LOGGER.fine("frame size X max (twips) = " + Integer.toString(size[0]));
        LOGGER.fine("frame size Y min = " + Integer.toString(this.readSBits(nBits)));
        size[1] = this.readSBits(nBits);
        LOGGER.fine("frame size Y max (twips) = " + Integer.toString(size[1]));
        return size;
    }

    private int readSBits(int numBits) throws IOException {
        if (numBits > 32) {
            throw new IOException("Number of bits > 32");
        }
        int num = this.readUBits(numBits);
        int shift = 32 - numBits;
        num = num << shift >> shift;
        return num;
    }

    private int readUBits(int numBits) throws IOException {
        int shift;
        byte[] buf;
        if (numBits == 0) {
            return 0;
        }
        int bitsLeft = numBits;
        int result = 0;
        if (this.bitPos == 0) {
            buf = new byte[1];
            this.bi.read(buf);
            this.buf2[this.byteCount] = buf[0];
            ++this.byteCount;
            this.bitBuf = buf[0] & 0xFF;
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            buf = new byte[1];
            this.bi.read(buf);
            this.buf2[this.byteCount] = buf[0];
            ++this.byteCount;
            this.bitBuf = buf[0] & 0xFF;
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private void writeFrameSize(int w, int h) throws IOException {
        int dw = this.numDigit(w) + 1;
        int dh = this.numDigit(h) + 1;
        LOGGER.fine("required number of digits = " + dw + ", " + dh);
        int d = Math.max(dw, dh);
        BitBuffer bb = new BitBuffer();
        bb.append(d, 5);
        bb.append(0, d);
        bb.append(w, d);
        bb.append(0, d);
        bb.append(h, d);
        this.bo.write(bb.toByteArray());
    }

    private int numDigit(int v) {
        if (v < 0) {
            return -1;
        }
        int d = 0;
        while (v > 0) {
            v >>= 1;
            ++d;
        }
        return d;
    }
}

