/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.model.flash.util.AsVersionChecker;
import org.eclipse.actf.model.flash.util.SwfInfo;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.model.internal.flash.proxy.SwfStageResizer;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverrider;
import org.eclipse.actf.util.httpproxy.util.CacheMap;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class SWFBootloader
implements IHTTPSessionOverrider {
    private static final String MUST_REVALIDATE = "must-revalidate";
    private static final String NO_CACHE = "no-cache";
    private static final String OK = "OK";
    private static final String RESPONSE_200 = "200";
    private static final Logger LOGGER = Logger.getLogger(SWFBootloader.class);
    private static byte[] bootLoaderSWF;
    private static byte[] bootLoaderSWFv9;
    private boolean replacedFlag;
    private boolean bootloaderRequestingFlag;
    private boolean hasXFlashVersionHeader;
    private IHTTPRequestMessage sessionRequest;
    private IHTTPResponseMessage sessionResponse;
    private final int id;
    private CachedSlot sessionCachedSlot;
    private static final int MAX_REFERER_LENGTH = 128;

    public IHTTPRequestMessage getSessionRequest() {
        return this.sessionRequest;
    }

    public IHTTPResponseMessage getSessionResponse() {
        return this.sessionResponse;
    }

    public SWFBootloader(int id) {
        this.id = id;
    }

    private static byte[] readSWFBootLoaderFile(InputStream is) {
        try {
            int b;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((b = is.read()) >= 0) {
                os.write(b);
            }
            return os.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void setSWFBootLoaderFile(InputStream is) {
        bootLoaderSWF = SWFBootloader.readSWFBootLoaderFile(is);
    }

    public static void setSWFBootLoaderFileV9(InputStream is) {
        bootLoaderSWFv9 = SWFBootloader.readSWFBootLoaderFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedObject(IClientStateManager csm, String uri) {
        CacheMap map = this.getCacheMap(csm);
        if (uri.length() > 128) {
            CacheMap cacheMap = map;
            synchronized (cacheMap) {
                return map.matchStartsWith(uri);
            }
        }
        CacheMap cacheMap = map;
        synchronized (cacheMap) {
            return map.get((Object)uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheObject(IClientStateManager csm, String uri, Object cobj) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCacheMap(csm);
        synchronized (cacheMap) {
            map.put(uri, cobj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeObject(IClientStateManager csm, String uri) {
        CacheMap map;
        CacheMap cacheMap = map = this.getCacheMap(csm);
        synchronized (cacheMap) {
            return map.remove((Object)uri);
        }
    }

    private CacheMap getCacheMap(IClientStateManager csm) {
        CacheMap map = (CacheMap)csm.get(SWFBootloader.class);
        if (map == null) {
            map = new CacheMap(256, 20);
            csm.put(SWFBootloader.class, (Object)map);
        }
        return map;
    }

    private static IHTTPResponseMessage bootloaderResponseMessage(IHTTPRequestMessage request) {
        IHTTPResponseMessage msg = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])bootLoaderSWF);
        msg.setHeader(IHTTPHeader.CACHE_CONTROL_A, MUST_REVALIDATE.getBytes());
        msg.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return msg;
    }

    private static IHTTPResponseMessage bootloaderResponseMessageV9(IHTTPRequestMessage request, int w, int h) {
        IHTTPResponseMessage msg = HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])RESPONSE_200.getBytes(), (byte[])OK.getBytes(), (byte[])SwfStageResizer.resize(bootLoaderSWFv9, w, h));
        msg.setHeader(IHTTPHeader.CACHE_CONTROL_A, MUST_REVALIDATE.getBytes());
        msg.setHeader(IHTTPHeader.CONTENT_TYPE_A, SWFUtil.MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A);
        return msg;
    }

    public boolean replaceRequest(IClientStateManager csm, IHTTPRequestMessage request) throws IOException {
        CachedSlot cs;
        this.replacedFlag = false;
        if (!WaXcodingConfig.getInstance().getSWFBootloaderFlag()) {
            return false;
        }
        IHTTPHeader uaHeader = request.getHeader(IHTTPHeader.USER_AGENT_A);
        boolean bl = this.hasXFlashVersionHeader = uaHeader != null && new String(uaHeader.getValue()).contains("MSIE");
        if (this.hasXFlashVersionHeader && request.getHeader(SWFUtil.X_FLASH_VERSION_A) == null) {
            return false;
        }
        String uriStr = request.getRequestURIString();
        String method = request.getMethodAsString();
        Object cobj = this.getCachedObject(csm, uriStr);
        if (LOGGER.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("method:");
            buf.append(method);
            buf.append(' ');
            buf.append(uriStr);
            for (IHTTPHeader h : request.getHeaders()) {
                if (h.isRemoved()) continue;
                buf.append(h.toString());
                buf.append('\n');
            }
            this.DEBUG(buf.toString());
        }
        if ("POST".equals(method) && cobj instanceof CachedSlot) {
            ByteArrayOutputStream ob = new ByteArrayOutputStream();
            try {
                request.write(0L, (OutputStream)ob);
            }
            catch (TimeoutException timeoutException) {}
            if (LOGGER.isDebugEnabled()) {
                this.DEBUG("Bootloader's POST command:" + new String(ob.toByteArray()));
            }
            this.INFO("bootloader requests the original SWF:" + uriStr);
            this.replacedFlag = true;
            this.bootloaderRequestingFlag = true;
            this.sessionCachedSlot = (CachedSlot)cobj;
            this.sessionRequest = this.sessionCachedSlot.request;
            this.sessionRequest.removeHeader("If-Modified-Since".getBytes());
            this.sessionResponse = this.sessionCachedSlot.response;
            return true;
        }
        IHTTPHeader referer = request.getHeader(IHTTPHeader.REFERER_A);
        if (referer != null) {
            String refStrBase = new String(referer.getValue()).trim();
            String uriStrBase = uriStr;
            Object o = this.getCachedObject(csm, refStrBase);
            if (o != null) {
                this.INFO(String.valueOf(uriStrBase) + " seems to be referred by " + refStrBase);
                if (cobj == null) {
                    this.cacheObject(csm, uriStrBase, true);
                }
                return false;
            }
        } else if (!this.hasXFlashVersionHeader) {
            this.INFO(String.valueOf(uriStr) + " seems to be referred by other swf");
            return false;
        }
        if (cobj instanceof CachedSlot) {
            cs = (CachedSlot)cobj;
        } else {
            cs = new CachedSlot(uriStr);
            this.cacheObject(csm, uriStr, cs);
        }
        cs.request = request;
        this.replacedFlag = true;
        this.bootloaderRequestingFlag = false;
        this.sessionCachedSlot = cs;
        this.sessionRequest = request;
        this.sessionRequest.removeHeader(IHTTPHeader.IF_MODIFIED_SINCE_A);
        this.sessionRequest.removeHeader(IHTTPHeader.ACCEPT_ENCODING_A);
        this.sessionResponse = null;
        return true;
    }

    public boolean replaceResponse(IClientStateManager csm, IHTTPRequestMessage request, IHTTPResponseMessage response, int timeout) throws IOException, TimeoutException {
        IHTTPResponsePushbackMessage newResponse;
        IPushbackMessageBody body;
        if (!this.replacedFlag) {
            return false;
        }
        if (this.bootloaderRequestingFlag) {
            if (response != this.sessionCachedSlot.response) {
                response.setHeader(IHTTPHeader.CACHE_CONTROL_A, NO_CACHE.getBytes());
            }
            this.sessionResponse = response;
            return true;
        }
        if (this.hasXFlashVersionHeader) {
            if (!SWFUtil.isPossiblySWFContentType(response)) {
                return false;
            }
        } else if (!SWFUtil.isSWFContentType(response)) {
            this.removeObject(csm, this.sessionCachedSlot.uri);
            return false;
        }
        if ((body = (newResponse = HTTPUtil.createHTTPResponsePushbackMessage((IHTTPResponseMessage)response, (int)0x100000)).getPushbackMessageBody()) == null) {
            return false;
        }
        PushbackInputStream bodyInputStream = body.getMessageBodyPushBackInputStream();
        int version = SWFUtil.isSWF(bodyInputStream);
        SwfInfo swfInfo = null;
        this.INFO("The incoming SWF is version " + version);
        String uriStr = request.getRequestURIString();
        if (version >= WaXcodingConfig.getInstance().getSWFTranscodingMinimumVersion() && version < 10) {
            IHTTPResponseMessage msg;
            if (version < 9) {
                msg = SWFBootloader.bootloaderResponseMessage(request);
                this.INFO("bootloader is used for " + uriStr);
            } else {
                this.DEBUG("Checking AS version...");
                AsVersionChecker asChecker = new AsVersionChecker();
                asChecker.setSwfFile(bodyInputStream);
                swfInfo = asChecker.getSwfInfo();
                int asVersion = swfInfo.getAsVersion();
                int frameX = swfInfo.getFrameSizeX();
                int frameY = swfInfo.getFrameSizeY();
                this.INFO("AS version of SWF: " + asVersion);
                switch (asVersion) {
                    case 3: {
                        this.INFO("Resizing bootloader...");
                        msg = SWFBootloader.bootloaderResponseMessageV9(request, frameX, frameY);
                        this.INFO("bootloader v9 is used for " + uriStr);
                        break;
                    }
                    case 2: {
                        msg = SWFBootloader.bootloaderResponseMessage(request);
                        this.INFO("bootloader (v9-as2) is used for " + uriStr);
                        break;
                    }
                    default: {
                        this.INFO("Flash V9 (AS version:" + asVersion + "). The bootloader is not applied to " + uriStr);
                        this.sessionResponse = newResponse;
                        return true;
                    }
                }
            }
            this.sessionResponse = msg;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            newResponse.writeBody((long)timeout, (IMessageBody)body, (OutputStream)os);
            IHTTPResponseMessage cachedResponse = HTTPUtil.createHTTPResponseInMemoryMessage((IHTTPResponseMessage)response, (byte[])os.toByteArray());
            cachedResponse.setHeader(IHTTPHeader.CACHE_CONTROL_A, "no-cache,must-revalidate".getBytes());
            cachedResponse.setHeader(IHTTPHeader.PRAGMA_A, NO_CACHE.getBytes());
            cachedResponse.setHeader(IHTTPHeader.EXPIRES_A, "-1".getBytes());
            this.INFO("The original response is cached for later use.");
            if (LOGGER.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer("CachedMessage: ");
                for (IHTTPHeader h : cachedResponse.getHeaders()) {
                    if (h.isRemoved()) continue;
                    buf.append(h.toString());
                    buf.append('\n');
                }
                this.DEBUG(buf.toString());
            }
            this.sessionCachedSlot.response = cachedResponse;
            return true;
        }
        this.INFO("Due to the unsupported version, the bootloader is not applied to " + uriStr);
        this.sessionResponse = newResponse;
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[id:").append(this.id).append("] SWFBootloader");
        return sb.toString();
    }

    private final void INFO(String msg) {
        LOGGER.info(msg);
    }

    private final void DEBUG(String msg) {
        LOGGER.debug(msg);
    }

    private static class CachedSlot {
        public final String uri;
        public IHTTPRequestMessage request;
        public IHTTPResponseMessage response;

        CachedSlot(String uri) {
            this.uri = uri;
        }
    }
}

