/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash;

import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.internal.flash.ASBridgeImplV8;
import org.eclipse.actf.model.internal.flash.ASBridgeImplV9;
import org.eclipse.actf.model.internal.flash.FlashStatusUtil;
import org.eclipse.actf.util.win32.FlashMSAAObject;
import org.eclipse.actf.util.win32.FlashMSAAObjectFactory;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;

public class FlashPlayer
implements IFlashPlayer {
    private IDispatch idispFlash;
    private FlashMSAAObject accessible;
    private int swfVersion = -1;
    private IASBridge asBrigde = null;
    private final boolean _isVisible;
    private boolean _isReady = false;

    FlashPlayer(IDispatch idisp) {
        this.idispFlash = idisp;
        try {
            this.accessible = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)this.idispFlash);
        }
        catch (Exception exception) {
            this._isReady = true;
        }
        String wmode = this.getWMode();
        this._isVisible = wmode == null || !"Opaque".equalsIgnoreCase(wmode) && !"Transparent".equalsIgnoreCase(wmode);
    }

    private boolean initAsBridge() {
        if (this.asBrigde != null) {
            return true;
        }
        switch (this.getSWFVersion()) {
            case 8: {
                this.asBrigde = new ASBridgeImplV8(this);
                return true;
            }
            case 9: {
                this.asBrigde = new ASBridgeImplV9(this);
                return true;
            }
        }
        this.asBrigde = new ASBridgeImplV8(this);
        if (this.asBrigde.getRootNode() != null) {
            return true;
        }
        this.asBrigde = new ASBridgeImplV9(this);
        if (this.asBrigde.getRootNode() != null) {
            return true;
        }
        this.asBrigde = null;
        return false;
    }

    public FlashMSAAObject getAccessible() {
        return this.accessible;
    }

    public boolean isReady() {
        if (this._isReady) {
            return true;
        }
        try {
            Object r = this.idispFlash.get("readyState");
            if (COMPLETED_READY_STATE.equals(r)) {
                this._isReady = true;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public IASNode getRootNode() {
        if (this.initAsBridge()) {
            return this.asBrigde.getRootNode();
        }
        return null;
    }

    public IASNode getNodeFromPath(String path) {
        if (this.initAsBridge()) {
            return this.asBrigde.getNodeFromPath(path);
        }
        return null;
    }

    public IASNode getNodeAtDepthWithPath(String path, int depth) {
        if (this.initAsBridge()) {
            return this.asBrigde.getNodeAtDepthWithPath(path, depth);
        }
        return null;
    }

    public IASNode[] translateWithPath(String path) {
        if (this.initAsBridge()) {
            return this.asBrigde.translateWithPath(path);
        }
        return new IASNode[0];
    }

    public boolean hasChild(IASNode parentNode, boolean visual, boolean debugMode) {
        if (this.initAsBridge()) {
            return this.asBrigde.hasChild(parentNode, visual, debugMode);
        }
        return false;
    }

    public IASNode[] getChildren(IASNode parentNode, boolean visual, boolean debugMode) {
        if (this.initAsBridge()) {
            return this.asBrigde.getChildren(parentNode, visual, debugMode);
        }
        return new IASNode[0];
    }

    public IASNode[] searchVideo() {
        if (this.initAsBridge()) {
            return this.asBrigde.searchVideo();
        }
        return new IASNode[0];
    }

    public IASNode[] searchSound() {
        if (this.initAsBridge()) {
            return this.asBrigde.searchSound();
        }
        return new IASNode[0];
    }

    public boolean setMarker(Number x, Number y, Number width, Number height) {
        if (this.initAsBridge()) {
            return this.asBrigde.setMarker(x, y, width, height);
        }
        return false;
    }

    public boolean setMarker(IASNode node) {
        if (this.initAsBridge()) {
            return this.asBrigde.setMarker(node);
        }
        return false;
    }

    public boolean unsetMarker() {
        if (this.initAsBridge()) {
            return this.asBrigde.unsetMarker();
        }
        return false;
    }

    public boolean clearAllMarkers() {
        if (this.initAsBridge()) {
            return this.asBrigde.clearAllMarkers();
        }
        return false;
    }

    public boolean setFocus(String target) {
        if (this.initAsBridge()) {
            return this.asBrigde.setFocus(target);
        }
        return false;
    }

    public Object getProperty(String path, String prop) {
        if (this.initAsBridge()) {
            return this.asBrigde.getProperty(path, prop);
        }
        return null;
    }

    public void setProperty(String path, String prop, Object value) {
        if (this.initAsBridge()) {
            this.asBrigde.setProperty(path, prop, value);
        }
    }

    public boolean updateTarget() {
        if (this.initAsBridge()) {
            return this.asBrigde.updateTarget();
        }
        return false;
    }

    public void repairFlash() {
        if (this.initAsBridge()) {
            this.asBrigde.repairFlash();
        }
    }

    public Object callMethod(IASNode targetNode, String method) {
        if (this.initAsBridge()) {
            return this.asBrigde.callMethod(targetNode, method);
        }
        return null;
    }

    public Object callMethod(IASNode targetNode, String method, Object[] args) {
        if (this.initAsBridge()) {
            return this.asBrigde.callMethod(targetNode, method, args);
        }
        return null;
    }

    public String getStatus() {
        return FlashStatusUtil.getStatus(this);
    }

    public String getWMode() {
        try {
            Object objWMode = this.idispFlash.get("WMode");
            return (String)objWMode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getVariable(String name) {
        try {
            Object obj = this.idispFlash.invoke1("GetVariable", (Object)name);
            return (String)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPlayerProperty(String propertyName, String value) {
        try {
            this.idispFlash.invoke("SetAttribute", new Object[]{propertyName, value});
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getPlayerProperty(String propertyName) {
        try {
            Object obj = this.idispFlash.get(propertyName);
            return (String)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getWindow() {
        FlashMSAAObject fob = FlashMSAAObjectFactory.getFlashMSAAObjectFromElement((IUnknown)this.idispFlash);
        return fob.getWindow();
    }

    public IDispatch getDispatch() {
        return this.idispFlash;
    }

    public String getPlayerVersion() {
        IASNode versionNode;
        String version = this.getVariable("$version");
        if (version == null && (versionNode = this.getNodeFromPath("$version")) != null) {
            version = versionNode.getValue();
        }
        return version;
    }

    public String getContentURL() {
        String result = this.getVariable("_url");
        if (result != null) {
            return result;
        }
        return "";
    }

    public int getSWFVersion() {
        if (this.swfVersion == -1) {
            try {
                Object result = this.idispFlash.invoke0("getSwfVersion");
                if (result instanceof Number) {
                    this.swfVersion = ((Number)result).intValue();
                }
            }
            catch (Exception exception) {}
        }
        return this.swfVersion;
    }
}

