/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.internal;

import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;
import org.eclipse.actf.ai.voice.internal.VoicePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Voice
implements IVoice,
IPropertyChangeListener {
    private ITTSEngine ttsEngine = this.newTTSEngine();
    private IVoiceEventListener eventListener;
    private static final IPreferenceStore preferenceStore = VoicePlugin.getDefault().getPreferenceStore();

    public Voice() {
        VoicePlugin.getDefault().addPropertyChangeListener(this);
        this.setSpeed();
    }

    private ITTSEngine newTTSEngine() {
        ITTSEngine engine = TTSRegistry.createTTSEngine(preferenceStore.getString("activeEngine"));
        if (engine == null) {
            engine = TTSRegistry.createTTSEngine(TTSRegistry.getDefaultEngine());
        }
        return engine;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("activeEngine".equals(event.getProperty())) {
            if (this.ttsEngine != null) {
                this.stop();
                this.ttsEngine.dispose();
                this.ttsEngine = this.newTTSEngine();
                this.setSpeed();
                this.setEventListener(this.eventListener);
            }
        } else if ("defaultSpeed".equals(event.getProperty())) {
            this.stop();
            this.setSpeed();
        }
    }

    public void speak(String text, boolean flush) {
        this.speak(text, flush, -1);
    }

    public void speak(String text, boolean flush, int index) {
        if (this.ttsEngine != null) {
            this.ttsEngine.speak(text, flush ? 1 : 0, index);
        }
    }

    public void stop() {
        if (this.ttsEngine != null) {
            this.ttsEngine.stop();
        }
    }

    public int getSpeed() {
        if (this.ttsEngine != null) {
            return this.ttsEngine.getSpeed();
        }
        return -1;
    }

    public void setSpeed() {
        this.setSpeed(VoiceUtil.getDefaultSpeed());
    }

    public void setSpeed(int speed) {
        if (this.ttsEngine != null) {
            this.ttsEngine.setSpeed(speed);
        }
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.eventListener = eventListener;
        if (this.ttsEngine != null) {
            this.ttsEngine.setEventListener(eventListener);
        }
    }

    public void dispose() {
        if (this.ttsEngine != null) {
            this.stop();
            this.ttsEngine.dispose();
            this.ttsEngine = null;
        }
    }

    public ITTSEngine getTTSEngine() {
        return this.ttsEngine;
    }
}

