/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import java.util.ArrayList;
import org.eclipse.actf.model.dom.dombycom.IObjectElementFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ObjectElementFactoryExtension {
    private static final String EXTENSION_NAME = "elementFactory";
    private static final String OBJECT_ELEMENT_FACTORY = "objectElementFactory";
    private static final String ATTR_IMPL = "implementations";
    private static ObjectElementFactoryExtension[] extensions;
    private static IObjectElementFactory[] factories;
    private IObjectElementFactory factory = null;

    static {
        factories = null;
    }

    public static IObjectElementFactory[] getObjectElementFactories() {
        if (factories != null) {
            return factories;
        }
        ObjectElementFactoryExtension[] tmpExtensions = ObjectElementFactoryExtension.getExtensions();
        ArrayList<IObjectElementFactory> tmpList = new ArrayList<IObjectElementFactory>();
        if (tmpExtensions != null) {
            int i = 0;
            while (i < tmpExtensions.length) {
                IObjectElementFactory tmpFactory = tmpExtensions[i].getFactory();
                if (tmpFactory != null) {
                    tmpList.add(tmpFactory);
                }
                ++i;
            }
        }
        factories = new IObjectElementFactory[tmpList.size()];
        tmpList.toArray(factories);
        return factories;
    }

    private static ObjectElementFactoryExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] tmpExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.model.dom.dombycom", EXTENSION_NAME).getExtensions();
        ArrayList<ObjectElementFactoryExtension> l = new ArrayList<ObjectElementFactoryExtension>();
        int i = 0;
        while (i < tmpExtensions.length) {
            IConfigurationElement[] configElements = tmpExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                ObjectElementFactoryExtension ex = ObjectElementFactoryExtension.parseExtension(configElements[j]);
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        extensions = l.toArray(new ObjectElementFactoryExtension[l.size()]);
        return extensions;
    }

    private static ObjectElementFactoryExtension parseExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(OBJECT_ELEMENT_FACTORY)) {
            return null;
        }
        try {
            return new ObjectElementFactoryExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ObjectElementFactoryExtension(IConfigurationElement configElement) {
        try {
            this.factory = (IObjectElementFactory)configElement.createExecutableExtension(ATTR_IMPL);
        }
        catch (Exception exception) {}
    }

    private IObjectElementFactory getFactory() {
        return this.factory;
    }
}

