/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public class SocketTimeoutRetryOutputStream
extends OutputStream {
    private final OutputStream outputStream;

    public static void write(OutputStream os, byte[] buf) throws IOException {
        while (true) {
            try {
                os.write(buf);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static void write(OutputStream os, byte[] buf, int offset, int len) throws IOException {
        while (true) {
            try {
                os.write(buf, offset, len);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static void write(OutputStream os, int b) throws IOException {
        while (true) {
            try {
                os.write(b);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        while (true) {
            try {
                this.outputStream.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void flush() throws IOException {
        while (true) {
            try {
                this.outputStream.flush();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void write(byte[] buf) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, buf);
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, buf, offset, len);
    }

    public void write(int b) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, b);
    }

    SocketTimeoutRetryOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

