/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.InputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.FixedSizeQueue;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseReader;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.core.Session;

public abstract class RequestDispatcher
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(RequestDispatcher.class);
    private final int fId;
    private FixedSizeQueue fArrivedMsgs;
    private IHTTPRequestMessage fNextMsg = null;
    protected final Session fSession;

    protected RequestDispatcher(String name, Session session, IClientConnection client, Socket clientSock, int queueSize) {
        super(name);
        this.fSession = session;
        this.fId = clientSock.getPort();
        this.fArrivedMsgs = new FixedSizeQueue(queueSize);
    }

    public int getDispatcherId() {
        return this.fId;
    }

    public void putRequest(IHTTPRequestMessage req, long timeout) throws InterruptedException, TimeoutException {
        this.fArrivedMsgs.put(req, timeout);
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Request received from a client: ");
            sb.append("tid=").append(req.getTid());
            sb.append(", msgSerial=").append(req.getSerial());
            this.DEBUG(sb.toString());
        }
    }

    synchronized boolean responseArrived(ServerConnection conn, IHTTPResponseMessage response) throws InterruptedException {
        boolean received;
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Response arrived from a server (").append(conn);
            sb.append("): tid=").append(response.getTid());
            sb.append(", msgSerial=").append(response.getSerial());
            this.DEBUG(sb.toString());
        }
        return received = this.fSession.receiveResponse(response);
    }

    private String msgToString(IHTTPMessage msg) {
        StringBuffer sb = new StringBuffer();
        if (msg == null) {
            sb.append("null");
        } else {
            sb.append("(ser=").append(msg.getSerial());
            sb.append(",tid=").append(msg.getTid()).append(')');
        }
        return sb.toString();
    }

    private String dumpMessages() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sent=").append(this.msgToString(this.fSession.getRequestMessage()));
        sb.append(", Next=").append(this.msgToString(this.fNextMsg));
        sb.append(", Arrived=").append(this.fArrivedMsgs.getSize());
        return sb.toString();
    }

    public HTTPRequestReader createHTTPRequestReader(InputStream is) {
        return new HTTPRequestReader(is);
    }

    public HTTPResponseReader createHTTPResponseReader(InputStream is) {
        return new HTTPResponseReader(this.getDispatcherId(), is);
    }

    protected IHTTPRequestMessage getNextRequest() throws InterruptedException {
        if (this.fNextMsg != null) {
            this.DEBUG("Reuse the same request");
            return this.fNextMsg;
        }
        this.fNextMsg = (IHTTPRequestMessage)this.fArrivedMsgs.remove();
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Filled a message: msgSerial=" + this.fNextMsg.getSerial() + ", tid=" + this.fNextMsg.getTid());
            this.DEBUG(this.dumpMessages());
        }
        return this.fNextMsg;
    }

    protected void clearNextRequest() {
        this.fNextMsg = null;
    }

    protected void startSessionAndSendRequest(IHTTPRequestMessage request, ServerConnection conn, long timeout) throws InterruptedException, TimeoutException {
        this.fSession.start(request);
        conn.putRequest(request, timeout);
    }

    public abstract void run();

    public void close() {
        this.DEBUG("Closing a RequestDispatcher");
        this.interrupt();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RequestDispatcher-").append(this.fId);
        return sb.toString();
    }

    protected void DEBUG(String msg) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.toString()).append(": ").append(msg);
            LOGGER.debug(sb.toString());
        }
    }

    protected void WARNING(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString()).append(": ").append(msg);
        LOGGER.warning(sb.toString());
    }

    protected void INFO(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString()).append(": ").append(msg);
        LOGGER.info(sb.toString());
    }
}

