/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPReader;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;

public class ChunkedMessageBodyReader
extends HTTPReader {
    static final Logger LOGGER = Logger.getLogger(ChunkedMessageBodyReader.class);

    public ChunkedMessageBodyReader(InputStream in) {
        super(in);
    }

    public int readChunkedMessage(long timeout, OutputStream out, HTTPMessage msg) throws IOException, TimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("readChunkedMessage: timeout=" + timeout);
        }
        int totalChunkSize = this.readChunkedMessageBody(timeout, out);
        HTTPMessageBuffer buf = msg.getBuffer();
        HeaderInBuffer header = this.readHeader(timeout, buf);
        while (header != null) {
            msg.addTrailingHeader(header);
            header = this.readHeader(timeout, buf);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("readChunkedMessage: totalChunkSize=" + totalChunkSize);
        }
        return totalChunkSize;
    }
}

