/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy;

import java.util.ArrayList;
import org.eclipse.actf.util.internal.httpproxy.IObjectPool;

public class ObjectPoolImpl
implements IObjectPool {
    private final String name;
    private ArrayList<Object> pool;
    private int waitInLine;

    public synchronized boolean add(Object o) {
        boolean flag = this.pool.add(o);
        if (flag && this.waitInLine > 0) {
            this.notify();
        }
        return flag;
    }

    public synchronized Object take() {
        if (this.pool.size() == 0) {
            return null;
        }
        return this.pool.remove(0);
    }

    public synchronized Object take(int timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ++this.waitInLine;
        while (this.pool.size() == 0) {
            this.wait(timeout);
            if (timeout <= 0 || System.currentTimeMillis() - startTime <= (long)timeout) continue;
            --this.waitInLine;
            return null;
        }
        --this.waitInLine;
        return this.pool.remove(0);
    }

    public ObjectPoolImpl(String name) {
        this.name = name;
        this.pool = new ArrayList();
        this.waitInLine = 0;
    }

    public String getName() {
        return this.name;
    }
}

