/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExploder {
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    protected boolean verbose;
    protected boolean sortNames;

    public ZipExploder() {
        this(false);
    }

    public ZipExploder(boolean verbose) {
        this.setVerbose(verbose);
    }

    public ZipExploder(boolean verbose, boolean sorted) {
        this(verbose);
        this.setSortNames(sorted);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean f) {
        this.verbose = f;
    }

    public boolean getSortNames() {
        return this.sortNames;
    }

    public void setSortNames(boolean sortNames) {
        this.sortNames = sortNames;
    }

    public void process(String[] zipNames, String[] jarNames, String destDir) throws IOException {
        this.processZips(zipNames, destDir);
        this.processJars(jarNames, destDir);
    }

    public void processJars(String[] jarNames, String destDir) throws IOException {
        int i = 0;
        while (i < jarNames.length) {
            this.processFile(jarNames[i], destDir);
            ++i;
        }
    }

    public void processZips(String[] zipNames, String destDir) throws IOException {
        int i = 0;
        while (i < zipNames.length) {
            this.processFile(zipNames[i], destDir);
            ++i;
        }
    }

    public void processFile(String zipName, String destDir) throws IOException {
        String source = new File(zipName).getCanonicalPath();
        String dest = new File(destDir).getCanonicalPath();
        if (this.verbose) {
            this.logger.log(Level.FINE, "\n**** Exploding " + source + " to " + dest);
        }
        ZipFile f = null;
        try {
            try {
                f = new ZipFile(source);
                Map fEntries = this.getEntries(f);
                Object[] names = fEntries.keySet().toArray(new String[0]);
                if (this.sortNames) {
                    Arrays.sort(names);
                }
                int i = 0;
                while (i < names.length) {
                    Object name = names[i];
                    ZipEntry e = (ZipEntry)fEntries.get(name);
                    this.copyFileEntry(dest, f, e);
                    ++i;
                }
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg.indexOf(zipName) < 0) {
                    msg = String.valueOf(msg) + " - " + zipName;
                }
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Map getEntries(ZipFile zf) {
        Enumeration<? extends ZipEntry> e = zf.entries();
        HashMap<String, ZipEntry> m = new HashMap<String, ZipEntry>();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            m.put(ze.getName(), ze);
        }
        return m;
    }

    public void copyFileEntry(String destDir, ZipFile zf, ZipEntry ze) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
        try {
            this.copyFileEntry(destDir, ze.isDirectory(), ze.getName(), dis);
        }
        catch (Throwable throwable) {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dis.close();
        }
        catch (IOException iOException) {}
    }

    protected void copyFileEntry(String destDir, boolean destIsDir, String destFile, DataInputStream dis) throws IOException {
        File dir;
        byte[] bytes = this.readAllBytes(dis);
        this.logger.log(Level.FINE, "Writing " + bytes.length + " bytes...");
        File file = new File(destFile);
        String parent = file.getParent();
        if (parent != null && parent.length() > 0 && (dir = new File(destDir, parent)) != null) {
            this.logger.log(Level.FINE, "Creating directory path " + dir.getAbsolutePath());
            dir.mkdirs();
            this.logger.log(Level.FINE, "Created directory path " + dir.getAbsolutePath());
        }
        File outFile = new File(destDir, destFile);
        if (destIsDir) {
            this.logger.log(Level.FINE, "Creating directory " + outFile.getAbsolutePath());
            outFile.mkdir();
            this.logger.log(Level.FINE, "Created directory " + outFile.getAbsolutePath());
        } else {
            this.logger.log(Level.FINE, "Creating file " + outFile.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(outFile);
            try {
                fos.write(bytes, 0, bytes.length);
                if (this.verbose) {
                    this.logger.log(Level.FINE, "Copied file " + outFile.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected byte[] readAllBytes(DataInputStream is) throws IOException {
        byte[] bytes = new byte[]{};
        int len = is.available();
        while (len > 0) {
            byte[] xbytes = new byte[len];
            int count = is.read(xbytes);
            this.logger.log(Level.FINE, "readAllBytes: " + len + " vs. " + count);
            if (count > 0) {
                byte[] nbytes = new byte[bytes.length + count];
                System.arraycopy(bytes, 0, nbytes, 0, bytes.length);
                System.arraycopy(xbytes, 0, nbytes, bytes.length, count);
                bytes = nbytes;
            } else if (count < 0) break;
            len = is.available();
        }
        return bytes;
    }

    protected void print(String s) {
        System.out.print(s);
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipExploder.class.getName() + " (-jar jarFilename... | -zip zipFilename...)... -dir destDir {-verbose}");
        System.out.println("Where:");
        System.out.println("  jarFilename path to source jar, may repeat");
        System.out.println("  zipFilename path to source zip, may repeat");
        System.out.println("  destDir    path to target directory; should exist");
        System.out.println("Note: one -jar or -zip is required; switch case or order is not important");
    }

    protected static void reportError(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ZipExploder.printHelp();
            System.exit(0);
        }
        ArrayList<String> zipNames = new ArrayList<String>();
        ArrayList<String> jarNames = new ArrayList<String>();
        String destDir = null;
        boolean jarActive = false;
        boolean zipActive = false;
        boolean destDirActive = false;
        boolean verbose = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if ((arg = arg.substring(1)).equalsIgnoreCase("jar")) {
                    jarActive = true;
                    zipActive = false;
                    destDirActive = false;
                } else if (arg.equalsIgnoreCase("zip")) {
                    zipActive = true;
                    jarActive = false;
                    destDirActive = false;
                } else if (arg.equalsIgnoreCase("dir")) {
                    jarActive = false;
                    zipActive = false;
                    destDirActive = true;
                } else if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                } else {
                    ZipExploder.reportError("Invalid switch - " + arg);
                }
            } else if (jarActive) {
                jarNames.add(arg);
            } else if (zipActive) {
                zipNames.add(arg);
            } else if (destDirActive) {
                if (destDir != null) {
                    ZipExploder.reportError("duplicate argument - -destDir");
                }
                destDir = arg;
            } else {
                ZipExploder.reportError("Too many parameters - " + arg);
            }
            ++i;
        }
        if (destDir == null || zipNames.size() + jarNames.size() == 0) {
            ZipExploder.reportError("Missing parameters");
        }
        if (verbose) {
            System.out.println("Effective command: " + ZipExploder.class.getName() + " " + (jarNames.size() > 0 ? "-jars " + jarNames + " " : "") + (zipNames.size() > 0 ? "-zips " + zipNames + " " : "") + "-dir " + destDir);
        }
        try {
            ZipExploder ze = new ZipExploder(verbose);
            ze.process(zipNames.toArray(new String[zipNames.size()]), jarNames.toArray(new String[jarNames.size()]), destDir);
        }
        catch (IOException ioe) {
            System.err.println("Exception - " + ioe.getMessage());
            ioe.printStackTrace();
            System.exit(2);
        }
    }
}

