/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.command;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.eclipse.actf.util.command.IArgumentResolver;

public class DefaultArgumentResolver
implements IArgumentResolver {
    public Object resolve(String arg, Class type) throws Exception {
        Constable result = null;
        if (arg != null) {
            if (type.isArray()) {
                result = this.resolveArray(arg, type.getComponentType());
            } else if (type.equals(String.class)) {
                result = arg;
            } else if (type.equals(Class.class)) {
                try {
                    result = Class.forName(arg);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Illegal class name for switch:" + arg + " - " + e);
                }
            } else if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                result = Short.valueOf(arg);
            } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                result = Integer.valueOf(arg);
            } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                result = Long.valueOf(arg);
            } else if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                result = Float.valueOf(arg);
            } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                result = Double.valueOf(arg);
            } else if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                result = new Character(arg.charAt(0));
            }
        }
        return result;
    }

    protected Object resolveArray(String arg, Class compType) throws Exception {
        if (compType.isArray()) {
            throw new IllegalArgumentException("Default impl of argument resolver does not support multi-dimensional arrays");
        }
        StringTokenizer st = new StringTokenizer(arg);
        Object array = Array.newInstance(compType, st.countTokens());
        int index = 0;
        while (st.hasMoreTokens()) {
            Array.set(array, index++, this.resolve(st.nextToken(), compType));
        }
        return array;
    }
}

