/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.AbstractConfiguration;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EclipseConfiguration
extends AbstractConfiguration {
    static final long serialVersionUID = 7981371198710093969L;
    public static final String MODEL_NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ID = "alias";
    private transient HashMap modelMap;
    private transient HashMap filterMap;
    private transient HashMap pluginMap;
    private transient HashMap attributeMap;
    private Stack elementStack = new Stack();
    private String pluginId;

    public String[] getModelTypes() {
        IExtensionPoint[] extPts;
        IExtensionPoint[] iExtensionPointArray = extPts = Platform.getExtensionRegistry().getExtensionPoints("org.eclipse.actf.model");
        int n = extPts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint point = iExtensionPointArray[n2];
            IExtension[] iExtensionArray = point.getExtensions();
            int n3 = iExtensionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IExtension extension = iExtensionArray[n4];
                try {
                    this.addConfigurationData(extension);
                }
                catch (ConfigurationException configurationException) {
                    Logger.getLogger("org.eclipse.actf.core").log(Level.WARNING, "Could not configure for " + extension.getNamespaceIdentifier() + ", " + extension.getSimpleIdentifier());
                }
                ++n4;
            }
            ++n2;
        }
        return super.getModelTypes();
    }

    public void addConfigurationData(Object data) throws ConfigurationException {
        if (data instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)data;
            this.pluginId = element.getNamespaceIdentifier();
            this.addElement(element);
        } else if (data instanceof IExtension) {
            IExtension extension = (IExtension)data;
            this.pluginId = extension.getNamespaceIdentifier();
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                this.addElement(configElement);
                ++n2;
            }
        }
    }

    private void addElement(IConfigurationElement element) throws ConfigurationException {
        String elementName = element.getName();
        if (elementName.equals("model")) {
            if (this._configMap.containsKey(elementName)) {
                this.setSymbolPool(elementName);
                this.modelMap = (HashMap)this._configMap.get(elementName);
            } else {
                this.createSymbolPool(elementName);
                this.modelMap = new HashMap();
                this._configMap.put(elementName, this.modelMap);
            }
            this.attributeMap = new HashMap();
            String[] stringArray = element.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attrName = stringArray[n2];
                String attrValue = element.getAttribute(attrName);
                if (attrName.equals("class")) {
                    try {
                        Object model = element.createExecutableExtension("class");
                        if (model != null) {
                            this.attributeMap.put("modelInstance", model);
                        }
                    }
                    catch (Exception exception) {}
                }
                this.attributeMap.put(attrName, attrValue);
                ++n2;
            }
            String modelName = (String)this.attributeMap.get(MODEL_NAME_ATTRIBUTE);
            this.modelMap.put(modelName, this.attributeMap);
            IConfigurationElement[] children = element.getChildren();
            if (children.length > 0) {
                this.elementStack.push(modelName);
                int i = 0;
                while (i < children.length) {
                    this.addElement(children[i]);
                    ++i;
                }
                this.elementStack.pop();
            }
        } else if (elementName.equals("filter")) {
            if (this._configMap.containsKey(elementName)) {
                this.setSymbolPool(elementName);
                this.filterMap = (HashMap)this._configMap.get(elementName);
            } else {
                this.createSymbolPool(elementName);
                this.filterMap = new HashMap();
                this._configMap.put(elementName, this.filterMap);
            }
            this.attributeMap = new HashMap();
            String[] stringArray = element.getAttributeNames();
            int n = stringArray.length;
            int children = 0;
            while (children < n) {
                String attrName = stringArray[children];
                String attrValue = element.getAttribute(attrName);
                this.attributeMap.put(attrName, attrValue);
                ++children;
            }
            String filterModel = (String)this.attributeMap.get("model");
            this.filterMap.put(filterModel, this.attributeMap);
        } else if (elementName.equals(ALIAS_ID)) {
            String key = element.getAttribute(MODEL_NAME_ATTRIBUTE);
            String value = element.getAttribute("value");
            this.setParameter(key, value);
        } else {
            throw new ConfigurationException("addElement - unknown element " + elementName);
        }
    }

    protected Map addConfigurationData(Object data, Map configMap) throws ConfigurationException {
        this._configMap = configMap;
        this.addConfigurationData(data);
        return this._configMap;
    }
}

