/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class FieldOp
implements ILowVisionOperator {
    public static final short TYPE_CIRCLE_INT = 1;
    public static final short TYPE_CIRCLE_FLOAT = 2;
    public static final float CIRCLE_WIDTH = 20.0f;
    BufferedImage filterImage;
    short type = 0;
    int diameterInt;
    float diameterFloat;

    public FieldOp(short s) {
        this.type = s;
    }

    public FieldOp(short s, int n) throws LowVisionException {
        this(s);
        if (this.type != 1) {
            throw new LowVisionException("The type is unknown, or the type and the parameter(s) do not match: type = " + s + ", param = " + n);
        }
        this.diameterInt = n;
    }

    public FieldOp(short s, float f) throws LowVisionException {
        this(s);
        if (this.type != 2) {
            throw new LowVisionException("The type is unknown, or the type and the parameter(s) do not match: type = " + s + ", param = " + f);
        }
        this.diameterFloat = f;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws LowVisionException {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.createFilterImage(this.type, n, n2);
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage3 = new BufferedImage(n, n2, 1);
        }
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(this.filterImage, null, 0, 0);
        return bufferedImage3;
    }

    private void createFilterImage(short s, int n, int n2) throws LowVisionException {
        this.filterImage = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster = this.filterImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int[][] nArray2 = null;
        if (s == 1) {
            nArray2 = this.getCircleAlphaField(n, n2, (float)this.diameterInt / (float)n);
        } else if (s == 2) {
            nArray2 = this.getCircleAlphaField(n, n2, this.diameterFloat);
        } else {
            throw new LowVisionException("Unknown field type: " + s);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray[n3] = nArray2[n4][n5] << 24 & 0xFF000000;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        this.filterImage.setData(writableRaster);
    }

    private int[][] getCircleAlphaField(int n, int n2, float f) {
        int[][] nArray = new int[n2][n];
        float f2 = (float)n * f / 2.0f;
        float f3 = 0.0f;
        if (f2 > 20.0f) {
            f3 = f2 - 20.0f;
        }
        float f4 = (float)n / 2.0f;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                float f5 = (float)n4 - f4;
                float f6 = (float)n3 - f4;
                float f7 = (float)Math.sqrt(f5 * f5 + f6 * f6);
                int n5 = Math.round((f7 - f3) / (f2 - f3) * 255.0f);
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 > 255) {
                    n5 = 255;
                }
                nArray[n3][n4] = n5;
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }
}

