/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;

public class Vector3D {
    double x;
    double y;
    double z;

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public static boolean isZeroVector(Vector3D vector3D) {
        return vector3D.x == 0.0 && vector3D.y == 0.0 && vector3D.z == 0.0;
    }

    public boolean isZeroVector() {
        return Vector3D.isZeroVector(this);
    }

    public static double magnitude2(Vector3D vector3D) {
        return vector3D.x * vector3D.x + vector3D.y * vector3D.y + vector3D.z * vector3D.z;
    }

    public double magnitude2() {
        return Vector3D.magnitude2(this);
    }

    public static double magnitude(Vector3D vector3D) {
        return Math.sqrt(Vector3D.magnitude2(vector3D));
    }

    public double magnitude() {
        return Vector3D.magnitude(this);
    }

    public static Vector3D add(Vector3D vector3D, Vector3D vector3D2) {
        return new Vector3D(vector3D.x + vector3D2.x, vector3D.y + vector3D2.y, vector3D.z + vector3D2.z);
    }

    public Vector3D add(Vector3D vector3D) {
        return Vector3D.add(this, vector3D);
    }

    public static Vector3D subtract(Vector3D vector3D, Vector3D vector3D2) {
        return new Vector3D(vector3D.x - vector3D2.x, vector3D.y - vector3D2.y, vector3D.z - vector3D2.z);
    }

    public Vector3D subtractFrom(Vector3D vector3D) {
        return Vector3D.subtract(vector3D, this);
    }

    public Vector3D subtractedBy(Vector3D vector3D) {
        return Vector3D.subtract(this, vector3D);
    }

    public static double innerProduct(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.x * vector3D2.x + vector3D.y * vector3D2.y + vector3D.z * vector3D2.z;
    }

    public static double cosine(Vector3D vector3D, Vector3D vector3D2) throws ImageException {
        if (Vector3D.isZeroVector(vector3D) || Vector3D.isZeroVector(vector3D2)) {
            throw new ImageException("Cannot calculate cosine of zero-vectors");
        }
        double d = Vector3D.innerProduct(vector3D, vector3D2) / (Vector3D.magnitude(vector3D) * Vector3D.magnitude(vector3D2));
        if (d < -1.0) {
            d = -1.0;
        } else if (1.0 < d) {
            d = 1.0;
        }
        return d;
    }

    public double cosine(Vector3D vector3D) throws ImageException {
        return Vector3D.cosine(this, vector3D);
    }

    public static double angle(Vector3D vector3D, Vector3D vector3D2) throws ImageException {
        return Math.acos(Vector3D.cosine(vector3D, vector3D2));
    }

    public double angle(Vector3D vector3D) throws ImageException {
        return Vector3D.angle(this, vector3D);
    }

    public static double sine(Vector3D vector3D, Vector3D vector3D2) throws ImageException {
        return Math.sin(Vector3D.angle(vector3D, vector3D2));
    }

    public double sine(Vector3D vector3D) throws ImageException {
        return Vector3D.sine(this, vector3D);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("-----");
        printWriter.println("dumping Vector3D");
        printWriter.println("(x,y,z) = ( " + this.x + ", " + this.y + ", " + this.z + ")");
        printWriter.println("-----");
    }
}

