/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProblemItemLV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowVisionProblemConverter {
    public static List<IProblemItem> convert(LowVisionProblemGroup[] lowVisionProblemGroupArray, String string, int n) {
        ArrayList<IProblemItem> arrayList = new ArrayList<IProblemItem>();
        int n2 = 0;
        while (n2 < lowVisionProblemGroupArray.length) {
            ProblemItemLV problemItemLV;
            ColorProblem colorProblem;
            int n3 = lowVisionProblemGroupArray[n2].getLowVisionProblemType();
            if (n3 == 1) {
                colorProblem = (ColorProblem)lowVisionProblemGroupArray[n2].getRepresentative();
                problemItemLV = new ProblemItemLV("L_" + lowVisionProblemGroupArray[n2].getLowVisionProblemType() + "." + colorProblem.getLevel());
                problemItemLV.setTargetNode(colorProblem.getElement());
                problemItemLV.setTargetString(colorProblem.getAdditionalDescription());
            } else {
                problemItemLV = new ProblemItemLV("L_" + lowVisionProblemGroupArray[n2].getLowVisionProblemType());
            }
            problemItemLV.setSubType(n3);
            try {
                switch (n3) {
                    case 10: {
                        colorProblem = (ColorProblem)lowVisionProblemGroupArray[n2].getRepresentative();
                        problemItemLV.setTargetNode(colorProblem.getElement());
                        problemItemLV.setTargetString(colorProblem.getAdditionalDescription());
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        problemItemLV.setDescription(lowVisionProblemGroupArray[n2].getDescription());
                        if (lowVisionProblemGroupArray[n2].getRepresentative() != null) {
                            problemItemLV.setTargetNode(lowVisionProblemGroupArray[n2].getRepresentative().getElement());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                problemItemLV.setDescription("unknown");
            }
            problemItemLV.setCanHighlight(true);
            problemItemLV.setFrameId(n);
            problemItemLV.setFrameUrl(string);
            problemItemLV.setSeverityLV(lowVisionProblemGroupArray[n2].getIntProbability());
            problemItemLV.setForeground(LowVisionProblemConverter.getLVProblemColorString(lowVisionProblemGroupArray[n2], true));
            problemItemLV.setBackground(LowVisionProblemConverter.getLVProblemColorString(lowVisionProblemGroupArray[n2], false));
            problemItemLV.setX(lowVisionProblemGroupArray[n2].getX());
            problemItemLV.setY(lowVisionProblemGroupArray[n2].getY());
            problemItemLV.setWidth(lowVisionProblemGroupArray[n2].getWidth());
            problemItemLV.setHeight(lowVisionProblemGroupArray[n2].getHeight());
            problemItemLV.setArea(lowVisionProblemGroupArray[n2].getWidth() * lowVisionProblemGroupArray[n2].getHeight());
            arrayList.add((IProblemItem)problemItemLV);
            ++n2;
        }
        return arrayList;
    }

    private static String getLVProblemColorString(LowVisionProblemGroup lowVisionProblemGroup, boolean bl) {
        int n = lowVisionProblemGroup.getLowVisionProblemType();
        if (n == 1 || n == 10) {
            ColorProblem colorProblem = (ColorProblem)lowVisionProblemGroup.getRepresentative();
            int n2 = bl ? colorProblem.getForegroundColor() : colorProblem.getBackgroundColor();
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return String.valueOf(n3) + "," + n4 + "," + n5;
        }
        return " ";
    }
}

