/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision.image;

import java.io.InputStream;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.SimulatedPageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.BMPReader;

public class PageImageFactory {
    public static IPageImage createPageImage() {
        return new PageImage();
    }

    public static IPageImage createSimulationPageImage(IPageImage iPageImage, LowVisionType lowVisionType) throws ImageException {
        return new SimulatedPageImage(iPageImage, lowVisionType);
    }

    public static IPageImage createPageImage(String string) {
        return PageImageFactory.createPageImage(string, false);
    }

    public static IPageImage createPageImage(String string, boolean bl) {
        Int2D int2D = new Int2D(0, 0);
        try {
            int2D = BMPReader.readInt2D(string);
            PageImage pageImage = new PageImage(int2D, bl);
            int2D = null;
            return pageImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPageImage createPageImage(InputStream inputStream) {
        return PageImageFactory.createPageImage(inputStream, false);
    }

    public static IPageImage createPageImage(InputStream inputStream, boolean bl) {
        Int2D int2D = new Int2D(0, 0);
        try {
            int2D = BMPReader.readInt2D(inputStream);
            PageImage pageImage = new PageImage(int2D, bl);
            int2D = null;
            return pageImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized IPageImage joinPageImages(IPageImage[] iPageImageArray) {
        Int2D int2D = new Int2D(0, 0);
        int n = 0;
        int n2 = 0;
        if (iPageImageArray != null) {
            int n3 = 0;
            while (n3 < iPageImageArray.length) {
                if (n < iPageImageArray[n3].getWidth()) {
                    n = iPageImageArray[n3].getWidth();
                }
                n2 += iPageImageArray[n3].getHeight();
                ++n3;
            }
            int2D = new Int2D(n, n2);
            n3 = 0;
            int n4 = 0;
            while (n4 < iPageImageArray.length) {
                IInt2D iInt2D = ((PageImage)iPageImageArray[n4]).getInt2D();
                int n5 = 0;
                while (n5 < iInt2D.getHeight()) {
                    System.arraycopy(iInt2D.getData()[n5], 0, int2D.getData()[n3 + n5], 0, iInt2D.getWidth());
                    ++n5;
                }
                n3 += iInt2D.getHeight();
                ++n4;
            }
        }
        return new PageImage(int2D);
    }
}

