/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PlatformUIUtil {
    public static IWorkbenchWindow getActiveWindow() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUIUtil.getActiveWindow();
        if (iWorkbenchWindow != null) {
            try {
                return iWorkbenchWindow.getActivePage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static Shell getShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUIUtil.getActiveWindow();
        if (iWorkbenchWindow != null) {
            try {
                return iWorkbenchWindow.getShell();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String getActivePerspectiveId() {
        try {
            return PlatformUIUtil.getActivePage().getPerspective().getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IWorkbenchPage showPerspective(String string) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUIUtil.getActiveWindow();
        if (iWorkbenchWindow != null) {
            try {
                if (string != null) {
                    return PlatformUI.getWorkbench().showPerspective(string, iWorkbenchWindow);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage != null) {
            try {
                return iWorkbenchPage.getActiveEditor();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isViewVisible(String string) {
        IViewReference iViewReference;
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage != null && (iViewReference = iWorkbenchPage.findViewReference(string)) != null) {
            return iWorkbenchPage.isPartVisible(iViewReference.getPart(false));
        }
        return false;
    }

    public static IViewPart showView(String string) {
        IWorkbenchPage iWorkbenchPage;
        if (string != null && (iWorkbenchPage = PlatformUIUtil.getActivePage()) != null) {
            try {
                return iWorkbenchPage.showView(string);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
        return null;
    }

    public static IAction getGlobalActionHandler(String string, String string2) {
        IWorkbenchPage iWorkbenchPage = PlatformUIUtil.getActivePage();
        if (iWorkbenchPage != null) {
            try {
                IWorkbenchPartSite iWorkbenchPartSite;
                IViewPart iViewPart = iWorkbenchPage.findView(string);
                if (iViewPart != null && (iWorkbenchPartSite = iViewPart.getSite()) instanceof IViewSite) {
                    return ((IViewSite)iWorkbenchPartSite).getActionBars().getGlobalActionHandler(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static IWorkbenchHelpSystem getHelpSystem() {
        try {
            return PlatformUI.getWorkbench().getHelpSystem();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static URL resolveHelpURL(String string, boolean bl) {
        IWorkbenchHelpSystem iWorkbenchHelpSystem = PlatformUIUtil.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            return iWorkbenchHelpSystem.resolve(string, bl);
        }
        return null;
    }

    public static ISharedImages getSharedImages() {
        try {
            return PlatformUI.getWorkbench().getSharedImages();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ImageDescriptor getSharedImageDescriptor(String string) {
        try {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

