/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editor.actions;

import java.util.Map;
import org.eclipse.actf.model.internal.ui.FavoritesChangeEvent;
import org.eclipse.actf.model.internal.ui.FavoritesUtil;
import org.eclipse.actf.model.internal.ui.editor.actions.FavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.dialogs.FavoritesAddDialog;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFavoritesAction
extends FavoritesAction {
    public static final String ID = AddFavoritesAction.class.getName();
    private IWorkbenchWindow _window;

    public AddFavoritesAction(IWorkbenchWindow iWorkbenchWindow, Map<String, String> map) {
        this._window = iWorkbenchWindow;
        this.setId(ID);
        this.setText(ModelServiceMessages.MenuConst_AddFavorites);
    }

    public void run() {
        if (this._window != null) {
            IModelService iModelService = ModelServiceUtils.getActiveModelService();
            if (iModelService == null) {
                return;
            }
            String string = iModelService.getURL();
            if (iModelService instanceof IWebBrowserACTF) {
                string = ((IWebBrowserACTF)iModelService).getLocationName();
            }
            Map<String, String> map = FavoritesUtil.getFavoritesMap();
            FavoritesAddDialog favoritesAddDialog = new FavoritesAddDialog(this._window.getShell(), map, string);
            int n = favoritesAddDialog.open();
            if (n == 0) {
                String string2 = iModelService.getURL();
                map.put(favoritesAddDialog.getName(), string2);
                FavoritesUtil.saveFavoritesMap(map);
                FavoritesChangeEvent favoritesChangeEvent = new FavoritesChangeEvent((Object)this, map);
                this.fireFavoritesChanged(favoritesChangeEvent);
            }
        }
    }
}

