/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;

public abstract class CompositeModelGroup
implements IModelGroup {
    protected IModelGroup[] children = new IModelGroup[128];
    protected int childLength;
    private boolean[] hash = null;

    public void refer(boolean bl) {
        int n = 0;
        while (n < this.childLength) {
            this.children[n].refer(bl);
            ++n;
        }
    }

    protected CompositeModelGroup(IModelGroup iModelGroup) {
        this.children[0] = iModelGroup;
        this.childLength = 1;
        iModelGroup.refer(false);
    }

    public boolean match(int n) {
        return this.hash[n];
    }

    public boolean[] rehash(int n) {
        if (this.hash != null) {
            return this.hash;
        }
        this.hash = new boolean[n];
        int n2 = this.childLength - 1;
        while (n2 >= 0) {
            boolean[] blArray = this.children[n2].rehash(n);
            if (blArray != null) {
                int n3 = n - 1;
                while (n3 >= 0) {
                    int n4 = n3;
                    this.hash[n4] = this.hash[n4] | blArray[n3];
                    --n3;
                }
            }
            --n2;
        }
        return this.hash;
    }

    public int getChildLength() {
        return this.childLength;
    }
}

