/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticABBRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticAREARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticBRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticBUTTONRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticDefaultRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticFORMRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticHRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticIMGRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticINPUTRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticMAPRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticNoRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticOPTIONRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticPRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticSELECTRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTABLERenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTDRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTEXTAREARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.TextUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWATCore {
    private static MessageCollection mc = null;
    private static String uriPrefix = null;
    private static Map<String, IElementRenderer> elementMap = new HashMap<String, IElementRenderer>();
    static final int IMG_ELEMENT = 0;
    static final int A_ELEMENT = 1;
    private static IElementRenderer defaultRenderer = new StaticDefaultRenderer();

    static {
        elementMap.put("img", new StaticIMGRenderer());
        elementMap.put("a", new StaticARenderer());
        elementMap.put("td", new StaticTDRenderer());
        elementMap.put("form", new StaticFORMRenderer());
        elementMap.put("select", new StaticSELECTRenderer());
        elementMap.put("input", new StaticINPUTRenderer());
        elementMap.put("button", new StaticBUTTONRenderer());
        elementMap.put("br", new StaticBRRenderer());
        elementMap.put("table", new StaticTABLERenderer());
        elementMap.put("area", new StaticAREARenderer());
        elementMap.put("map", new StaticMAPRenderer());
        elementMap.put("head", new StaticNoRenderer());
        elementMap.put("script", new StaticNoRenderer());
        elementMap.put("noscript", new StaticNoRenderer());
        elementMap.put("tr", new StaticTRRenderer());
        elementMap.put("tbody", new StaticTRRenderer());
        elementMap.put("p", new StaticPRenderer());
        elementMap.put("th", new StaticTDRenderer());
        elementMap.put("div", new StaticTDRenderer());
        elementMap.put("li", new StaticTDRenderer());
        elementMap.put("h1", new StaticHRenderer());
        elementMap.put("h2", new StaticHRenderer());
        elementMap.put("h3", new StaticHRenderer());
        elementMap.put("h4", new StaticHRenderer());
        elementMap.put("h5", new StaticHRenderer());
        elementMap.put("h6", new StaticHRenderer());
        elementMap.put("abbr", new StaticABBRRenderer());
        elementMap.put("acronym", new StaticABBRRenderer());
        elementMap.put("option", new StaticOPTIONRenderer());
        elementMap.put("textarea", new StaticTEXTAREARenderer());
    }

    public MessageCollection setJwatMode(int n, String string) {
        try {
            if (mc != null && mc.size() > 0) {
                mc.clear();
            }
            mc = OutLoud.createMessageCollection(n, string);
            return mc;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public PacketCollection getPacketCollection(Node node) {
        try {
            PacketCollection packetCollection = this.getPacketCollectionTraversely(node, JWATCore.getCurrentParentsStack(node));
            return packetCollection;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
    }

    private static Stack<Node> getCurrentParentsStack(Node node) {
        try {
            Stack<Node> stack = new Stack<Node>();
            Stack<Node> stack2 = new Stack<Node>();
            Node node2 = node;
            while (node2 != null) {
                stack2.push(node2);
                node2 = node2.getParentNode();
            }
            while (stack2.size() > 1) {
                stack.push((Node)stack2.pop());
            }
            return stack;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
    }

    private PacketCollection getPacketCollectionTraversely(Node node, Stack<Node> stack) {
        Context context = new Context();
        PacketCollection packetCollection = new PacketCollection();
        Node node2 = node;
        while (node2 != null) {
            PacketCollection packetCollection2 = JWATCore.getPacketCollectionOneNode(node2, context);
            if (packetCollection2 != null) {
                packetCollection.addAll(packetCollection2);
            }
            node2 = this.goNext(node2, context, stack, packetCollection);
        }
        return packetCollection;
    }

    private Node goNext(Node node, Context context, Stack<Node> stack, PacketCollection packetCollection) {
        PacketCollection packetCollection2 = null;
        if (node == null) {
            return null;
        }
        if (context.isGoChild() && node.hasChildNodes()) {
            stack.push(node);
            return node.getFirstChild();
        }
        if (node.getNextSibling() != null) {
            IElementRenderer iElementRenderer;
            if (packetCollection != null && node.getNodeType() == 1 && (iElementRenderer = JWATCore.getElementRenderer((Element)node)) != null && (packetCollection2 = iElementRenderer.getPacketCollectionOut((Element)node, context, uriPrefix, mc)) != null) {
                packetCollection.addAll(packetCollection2);
            }
            return node.getNextSibling();
        }
        node = null;
        while (node == null) {
            IElementRenderer iElementRenderer;
            if (stack.size() == 0) break;
            node = stack.pop();
            if (packetCollection != null && node.getNodeType() == 1 && (iElementRenderer = JWATCore.getElementRenderer((Element)node)) != null && (packetCollection2 = iElementRenderer.getPacketCollectionOut((Element)node, context, uriPrefix, mc)) != null) {
                packetCollection.addAll(packetCollection2);
            }
            node = node.getNextSibling();
        }
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PacketCollection getPacketCollectionOneNode(Node node, Context context) {
        context.setLinkTag(false);
        context.setStartSelect(false);
        context.setStringOutput(true);
        switch (node.getNodeType()) {
            case 1: {
                return JWATCore.getPacketCollectionOneElement((Element)node, context);
            }
            case 3: {
                try {
                    String string = node.getNodeValue();
                    string = TextUtil.trim(string);
                    string = TextUtil.replace(new StringBuffer(string)).toString();
                    string = TextUtil.substitute(string, "&nbsp;", " ");
                    if (string.indexOf("<!") >= 0) return null;
                    if (string.indexOf("<%") >= 0) return null;
                    if (string.length() == 0) return null;
                    context.setLineDelimiter(false);
                    return new PacketCollection(new Packet(node, string, context, true));
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
        }
        return null;
    }

    private static PacketCollection getPacketCollectionOneElement(Element element, Context context) {
        PacketCollection packetCollection = null;
        try {
            packetCollection = JWATCore.getElementRenderer(element).getPacketCollectionIn(element, context, uriPrefix, mc);
            return packetCollection;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private static IElementRenderer getElementRenderer(Element element) {
        String string = element.getNodeName().toLowerCase();
        IElementRenderer iElementRenderer = null;
        iElementRenderer = elementMap.get(string);
        if (iElementRenderer == null) {
            iElementRenderer = defaultRenderer;
        }
        return iElementRenderer;
    }

    public int getNodePosition(Node node, PacketCollection packetCollection) {
        if (packetCollection == null) {
            return 0;
        }
        try {
            Context context = new Context();
            PacketCollection packetCollection2 = new PacketCollection();
            Node node2 = node;
            Stack<Node> stack = JWATCore.getCurrentParentsStack(node);
            while (node2 != null) {
                PacketCollection packetCollection3 = JWATCore.getPacketCollectionOneNode(node2, context);
                if (packetCollection3 != null) {
                    packetCollection2.addAll(packetCollection3);
                    break;
                }
                node2 = this.goNext(node2, context, stack, packetCollection2);
            }
            int n = packetCollection.size();
            Node node3 = ((IPacket)packetCollection2.get(0)).getNode();
            int n2 = 0;
            while (n2 < n) {
                if (node3 == ((IPacket)packetCollection.get(n2)).getNode()) {
                    return n2;
                }
                ++n2;
            }
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return 0;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return 0;
        }
    }

    public int getAnchorPosition(String string, Node node, PacketCollection packetCollection) {
        if (packetCollection == null) {
            return 0;
        }
        try {
            int n = 0;
            Node node2 = null;
            NodeList nodeList = ((Element)node).getElementsByTagName("a");
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                String string2;
                node2 = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("name");
                if (node3 != null && string.equals(string2 = node3.getNodeValue())) break;
                ++n2;
            }
            if (node2 != null) {
                n = this.getNodePosition(node2, packetCollection);
            }
            return n;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return 0;
        }
    }

    public String getHrefString(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2;
        String string = null;
        if (node.getNodeType() == 1 && (node.getNodeName().toLowerCase().equals("a") || node.getNodeName().toLowerCase().equals("area")) && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem("href")) != null) {
            string = node2.getNodeValue();
        }
        return string;
    }

    public Node getTargetNode(Node node, Node node2) {
        String string = this.getHrefString(node);
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '#') {
                String string2 = string.substring(1, string.length());
                if (node != null) {
                    NodeList nodeList = ((Element)node2).getElementsByTagName("a");
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        String string3;
                        Node node3 = nodeList.item(n);
                        NamedNodeMap namedNodeMap = node3.getAttributes();
                        Node node4 = namedNodeMap.getNamedItem("name");
                        if (node4 != null && string2.equals(string3 = node4.getNodeValue())) {
                            return node3;
                        }
                        ++n;
                    }
                }
                return node;
            }
            return null;
        }
        return null;
    }

    public static void setUriPrefix(String string) {
        uriPrefix = string;
    }
}

