/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.actf.model.dom.dombycom.IElementEx;
import org.eclipse.actf.model.internal.ui.editors.ie.CurrentStylesImpl;
import org.eclipse.actf.model.internal.ui.editors.ie.WebBrowserIEImpl;
import org.eclipse.actf.model.ui.ModelServiceSizeInfo;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserStyleInfo;
import org.eclipse.actf.util.dom.TreeWalkerImpl;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBrowserStyleInfoImpl
implements IWebBrowserStyleInfo {
    private static final String TAG_HEAD = "HEAD";
    private final WebBrowserIEImpl browser;

    public WebBrowserStyleInfoImpl(WebBrowserIEImpl webBrowserIEImpl) {
        this.browser = webBrowserIEImpl;
    }

    public HashMap<String, ICurrentStyles> getCurrentStyles() {
        HashMap<String, ICurrentStyles> hashMap = new HashMap<String, ICurrentStyles>(512);
        Document document = this.browser.getLiveDocument();
        TreeWalkerImpl treeWalkerImpl = new TreeWalkerImpl((Node)document, 1, new NodeFilter(){

            public short acceptNode(Node node) {
                if (WebBrowserStyleInfoImpl.TAG_HEAD.equalsIgnoreCase(node.getNodeName())) {
                    return 2;
                }
                return 1;
            }
        }, false);
        Node node = treeWalkerImpl.nextNode();
        URL uRL = null;
        try {
            uRL = new URL(this.browser.getURL());
        }
        catch (MalformedURLException malformedURLException) {}
        while (node != null) {
            if (node instanceof IElementEx) {
                CurrentStylesImpl currentStylesImpl = new CurrentStylesImpl((IElementEx)node, uRL);
                hashMap.put(currentStylesImpl.getXPath(), currentStylesImpl);
            }
            node = treeWalkerImpl.nextNode();
        }
        return hashMap;
    }

    public RGB getUnvisitedLinkColor() {
        return this.browser.getAnchorColor();
    }

    public RGB getVisitedLinkColor() {
        return this.browser.getVisitedAnchorColor();
    }

    public ModelServiceSizeInfo getSizeInfo(boolean bl) {
        return this.browser.getBrowserSize(bl);
    }
}

