/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal;

import java.io.PrintStream;
import org.eclipse.tea.core.annotations.TaskCaptureStdOutput;
import org.eclipse.tea.core.services.TaskingLog;

public class OutputRedirector {
    private final TaskingLog log;
    private final TaskCaptureStdOutput annotation;
    private final PrintStream origErr;
    private final PrintStream origOut;

    public OutputRedirector(Object task, TaskingLog log) {
        this.log = log;
        this.annotation = task.getClass().getAnnotation(TaskCaptureStdOutput.class);
        this.origOut = System.out;
        this.origErr = System.err;
    }

    public void begin() {
        if (this.annotation == null) {
            return;
        }
        if (this.annotation.out()) {
            System.setOut(this.log.info());
        }
        if (this.annotation.err()) {
            if (this.annotation.errToOut()) {
                System.setErr(System.out);
            } else {
                System.setErr(this.log.error());
            }
        }
    }

    public void finish() {
        System.setOut(this.origOut);
        System.setErr(this.origErr);
    }
}

