/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateSiteCategory {
    public static void generateCategory(Document categoryXml, String name, String label) {
        Element root = categoryXml.getDocumentElement();
        Element cat = categoryXml.createElement("category-def");
        cat.setAttribute("name", name);
        cat.setAttribute("label", label);
        root.appendChild(cat);
    }

    public static void generateCategorization(Document categoryXml, String featureRelUrl, String featureId, String featureVersion, String categoryName) {
        Element root = categoryXml.getDocumentElement();
        Element feat = categoryXml.createElement("feature");
        feat.setAttribute("url", featureRelUrl);
        feat.setAttribute("id", featureId);
        feat.setAttribute("version", featureVersion);
        root.appendChild(feat);
        Element cat = categoryXml.createElement("category");
        cat.setAttribute("name", categoryName);
        feat.appendChild(cat);
    }

    public static Document generateCategoryHeader() throws ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("site");
        doc.appendChild(root);
        return doc;
    }

    public static void generateCategoryXml(File categoryFile, Map<String, String> featureIdToCategory, WorkspaceBuild wb, JarManager jm) throws Exception {
        Document doc = UpdateSiteCategory.generateCategoryHeader();
        featureIdToCategory.values().stream().distinct().forEach(n -> UpdateSiteCategory.generateCategory(doc, n, n));
        for (Map.Entry<String, String> entry : featureIdToCategory.entrySet()) {
            FeatureBuild feature = wb.getFeature(entry.getKey());
            String version = ((FeatureData)feature.getData()).getBundleVersion();
            String name = feature.getFeatureName();
            UpdateSiteCategory.generateCategorization(doc, "features/" + name + "_" + version + ".jar", name, version, entry.getValue());
        }
        Element root = doc.getDocumentElement();
        if (root.getChildNodes().getLength() <= 0) {
            throw new Exception("Malformed " + categoryFile);
        }
        FileUtils.delete(categoryFile);
        FileUtils.writeXml(doc, categoryFile);
    }
}

