/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.debug.ui.ITCFRegister;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.IDetailsProvider;
import org.eclipse.tcf.internal.debug.ui.model.IWatchInExpressions;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelFonts;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IRegisters;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFNodeRegister
extends TCFNode
implements IElementEditor,
IWatchInExpressions,
IDetailsProvider,
ITCFRegister {
    public static final String PROPERTY_REG_REPRESENTATION = "PROPERTY_REGISTER_REPRESENTATION";
    private final TCFChildrenRegisters children;
    private final TCFNode.TCFData<IRegisters.RegistersContext> context;
    private final TCFNode.TCFData<String> expression_text;
    private final TCFNode.TCFData<byte[]> value;
    private final boolean is_stack_frame_register;
    private byte[] prev_value;
    private byte[] next_value;
    private int index;
    private static final ICellModifier cell_modifier = new ICellModifier(){
        private Object original_value;

        public boolean canModify(Object element, final String property) {
            final TCFNodeRegister node = (TCFNodeRegister)element;
            try {
                return (Boolean)new TCFTask<Boolean>(){

                    public void run() {
                        if (!node.context.validate((Runnable)((Object)this))) {
                            return;
                        }
                        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                        if (ctx != null && ctx.isWriteable()) {
                            if (!ctx.isReadable() || ctx.isReadOnce()) {
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (!node.value.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.value.getError() == null) {
                                if ("HexValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidHexNumber(node.toNumberString(16)) == null);
                                    return;
                                }
                                if ("DecValue".equals(property)) {
                                    this.done(TCFNumberFormat.isValidDecNumber(true, node.toNumberString(10)) == null);
                                    return;
                                }
                            }
                        }
                        this.done(Boolean.FALSE);
                    }
                }.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return false;
            }
        }

        public Object getValue(Object element, final String property) {
            block3: {
                this.original_value = null;
                final TCFNodeRegister node = (TCFNodeRegister)element;
                try {
                    this.original_value = new TCFTask<String>(){

                        public void run() {
                            if (!node.context.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                            if (!ctx.isReadable() || ctx.isReadOnce()) {
                                this.done("");
                                return;
                            }
                            if (!node.value.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (node.value.getError() == null) {
                                if ("HexValue".equals(property)) {
                                    this.done(node.toNumberString(16));
                                    return;
                                }
                                if ("DecValue".equals(property)) {
                                    this.done(node.toNumberString(10));
                                    return;
                                }
                            }
                            this.done(null);
                        }
                    }.get(1L, TimeUnit.SECONDS);
                    if (!"".equals(this.original_value)) break block3;
                    this.original_value = null;
                    return "0";
                }
                catch (Exception e) {
                    return null;
                }
            }
            return this.original_value;
        }

        public void modify(Object element, final String property, final Object value) {
            if (value == null) {
                return;
            }
            if (this.original_value != null && this.original_value.equals(value)) {
                return;
            }
            final TCFNodeRegister node = (TCFNodeRegister)element;
            try {
                new TCFTask<Boolean>(){

                    public void run() {
                        try {
                            if (!node.context.validate((Runnable)((Object)this))) {
                                return;
                            }
                            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)node.context.getData();
                            if (ctx != null && ctx.isWriteable()) {
                                byte[] bf = null;
                                boolean is_float = ctx.isFloat();
                                int size = ctx.getSize();
                                boolean big_endian = ctx.isBigEndian();
                                String input = (String)value;
                                String error = null;
                                int[] bits = ctx.getBitNumbers();
                                if (bits != null) {
                                    size = (bits.length + 7) / 8;
                                }
                                if ("HexValue".equals(property)) {
                                    if (input.startsWith("0x")) {
                                        input = input.substring(2);
                                    }
                                    if ((error = TCFNumberFormat.isValidHexNumber(input)) == null) {
                                        bf = TCFNumberFormat.toByteArray(input, 16, false, size, false, big_endian);
                                    }
                                } else if ("DecValue".equals(property) && (error = TCFNumberFormat.isValidDecNumber(is_float, input)) == null) {
                                    bf = TCFNumberFormat.toByteArray(input, 10, is_float, size, is_float, big_endian);
                                }
                                if (error != null) {
                                    throw new Exception("Invalid value: " + value, new Exception(error));
                                }
                                if (bf != null) {
                                    if (bits != null) {
                                        TCFNodeRegister p = (TCFNodeRegister)node.parent;
                                        if (!p.value.validate((Runnable)((Object)this))) {
                                            return;
                                        }
                                        byte[] parent_value = (byte[])p.value.getData();
                                        if (!p.context.validate((Runnable)((Object)this))) {
                                            return;
                                        }
                                        IRegisters.RegistersContext parent_context = (IRegisters.RegistersContext)p.context.getData();
                                        if (parent_context != null && parent_value != null) {
                                            byte[] new_value = new byte[parent_value.length];
                                            System.arraycopy(parent_value, 0, new_value, 0, parent_value.length);
                                            int pos = 0;
                                            while (pos < bits.length) {
                                                int bit = bits[pos];
                                                if (bit / 8 < new_value.length) {
                                                    if ((bf[pos / 8] & 1 << pos % 8) == 0) {
                                                        int n = bit / 8;
                                                        new_value[n] = (byte)(new_value[n] & ~(1 << bit % 8));
                                                    } else {
                                                        int n = bit / 8;
                                                        new_value[n] = (byte)(new_value[n] | 1 << bit % 8);
                                                    }
                                                }
                                                ++pos;
                                            }
                                            parent_context.set(new_value, new IRegisters.DoneSet(){

                                                public void doneSet(IToken token, Exception error) {
                                                    TCFNodeRegister p = (TCFNodeRegister)node.parent;
                                                    if (error != null) {
                                                        p.model.showMessageBox("Cannot modify register value", error);
                                                        this.done(Boolean.FALSE);
                                                    } else {
                                                        p.value.reset();
                                                        p.postStateChangedDelta();
                                                        this.done(Boolean.TRUE);
                                                    }
                                                }
                                            });
                                            return;
                                        }
                                    } else {
                                        ctx.set(bf, new IRegisters.DoneSet(){

                                            public void doneSet(IToken token, Exception error) {
                                                if (error != null) {
                                                    node.model.showMessageBox("Cannot modify register value", error);
                                                    this.done(Boolean.FALSE);
                                                } else {
                                                    node.value.reset();
                                                    node.postStateChangedDelta();
                                                    this.done(Boolean.TRUE);
                                                }
                                            }
                                        });
                                        return;
                                    }
                                }
                            }
                            this.done(Boolean.FALSE);
                        }
                        catch (Throwable x) {
                            node.model.showMessageBox("Cannot modify register value", x);
                            this.done(Boolean.FALSE);
                        }
                    }
                }.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                node.model.showMessageBox("Timeout modifying register value", new Exception("No response for 10 seconds."));
            }
            catch (Exception e) {
                node.model.showMessageBox("Error modifying register value", e);
            }
        }
    };

    TCFNodeRegister(final TCFNode parent, final String id) {
        super(parent, id);
        this.is_stack_frame_register = parent instanceof TCFNodeStackFrame ? true : (parent instanceof TCFNodeRegister ? ((TCFNodeRegister)parent).is_stack_frame_register : false);
        this.children = new TCFChildrenRegisters(this);
        this.context = new TCFNode.TCFData<IRegisters.RegistersContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IRegisters regs = (IRegisters)TCFNodeRegister.this.launch.getService(IRegisters.class);
                this.command = regs.getContext(id, new IRegisters.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                        if (context != null) {
                            (this).TCFNodeRegister.this.model.getContextMap().put(id, context);
                        }
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.expression_text = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Throwable err = null;
                TCFNodeRegister n = TCFNodeRegister.this;
                ArrayList<String> names = new ArrayList<String>();
                while (true) {
                    if (!n.context.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)n.context.getData();
                    if (ctx == null) {
                        err = n.context.getError();
                        break;
                    }
                    String s = ctx.getName();
                    if (s == null) break;
                    names.add(s);
                    if (!(n.parent instanceof TCFNodeRegister)) break;
                    n = (TCFNodeRegister)n.parent;
                }
                if (names.size() == 0 || err != null) {
                    this.set(null, err, null);
                } else {
                    StringBuffer bf = new StringBuffer();
                    boolean first = true;
                    int m = names.size();
                    while (m > 0) {
                        String s = (String)names.get(--m);
                        boolean need_quotes = false;
                        int l = s.length();
                        int i = 0;
                        while (i < l) {
                            char ch = s.charAt(i);
                            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || i > 0 && (ch >= '0' && ch <= '9' || ch == '_'))) {
                                need_quotes = true;
                                break;
                            }
                            ++i;
                        }
                        if (!first) {
                            bf.append('.');
                        }
                        if (need_quotes) {
                            bf.append("$\"");
                        }
                        if (first) {
                            bf.append('$');
                        }
                        bf.append(s);
                        if (need_quotes) {
                            bf.append('\"');
                        }
                        first = false;
                    }
                    this.set(null, null, bf.toString());
                }
                return true;
            }
        };
        this.value = new TCFNode.TCFData<byte[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                Boolean b = TCFNodeRegister.this.usePrevValue((Runnable)((Object)this));
                if (b == null) {
                    return false;
                }
                if (b.booleanValue()) {
                    this.set(null, null, TCFNodeRegister.this.prev_value);
                    return true;
                }
                if (!TCFNodeRegister.this.context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)TCFNodeRegister.this.context.getData();
                if (ctx == null) {
                    this.set(null, TCFNodeRegister.this.context.getError(), null);
                    return true;
                }
                int[] bits = ctx.getBitNumbers();
                if (bits != null) {
                    TCFNodeRegister p = (TCFNodeRegister)parent;
                    if (!p.value.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    byte[] parent_value = (byte[])p.value.getData();
                    byte[] bitfield_value = null;
                    if (parent_value != null) {
                        bitfield_value = new byte[(bits.length + 7) / 8];
                        int pos = 0;
                        while (pos < bits.length) {
                            int bit = bits[pos];
                            if (bit / 8 < parent_value.length && (parent_value[bit / 8] & 1 << bit % 8) != 0) {
                                int n = pos / 8;
                                bitfield_value[n] = (byte)(bitfield_value[n] | 1 << pos % 8);
                            }
                            ++pos;
                        }
                    }
                    this.set(null, p.value.getError(), bitfield_value);
                    return true;
                }
                if (ctx.getSize() <= 0) {
                    this.set(null, TCFNodeRegister.this.context.getError(), null);
                    return true;
                }
                final 4 cache = this;
                this.command = ctx.get(new IRegisters.DoneGet(){

                    public void doneGet(IToken token, Exception error, byte[] value) {
                        if (command != token) {
                            return;
                        }
                        command = null;
                        if (error != null) {
                            Boolean b = TCFNodeRegister.this.usePrevValue((Runnable)cache);
                            if (b == null) {
                                return;
                            }
                            if (b.booleanValue()) {
                                this.set(null, null, TCFNodeRegister.this.prev_value);
                                return;
                            }
                            if (value != null && value.length <= 0) {
                                value = null;
                            }
                        }
                        this.set(null, error, value);
                    }
                });
                return false;
            }
        };
    }

    @Override
    public TCFDataCache<IRegisters.RegistersContext> getContext() {
        return this.context;
    }

    @Override
    public TCFDataCache<byte[]> getValue() {
        return this.value;
    }

    @Override
    public TCFChildren getChildren() {
        return this.children;
    }

    @Override
    public TCFDataCache<String> getExpressionText() {
        return this.expression_text;
    }

    void setIndex(int index) {
        this.index = index;
    }

    private Boolean usePrevValue(Runnable done) {
        if (this.prev_value == null) {
            return false;
        }
        TCFNode p = this.parent;
        while (p instanceof TCFNodeRegister) {
            p = p.parent;
        }
        if (p instanceof TCFNodeStackFrame) {
            TCFNodeExecContext exe = (TCFNodeExecContext)p.parent;
            TCFAction action = this.model.getActiveAction(exe.id);
            if (action != null && action.showRunning()) {
                return true;
            }
            TCFDataCache<TCFContextState> state_cache = exe.getState();
            if (!state_cache.validate(done)) {
                return null;
            }
            TCFContextState state = (TCFContextState)state_cache.getData();
            if (state == null || !state.is_suspended) {
                return true;
            }
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return null;
            }
            if (((Map)stack_trace_cache.getData()).get(p.id) == null) {
                return true;
            }
        } else if (p instanceof TCFNodeExecContext) {
            Collection access_types;
            TCFNodeExecContext exe = (TCFNodeExecContext)p;
            TCFAction action = this.model.getActiveAction(exe.id);
            if (action != null && action.showRunning()) {
                return true;
            }
            TCFDataCache<IRunControl.RunControlContext> ctx_cache = exe.getRunContext();
            if (!ctx_cache.validate(done)) {
                return null;
            }
            IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
            if (ctx_data != null && ctx_data.hasState() && ((access_types = ctx_data.getRegAccessTypes()) == null || !access_types.contains("rd-running") && !access_types.contains("rd-stop"))) {
                TCFDataCache<TCFContextState> state_cache = exe.getState();
                if (!state_cache.validate(done)) {
                    return null;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    void flushAllCaches() {
        this.prev_value = null;
        this.next_value = null;
        super.flushAllCaches();
    }

    @Override
    public boolean getDetailText(StyledStringBuffer bf, Runnable done) {
        if (!this.context.validate(done)) {
            return false;
        }
        if (!this.value.validate(done)) {
            return false;
        }
        if (this.context.getError() != null) {
            bf.append(this.context.getError(), ColorCache.rgb_error);
            return true;
        }
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        if (ctx != null) {
            bf.append(ctx.getName(), 1);
            if (ctx.getDescription() != null) {
                bf.append(": ");
                bf.append(ctx.getDescription());
            }
            bf.append('\n');
        }
        if (this.value.getError() != null) {
            bf.append(this.value.getError(), ColorCache.rgb_error);
        } else {
            byte[] v = (byte[])this.value.getData();
            if (v != null && v.length > 0) {
                bf.append("Hex: ", 1);
                bf.append(this.toNumberString(16), 4);
                bf.append(", ");
                bf.append("Dec: ", 1);
                bf.append(this.toNumberString(10), 4);
                bf.append(", ");
                bf.append("Oct: ", 1);
                bf.append(this.toNumberString(8), 4);
                if ("PC".equals(ctx.getRole())) {
                    TCFNode p = this.parent;
                    while (p != null) {
                        if (p instanceof TCFNodeExecContext) {
                            TCFNodeExecContext exe = (TCFNodeExecContext)p;
                            BigInteger addr = TCFNumberFormat.toBigInteger(v, 0, v.length, ctx.isBigEndian(), false);
                            if (exe.appendPointedObject(bf, addr, done)) break;
                            return false;
                        }
                        p = p.parent;
                    }
                }
                bf.append('\n');
                bf.append("Bin: ", 1);
                bf.append(this.toNumberString(2), 4);
                bf.append('\n');
            }
        }
        if (ctx != null) {
            int l = bf.length();
            int[] bits = ctx.getBitNumbers();
            BigInteger addr = JSON.toBigInteger((Number)ctx.getMemoryAddress());
            if (bits != null && addr == null && this.parent instanceof TCFNodeRegister) {
                if (!((TCFNodeRegister)this.parent).context.validate(done)) {
                    return false;
                }
                IRegisters.RegistersContext parent_ctx = (IRegisters.RegistersContext)((TCFNodeRegister)this.parent).context.getData();
                if (parent_ctx != null) {
                    addr = JSON.toBigInteger((Number)parent_ctx.getMemoryAddress());
                }
            }
            if (addr != null) {
                bf.append("Address: ", 1);
                bf.append("0x", 4);
                bf.append(addr.toString(16), 4);
            }
            if (bits != null) {
                if (bits.length > 0) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("Bits: ", 1);
                    bf.append("[");
                    int i = bits.length;
                    while (i > 0) {
                        if (i != bits.length) {
                            bf.append(",");
                        }
                        if (--i > 2) {
                            int j = i;
                            while (j > 0 && bits[j - 1] == bits[j] - 1) {
                                --j;
                            }
                            if (i - j >= 3) {
                                bf.append(bits[i]);
                                bf.append("..");
                                bf.append(bits[j]);
                                i = j;
                                continue;
                            }
                        }
                        bf.append(bits[i]);
                    }
                    bf.append("]");
                }
            } else {
                BigInteger size = JSON.toBigInteger((Number)ctx.getSize());
                if (size != null && size.compareTo(BigInteger.ZERO) > 0) {
                    if (l < bf.length()) {
                        bf.append(", ");
                    }
                    bf.append("Size: ", 1);
                    bf.append(size.toString(10), 4);
                    bf.append(size.compareTo(BigInteger.ONE) == 0 ? " byte" : " bytes");
                }
            }
            if (ctx.isReadable()) {
                if (l < bf.length()) {
                    bf.append(", ");
                }
                bf.append("readable");
            }
            if (ctx.isReadOnce()) {
                if (l < bf.length()) {
                    bf.append(", ");
                }
                bf.append("read once");
            }
            if (ctx.isWriteable()) {
                if (l < bf.length()) {
                    bf.append(", ");
                }
                bf.append("writable");
            }
            if (ctx.isWriteOnce()) {
                if (l < bf.length()) {
                    bf.append(", ");
                }
                bf.append("write once");
            }
            if (ctx.hasSideEffects()) {
                if (l < bf.length()) {
                    bf.append(", ");
                }
                bf.append("side effects");
            }
            if (l < bf.length()) {
                bf.append('\n');
            }
        }
        return true;
    }

    private boolean getChildren(IPresentationContext ctx, List<TCFNode> list, Runnable done) {
        Map map;
        AtomicBoolean b = new AtomicBoolean();
        if (!this.isRepresentationGroup(b, done)) {
            return false;
        }
        boolean rep_group = b.get();
        String rep_id = null;
        if (rep_group && (map = (Map)ctx.getProperty(PROPERTY_REG_REPRESENTATION)) != null) {
            rep_id = (String)map.get(this.id);
        }
        TCFNode[] tCFNodeArray = this.children.toArray();
        int n = tCFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode child = tCFNodeArray[n2];
            if (!rep_group || child.id.equals(rep_id)) {
                list.add(child);
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        ArrayList<TCFNode> list = new ArrayList<TCFNode>();
        if (!this.getChildren(result.getPresentationContext(), list, done)) {
            return false;
        }
        result.setHasChilren(list.size() > 0);
        return true;
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        ArrayList<TCFNode> list = new ArrayList<TCFNode>();
        if (!this.getChildren(result.getPresentationContext(), list, done)) {
            return false;
        }
        result.setChildCount(list.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        ArrayList<TCFNode> list = new ArrayList<TCFNode>();
        if (!this.getChildren(result.getPresentationContext(), list, done)) {
            return false;
        }
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        int n = r_offset;
        while (n < r_offset + r_length && n < list.size()) {
            result.setChild(list.get(n), n);
            ++n;
        }
        return true;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        int i;
        TCFNode.TCFData<IRegisters.RegistersContext> pending = null;
        if (!this.context.validate()) {
            pending = this.context;
        }
        if (!this.value.validate()) {
            pending = this.value;
        }
        if (pending != null) {
            pending.wait(done);
            return false;
        }
        String[] cols = result.getColumnIds();
        if (cols == null) {
            this.setLabel(result, -1, 16);
        } else {
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
            i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (ctx == null) {
                    result.setForeground(ColorCache.rgb_error, i);
                    result.setLabel("N/A", i);
                } else if (c.equals("Name")) {
                    result.setLabel(ctx.getName(), i);
                } else if (c.equals("HexValue")) {
                    this.setLabel(result, i, 16);
                } else if (c.equals("DecValue")) {
                    this.setLabel(result, i, 10);
                } else if (c.equals("Description")) {
                    result.setLabel(ctx.getDescription(), i);
                } else if (c.equals("Readable")) {
                    result.setLabel(this.bool(ctx.isReadable()), i);
                } else if (c.equals("ReadOnce")) {
                    result.setLabel(this.bool(ctx.isReadOnce()), i);
                } else if (c.equals("Writeable")) {
                    result.setLabel(this.bool(ctx.isWriteable()), i);
                } else if (c.equals("WriteOnce")) {
                    result.setLabel(this.bool(ctx.isWriteOnce()), i);
                } else if (c.equals("SideEffects")) {
                    result.setLabel(this.bool(ctx.hasSideEffects()), i);
                } else if (c.equals("Volatile")) {
                    result.setLabel(this.bool(ctx.isVolatile()), i);
                } else if (c.equals("Float")) {
                    result.setLabel(this.bool(ctx.isFloat()), i);
                } else if (c.equals("Menimonic")) {
                    result.setLabel(this.getMnemonic(ctx), i);
                }
                ++i;
            }
        }
        this.next_value = (byte[])this.value.getData();
        if (this.prev_value != null && this.next_value != null) {
            boolean changed = false;
            if (this.prev_value.length != this.next_value.length) {
                changed = true;
            } else {
                i = 0;
                while (i < this.prev_value.length) {
                    if (this.prev_value[i] != this.next_value[i]) {
                        changed = true;
                    }
                    ++i;
                }
            }
            if (changed) {
                if (cols != null) {
                    i = 1;
                    while (i < cols.length) {
                        result.setBackground(ColorCache.rgb_highlight, i);
                        ++i;
                    }
                } else {
                    result.setForeground(ColorCache.rgb_no_columns_color_change, 0);
                }
            }
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/genericregister_obj"), 0);
        return true;
    }

    private void setLabel(ILabelUpdate result, int col, int radix) {
        Throwable error;
        String name = null;
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        if (ctx != null) {
            name = ctx.getName();
        }
        if ((error = this.context.getError()) == null) {
            error = this.value.getError();
        }
        byte[] data = (byte[])this.value.getData();
        if (error != null && col >= 0) {
            result.setForeground(ColorCache.rgb_error, col);
            result.setLabel("N/A", col);
        } else if (data != null && error == null) {
            String s = this.toNumberString(radix);
            if (col >= 0) {
                result.setLabel(s, col);
            } else if (name != null) {
                result.setLabel(String.valueOf(name) + " = " + s, 0);
            }
        } else if (col < 0 && name != null) {
            result.setLabel(name, 0);
        }
    }

    @Override
    protected void getFontData(ILabelUpdate update, String view_id) {
        FontData fn = TCFModelFonts.getNormalFontData(view_id);
        String[] cols = update.getColumnIds();
        if (cols == null || cols.length == 0) {
            update.setFontData(fn, 0);
        } else {
            String[] ids = update.getColumnIds();
            int i = 0;
            while (i < cols.length) {
                if ("HexValue".equals(ids[i]) || "DecValue".equals(ids[i])) {
                    update.setFontData(TCFModelFonts.getMonospacedFontData(view_id), i);
                } else {
                    update.setFontData(fn, i);
                }
                ++i;
            }
        }
    }

    private String toNumberString(int radix) {
        String s;
        IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)this.context.getData();
        byte[] data = (byte[])this.value.getData();
        int[] bits = ctx.getBitNumbers();
        if (ctx == null || data == null) {
            return "N/A";
        }
        if (data.length == 0) {
            return "";
        }
        if (radix == 2) {
            StringBuffer bf = new StringBuffer();
            int i = data.length * 8;
            if (bits != null) {
                i = bits.length;
            }
            while (i > 0) {
                if (i % 4 == 0 && bf.length() > 0) {
                    bf.append(',');
                }
                int j = --i / 8;
                if (ctx.isBigEndian()) {
                    j = data.length - j - 1;
                }
                if ((data[j] & 1 << i % 8) != 0) {
                    bf.append('1');
                    continue;
                }
                bf.append('0');
            }
            return bf.toString();
        }
        if (radix == 10 && ctx.isFloat() && (s = TCFNumberFormat.toFPString(data, 0, data.length, ctx.isBigEndian())) != null) {
            return s;
        }
        BigInteger b = TCFNumberFormat.toBigInteger(data, ctx.isBigEndian(), false);
        String s2 = b.toString(radix);
        switch (radix) {
            case 8: {
                if (s2.startsWith("0")) break;
                s2 = "0" + s2;
                break;
            }
            case 16: {
                if (s2.length() >= (bits == null ? data.length * 2 : (bits.length + 3) / 4)) break;
                StringBuffer bf = new StringBuffer();
                while (bf.length() + s2.length() < data.length * 2) {
                    bf.append('0');
                }
                bf.append(s2);
                s2 = bf.toString();
            }
        }
        return s2;
    }

    private String bool(boolean b) {
        return b ? "yes" : "no";
    }

    private String getMnemonic(IRegisters.RegistersContext ctx) {
        IRegisters.NamedValue[] arr;
        if (this.value.getData() != null && (arr = ctx.getNamedValues()) != null) {
            IRegisters.NamedValue[] namedValueArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisters.NamedValue n3 = namedValueArray[n2];
                if (Arrays.equals(n3.getValue(), (byte[])this.value.getData())) {
                    return n3.getName();
                }
                ++n2;
            }
        }
        return "";
    }

    private void postStateChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.RegisterView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 2048);
        }
    }

    void onValueChanged() {
        this.prev_value = this.next_value;
        this.value.reset();
        TCFNode n = this.parent;
        while (n != null) {
            if (n instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)n).onRegisterValueChanged();
                break;
            }
            if (n instanceof TCFNodeRegister) {
                TCFNodeRegister r = (TCFNodeRegister)n;
                if (r.value.isValid() && r.value.getData() != null) {
                    r.value.reset();
                    r.postStateChangedDelta();
                }
            }
            n = n.parent;
        }
        this.children.onParentValueChanged();
        this.postStateChangedDelta();
    }

    void onParentValueChanged() {
        this.value.reset();
        this.children.onParentValueChanged();
        this.postStateChangedDelta();
    }

    void onSuspended(boolean func_call) {
        if (!func_call) {
            this.prev_value = this.next_value;
            this.value.reset();
            if (this.is_stack_frame_register) {
                this.children.reset();
            }
        } else if (this.value.isValid() && this.value.getError() != null) {
            this.value.reset();
        }
        this.children.onSuspended(func_call);
    }

    void onRegistersChanged() {
        this.children.onRegistersChanged();
        this.expression_text.reset();
        this.context.reset();
        this.value.reset();
    }

    public CellEditor getCellEditor(IPresentationContext context, String column_id, Object element, Composite parent) {
        assert (element == this);
        if ("HexValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        if ("DecValue".equals(column_id)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        assert (element == this);
        return cell_modifier;
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeRegister) {
            TCFNodeRegister r = (TCFNodeRegister)n;
            if (this.index < r.index) {
                return -1;
            }
            if (this.index > r.index) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }

    public boolean isRepresentationGroup(AtomicBoolean res, Runnable done) {
        res.set(false);
        HashSet<Integer> offsets = new HashSet<Integer>();
        if (!this.context.validate(done)) {
            return false;
        }
        if (!this.children.validate(done)) {
            return false;
        }
        IRegisters.RegistersContext reg_ctx = (IRegisters.RegistersContext)this.context.getData();
        if (reg_ctx == null) {
            return true;
        }
        if (reg_ctx.getSize() == 0) {
            return true;
        }
        TCFNode[] tCFNodeArray = this.children.toArray();
        int n = tCFNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode child_node = tCFNodeArray[n2];
            TCFNodeRegister child_reg = (TCFNodeRegister)child_node;
            if (!child_reg.context.validate(done)) {
                return false;
            }
            IRegisters.RegistersContext ctx = (IRegisters.RegistersContext)child_reg.context.getData();
            if (ctx != null) {
                int offs = ctx.getOffset();
                if (offs >= 0) {
                    if (!offsets.add(offs)) {
                        res.set(true);
                        return true;
                    }
                } else {
                    if (!child_reg.children.validate(done)) {
                        return false;
                    }
                    TCFNode[] tCFNodeArray2 = child_reg.children.toArray();
                    int n3 = tCFNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TCFNode grand_child_node = tCFNodeArray2[n4];
                        TCFNodeRegister grand_child_reg = (TCFNodeRegister)grand_child_node;
                        if (!grand_child_reg.context.validate(done)) {
                            return false;
                        }
                        ctx = (IRegisters.RegistersContext)grand_child_reg.context.getData();
                        if (ctx != null && (offs = ctx.getOffset()) >= 0 && !offsets.add(offs)) {
                            res.set(true);
                            return true;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return true;
    }
}

